/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.elasticitylistView;

import android.content.res.Resources;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Point;
import java.util.ArrayList;

public class PointAnimUtilHelper {
    public static float CIRCLE_RADIU;
    public static int CIRCLE_SPACING;
    public static int POINT_OFFSET;
    private final View mTargetView;
    private long mStartTime;
    private int mDuration = 300;
    private final Interpolator mInterpolator;
    private ArrayList<Point> mPoints;
    private boolean mSelected = false;
    private int mLayoutDir;
    private int mCenterX;
    private int mCenterY;
    public static final int STATE_UNSELECTED = 1;
    public static final int STATE_CHANGING = 4;
    public int mState = 1;

    public PointAnimUtilHelper(View targetView) {
        this.mTargetView = targetView;
        this.mInterpolator = new AccelerateInterpolator();
        Resources mRes = this.mTargetView.getResources();
        CIRCLE_RADIU = mRes.getDimension(R.dimen.os_overflowmenu_circle_radiu);
        CIRCLE_SPACING = (int)mRes.getDimension(R.dimen.os_overflowmenu_circle_spacing);
        POINT_OFFSET = (int)((float)CIRCLE_SPACING + 2.0f * CIRCLE_RADIU);
    }

    public void setLayoutDir(int layoutDir) {
        this.mLayoutDir = layoutDir;
    }

    public void setCetnerPosition(int x, int y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public void initCirclePosition(ArrayList points) {
        if (this.mLayoutDir == 0) {
            int cx0 = this.mCenterX + POINT_OFFSET;
            int cy0 = this.mCenterX - POINT_OFFSET;
            Point p0 = new Point(cx0, cy0, CIRCLE_RADIU);
            int cx1 = cx0;
            int cy1 = this.mCenterY;
            Point p1 = new Point(cx1, cy1, CIRCLE_RADIU);
            int cx2 = cx0;
            int cy2 = this.mCenterY + POINT_OFFSET;
            Point p2 = new Point(cx2, cy2, CIRCLE_RADIU);
            points.add(0, p0);
            points.add(1, p1);
            points.add(2, p2);
            p0.setDestPos(cx0, cy0);
            p1.setDestPos(cx1, cy1);
        } else {
            int cx0 = this.mCenterX - POINT_OFFSET;
            int cy0 = this.mCenterX - POINT_OFFSET;
            Point p0 = new Point(cx0, cy0, CIRCLE_RADIU);
            int cx1 = cx0;
            int cy1 = this.mCenterY;
            Point p1 = new Point(cx1, cy1, CIRCLE_RADIU);
            int cx2 = cx0;
            int cy2 = this.mCenterY + POINT_OFFSET;
            Point p2 = new Point(cx2, cy2, CIRCLE_RADIU);
            points.add(0, p0);
            points.add(1, p1);
            points.add(2, p2);
            p0.setDestPos(cx0, cy0);
            p1.setDestPos(cx1, cy1);
        }
        this.mPoints = points;
    }

    public void start(boolean selected, int layoutDir) {
        this.mSelected = selected;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mState = 4;
        this.update();
    }

    public void update() {
        long curTime = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(curTime - this.mStartTime) / (1.0f * (float)this.mDuration), 1.0f);
        float interpolation = this.mInterpolator.getInterpolation(t);
        if (this.mPoints.size() < 3) {
            return;
        }
        Point p0 = this.mPoints.get(0);
        Point p1 = this.mPoints.get(1);
        if (this.mLayoutDir == 0) {
            if (this.mSelected) {
                p0.x = (int)((float)p0.x1 - (float)POINT_OFFSET * interpolation);
                p0.y = (int)((float)p0.y1 + (float)POINT_OFFSET * interpolation);
                p1.x = (int)((float)p1.x1 - (float)(POINT_OFFSET * 2) * interpolation);
                p1.y = (int)((float)p1.y1 + (float)POINT_OFFSET * interpolation);
            } else {
                p0.x = (int)((float)p0.x + (float)(p0.x1 - p0.x) * interpolation);
                p0.y = (int)((float)p0.y + (float)(p0.y1 - p0.y) * interpolation);
                p1.x = (int)((float)p1.x + (float)(p1.x1 - p1.x) * interpolation);
                p1.y = (int)((float)p1.y + (float)(p1.y1 - p1.y) * interpolation);
            }
        } else if (this.mSelected) {
            p0.x = (int)((float)p0.x1 + (float)POINT_OFFSET * interpolation);
            p0.y = (int)((float)p0.y1 + (float)POINT_OFFSET * interpolation);
            p1.x = (int)((float)p1.x1 + (float)(POINT_OFFSET * 2) * interpolation);
            p1.y = (int)((float)p1.y1 + (float)POINT_OFFSET * interpolation);
        } else {
            p0.x = (int)((float)p0.x + (float)(p0.x1 - p0.x) * interpolation);
            p0.y = (int)((float)p0.y + (float)(p0.y1 - p0.y) * interpolation);
            p1.x = (int)((float)p1.x + (float)(p1.x1 - p1.x) * interpolation);
            p1.y = (int)((float)p1.y + (float)(p1.y1 - p1.y) * interpolation);
        }
        this.mTargetView.invalidate();
    }
}

