/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.view.MotionEvent;
import com.transsion.widgetslib.view.swipmenu.Horizontal;
import com.transsion.widgetslib.view.swipmenu.OverScroller;
import com.transsion.widgetslib.view.swipmenu.SwipeMenu;

class LeftHorizontal
extends Horizontal {
    private static final String TAG = "LeftHorizontal";

    public LeftHorizontal(SwipeMenu swipeMenu) {
        super(1, swipeMenu);
    }

    @Override
    public boolean isMenuOpen(int scrollX) {
        int i = this.getMenuView().getMenuTotalWidth() * this.getDirection();
        return Math.abs(scrollX - i) <= 8 && i != 0;
    }

    @Override
    public boolean isMenuOpenNotEqual(int scrollX) {
        return scrollX < -this.getMenuView().getMenuTotalWidth() * this.getDirection();
    }

    @Override
    public void autoOpenMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(Math.abs(scrollX), this.getMenuView().getMenuTotalWidth() - Math.abs(scrollX), duration);
    }

    @Override
    public void autoOpenMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(scrollX, -scrollX, duration);
    }

    @Override
    public Horizontal.Checker checkXY(int x, int y) {
        this.mChecker.x = x;
        this.mChecker.y = y;
        this.mChecker.shouldResetSwipe = false;
        if (this.mChecker.x == 0) {
            this.mChecker.shouldResetSwipe = true;
        }
        if (this.mChecker.x >= 0) {
            this.mChecker.x = 0;
        }
        if (this.mChecker.x <= -this.getMenuView().getMenuTotalWidth()) {
            this.mChecker.x = -this.getMenuView().getMenuTotalWidth();
        }
        return this.mChecker;
    }

    @Override
    public boolean isClickOnContentView(int contentViewWidth, float x) {
        return x < (float)contentViewWidth;
    }

    @Override
    int getClickMenuItemIndex(int measuredWidth, float measuredHeight, MotionEvent ev, boolean isHios) {
        float x = ev.getX();
        float y = ev.getY();
        int menuItemCount = this.getMenuItemCount();
        if (menuItemCount <= 0 || x < (float)(measuredWidth - this.getMenuWidth())) {
            return -1;
        }
        int menuWidth = this.getMenuWidth();
        if (menuWidth <= 0) {
            return -1;
        }
        if (isHios && this.getMenuView().isMenuImageType()) {
            float itemWidth = this.getMenuView().getMenuItems().get(0).getWidth();
            float dis = x - (float)(measuredWidth - menuWidth) - (float)(this.getMenuView().getMenuPadding() * 2);
            int i = (int)(dis / itemWidth);
            if (i >= 0 && i < menuItemCount) {
                float radiusX = (float)(measuredWidth - menuWidth + this.getMenuView().getMenuPadding()) + (float)i * itemWidth + (float)this.getMenuView().getHiosCircleRadius();
                float radiusY = measuredHeight / 2.0f;
                double sqrt = Math.sqrt(Math.pow(x - radiusX, 2.0) + Math.pow(y - radiusY, 2.0));
                if (sqrt > (double)this.getMenuView().getHiosCircleRadius()) {
                    return -1;
                }
            }
            return i;
        }
        float dis = x - (float)(measuredWidth - menuWidth);
        return (int)dis / (menuWidth / menuItemCount);
    }
}

