/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.core.content.ContextCompat;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.swipmenu.Controller;
import com.transsion.widgetslib.view.swipmenu.Horizontal;
import com.transsion.widgetslib.view.swipmenu.LeftHorizontal;
import com.transsion.widgetslib.view.swipmenu.OverScroll;
import com.transsion.widgetslib.view.swipmenu.OverScroller;
import com.transsion.widgetslib.view.swipmenu.RightHorizontal;
import com.transsion.widgetslib.view.swipmenu.SwipeMenu;
import com.transsion.widgetslib.view.swipmenu.SwipeMenuCreator;
import com.transsion.widgetslib.view.swipmenu.SwipeMenuItem;
import com.transsion.widgetslib.view.swipmenu.Utilities;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;

public class OSSwipeMenuLayout
extends ViewGroup
implements Controller,
LifecycleObserver {
    private static final String TAG = "OSSwipeMenuLayout";
    private int mScaleTouchSlop;
    private int mPointerId;
    private int mHeight;
    private int mLimit;
    private View mContentView;
    private PointF mLastP = new PointF();
    private boolean isUnMoved = true;
    private PointF mFirstP = new PointF();
    private PointF mFirstPNormal = new PointF();
    private boolean isUserSwiped;
    private Paint mMenuPaint;
    private Paint mMenuDelPaint;
    private Paint mMenuImagePaint;
    private Paint mMenuImageDelPaint;
    public static boolean EXECUTEANIMATION;
    public boolean mIsExecuteAnimation;
    private static OSSwipeMenuLayout mViewCache;
    private static boolean isTouching;
    private VelocityTracker mVelocityTracker;
    private boolean isSwipeEnable;
    private boolean isLeftSwipe;
    private boolean hasConsume;
    private SwipeMenuCreator mSwipeMenuCreator;
    private SwipeMenu mSwipeMenu;
    private int mMenuItemTextFixedWidth = 82;
    private int mMenuItemIconFixedWidth = 64;
    private Context mContext;
    private LeftHorizontal mSwipeLeftHorizontal;
    private RightHorizontal mSwipeRightHorizontal;
    private Horizontal mSwipeCurrentHorizontal;
    private OverScroller mScroller;
    private int mScrollerDuration = 350;
    public static final int DEFAULT_SCROLLER_DURATION = 350;
    private int mScaledMaximumFlingVelocity;
    private int mMinScroll;
    private int mMaxScroll;
    private static final float SPRING_STIFFNESS = 400.0f;
    private static final float SPRING_DAMPING_RATIO = 1.0f;
    private SpringAnimation deleteSpringAnimation;
    private ValueAnimator deleteChangeHeightAnimation;
    private boolean availableClick;
    private boolean cacheClose;
    private int deltaX;
    private int currentPointerId;
    private boolean mIsHios;
    private int mCircleDefBgColor;
    private int mCircleDeleteDefBgColor;
    private int mDeleteMenuDefBgColor;
    private int mNormalMenuDefBgColor;
    private int mAnimateAlpha = 255;
    private int mAnimateDelAlpha = 255;
    private float mAnimateRatio = 1.0f;
    private static final int FLING_THRESHOLD_VELOCITY = 500;
    private static final int MIN_FLING_VELOCITY = 250;
    protected int mFlingThresholdVelocity;
    protected int mMinFlingVelocity;
    private static int CURRENT_UI_MODE;
    private Rect mBitmapRectFSrc;
    private Rect mBitmapRectFDest;
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private int mMenuContentWidth;
    int overScrollAmount;

    public OSSwipeMenuLayout(Context context) {
        this(context, null);
    }

    public OSSwipeMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSSwipeMenuLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    public boolean isSwipeEnable() {
        return this.isSwipeEnable;
    }

    public void setSwipeEnable(boolean swipeEnable) {
        this.isSwipeEnable = swipeEnable;
    }

    public boolean isLeftSwipe() {
        return this.isLeftSwipe;
    }

    public OSSwipeMenuLayout setRtl(boolean leftSwipe) {
        this.isLeftSwipe = !leftSwipe;
        this.resetCurrentSwipeController();
        return this;
    }

    public static OSSwipeMenuLayout getViewCache() {
        return mViewCache;
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mContext = context;
        this.mMenuItemTextFixedWidth = Utils.dp2px(this.mContext, this.mMenuItemTextFixedWidth);
        this.mMenuItemIconFixedWidth = Utils.dp2px(this.mContext, this.mMenuItemIconFixedWidth);
        this.mScaleTouchSlop = ViewConfiguration.get((Context)this.mContext).getScaledTouchSlop();
        float density = this.getResources().getDisplayMetrics().density;
        this.mFlingThresholdVelocity = (int)(500.0f * density);
        this.mMinFlingVelocity = (int)(250.0f * density);
        this.isSwipeEnable = true;
        this.isLeftSwipe = true;
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeMenuLayout, defStyleAttr, 0);
        int count = ta.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = ta.getIndex(i);
            if (attr2 == R.styleable.SwipeMenuLayout_SwipeMenuLayoutSwipeEnable) {
                this.isSwipeEnable = ta.getBoolean(attr2, true);
                continue;
            }
            if (attr2 != R.styleable.SwipeMenuLayout_SwipeMenuLayoutLeftSwipe) continue;
            this.isLeftSwipe = ta.getBoolean(attr2, true);
        }
        this.isLeftSwipe = !Utils.isRtl();
        ta.recycle();
        this.mSwipeMenu = new SwipeMenu(this.mContext);
        this.resetCurrentSwipeController();
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mScaledMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mScroller = new OverScroller(this.getContext());
        this.setWillNotDraw(false);
        this.mMenuPaint = new Paint();
        this.mMenuDelPaint = new Paint();
        this.mMenuPaint.setAntiAlias(true);
        this.mMenuDelPaint.setAntiAlias(true);
        this.mMenuPaint.setColor(-65536);
        this.mMenuImagePaint = new Paint();
        this.mMenuImageDelPaint = new Paint();
        Configuration newConfig = context.getResources().getConfiguration();
        int sysThemeConfig = newConfig.uiMode & 0x30;
        if (CURRENT_UI_MODE != sysThemeConfig) {
            CURRENT_UI_MODE = sysThemeConfig;
            SwipeMenuItem.resetCacheIcon(this.getContext());
        }
        String osType = Utils.getOsType();
        this.mIsHios = Utils.mOsType[0].equalsIgnoreCase(osType);
        this.mCircleDefBgColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_altitude_secondary_color);
        this.mCircleDeleteDefBgColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mDeleteMenuDefBgColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mNormalMenuDefBgColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_solid_tertiary_color);
        this.mBitmapRectFSrc = new Rect();
        this.mBitmapRectFDest = new Rect();
    }

    private void resetCurrentSwipeController() {
        if (this.isLeftSwipe && this.mSwipeLeftHorizontal == null) {
            this.mSwipeLeftHorizontal = new LeftHorizontal(this.mSwipeMenu);
            this.mSwipeCurrentHorizontal = this.mSwipeLeftHorizontal;
        }
        if (!this.isLeftSwipe && this.mSwipeRightHorizontal == null) {
            this.mSwipeRightHorizontal = new RightHorizontal(this.mSwipeMenu);
            this.mSwipeCurrentHorizontal = this.mSwipeRightHorizontal;
        }
    }

    @Override
    public boolean isMenuOpen() {
        return this.isLeftSwipe ? this.isLeftMenuOpen() : this.isRightMenuOpen();
    }

    @Override
    public boolean isLeftMenuOpen() {
        return this.mSwipeLeftHorizontal != null && this.mSwipeLeftHorizontal.isMenuOpen(this.getScrollX());
    }

    @Override
    public boolean isRightMenuOpen() {
        return this.mSwipeRightHorizontal != null && this.mSwipeRightHorizontal.isMenuOpen(this.getScrollX());
    }

    @Override
    public boolean isCompleteOpen() {
        return this.isLeftCompleteOpen() || this.isRightMenuOpen();
    }

    @Override
    public boolean isLeftCompleteOpen() {
        return this.mSwipeLeftHorizontal != null && !this.mSwipeLeftHorizontal.isCompleteClose(this.getScrollX());
    }

    @Override
    public boolean isRightCompleteOpen() {
        return this.mSwipeRightHorizontal != null && !this.mSwipeRightHorizontal.isCompleteClose(this.getScrollX());
    }

    @Override
    public boolean isMenuOpenNotEqual() {
        return this.isLeftMenuOpenNotEqual() || this.isRightMenuOpenNotEqual();
    }

    @Override
    public boolean isLeftMenuOpenNotEqual() {
        return this.mSwipeLeftHorizontal != null && this.mSwipeLeftHorizontal.isMenuOpenNotEqual(this.getScrollX());
    }

    @Override
    public boolean isRightMenuOpenNotEqual() {
        return this.mSwipeRightHorizontal != null && this.mSwipeRightHorizontal.isMenuOpenNotEqual(this.getScrollX());
    }

    @Override
    public void smoothOpenMenu() {
        this.smoothOpenMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothOpenLeftMenu() {
        this.smoothOpenLeftMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothOpenRightMenu() {
        this.smoothOpenRightMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothOpenLeftMenu(int duration) {
        if (this.mSwipeLeftHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeLeftHorizontal;
            this.smoothOpenMenu(duration);
        }
    }

    @Override
    public void smoothOpenRightMenu(int duration) {
        if (this.mSwipeRightHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeRightHorizontal;
            this.smoothOpenMenu(duration);
        }
    }

    private void smoothOpenMenu(int duration) {
        mViewCache = this;
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(false);
        }
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoOpenMenu(this.mScroller, this.getScrollX(), duration);
            this.invalidate();
        }
    }

    private void smoothOpenMenuFling(int velocitx) {
        mViewCache = this;
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(false);
        }
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoOpenMenuFling(this.mScroller, this.getScrollX(), -velocitx, this.mMinScroll, this.mMaxScroll, Math.round((float)this.getWidth() * 0.5f * 0.3f));
            if (this.isLeftSwipe ? this.mScroller.getFinalPos() < this.mMaxScroll : this.mScroller.getFinalPos() > this.mMinScroll) {
                this.softAbortScrollerAnimation();
                this.smoothOpenMenu();
            }
            this.invalidate();
        }
    }

    @Override
    public void smoothCloseMenu() {
        this.smoothCloseMenu(this.mScrollerDuration);
    }

    @Override
    public void smoothCloseLeftMenu() {
        if (this.mSwipeLeftHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeLeftHorizontal;
            this.smoothCloseMenu();
        }
    }

    @Override
    public void smoothCloseRightMenu() {
        if (this.mSwipeRightHorizontal != null) {
            this.mSwipeCurrentHorizontal = this.mSwipeRightHorizontal;
            this.smoothCloseMenu();
        }
    }

    @Override
    public void smoothCloseMenu(int duration) {
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(true);
        }
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoCloseMenu(this.mScroller, this.getScrollX(), duration);
            this.invalidate();
        }
        mViewCache = null;
    }

    public void smoothCloseMenuFling(int velocitx) {
        if (null != this.mContentView) {
            this.mContentView.setLongClickable(true);
        }
        if (this.mSwipeCurrentHorizontal != null) {
            this.mSwipeCurrentHorizontal.autoCloseMenuFling(this.mScroller, this.getScrollX(), -velocitx, this.mMinScroll, this.mMaxScroll, Math.round((float)this.getWidth() * 0.5f * 0.3f));
            if (this.isLeftSwipe ? this.mScroller.getFinalPos() > this.mMinScroll : this.mScroller.getFinalPos() < this.mMaxScroll) {
                this.smoothCloseMenu();
            }
            this.invalidate();
        }
        mViewCache = null;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
        this.mSwipeMenu.getMenuItems().clear();
        this.mSwipeMenuCreator.onCreateMenu(this.mSwipeMenu, this.mSwipeMenu);
        this.mMenuContentWidth = this.mSwipeMenu.getMenuTotalWidth();
        if (this.mSwipeMenu.getMenuItems().size() > 0) {
            this.mLimit = this.mSwipeMenu.getMenuItems().get(0).getWidth() / 2;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setClickable(true);
        this.mHeight = 0;
        int contentWidth = 0;
        int childCount = this.getChildCount();
        if (childCount > 0) {
            View childView = this.getChildAt(0);
            childView.setClickable(true);
            if (childView.getVisibility() != 8) {
                this.measureChild(childView, widthMeasureSpec, heightMeasureSpec);
                this.mHeight = Math.max(this.mHeight, childView.getMeasuredHeight());
                this.mContentView = childView;
                contentWidth = childView.getMeasuredWidth();
            }
        }
        if (this.mIsExecuteAnimation) {
            this.setMeasuredDimension(contentWidth, this.getLayoutParams().height);
        } else {
            this.setMeasuredDimension(this.getPaddingLeft() + this.getPaddingRight() + contentWidth, this.mHeight + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int left = 0 + this.getPaddingLeft();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (childView.getVisibility() == 8 || i != 0) continue;
            childView.layout(left, this.getPaddingTop(), left + childView.getMeasuredWidth(), this.getPaddingTop() + childView.getMeasuredHeight());
            left += childView.getMeasuredWidth();
        }
        this.updateMinAndMaxScrollX();
    }

    /*
     * Unable to fully structure code
     */
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.isSwipeEnable || this.mSwipeMenu.getMenuItems().isEmpty() || OSSwipeMenuLayout.EXECUTEANIMATION) {
            OSSwipeMenuLayout.isTouching = false;
            this.closeCacheView();
            return super.dispatchTouchEvent(ev);
        }
        this.acquireVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                if (OSSwipeMenuLayout.isTouching) {
                    return false;
                }
                OSSwipeMenuLayout.isTouching = true;
                this.isUserSwiped = false;
                this.isUnMoved = true;
                if (!this.mScroller.isFinished()) {
                    this.abortScrollerAnimation();
                }
                this.resetOverScrollParams();
                this.closeCacheView();
                this.mLastP.set(ev.getRawX(), ev.getRawY());
                this.mFirstP.set(ev.getRawX(), ev.getRawY());
                this.mFirstPNormal.set(ev.getX(), ev.getY());
                this.mPointerId = ev.getPointerId(0);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mScroller.isFinished()) {
                    this.abortScrollerAnimation();
                }
                if (ev.getAction() == 1 && this.mSwipeCurrentHorizontal.isMenuOpen(this.getScrollX()) && Math.abs(ev.getX() - this.mFirstPNormal.x) < (float)this.mScaleTouchSlop) {
                    clickMenuItemIndex = this.mSwipeCurrentHorizontal.getClickMenuItemIndex(this.getMeasuredWidth(), this.getMeasuredHeight(), ev, this.mIsHios);
                    v0 = this.availableClick = clickMenuItemIndex >= 0 && clickMenuItemIndex < this.mSwipeMenu.getMenuItems().size();
                    if (this.mOnMenuItemClickListener != null && clickMenuItemIndex >= 0 && clickMenuItemIndex < this.mSwipeMenu.getMenuItems().size()) {
                        this.mOnMenuItemClickListener.onMenuItemClickListener(null, this.mSwipeMenu.getMenuItems().get(clickMenuItemIndex).getPosition(), clickMenuItemIndex);
                    }
                }
                if (Math.abs(ev.getRawX() - this.mFirstP.x) > (float)this.mScaleTouchSlop) {
                    this.isUserSwiped = true;
                }
                if (!this.hasConsume || !this.isUserSwiped) ** GOTO lbl78
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mScaledMaximumFlingVelocity);
                velocityX = (int)this.mVelocityTracker.getXVelocity(this.mPointerId);
                isVelocityLeft = !this.isLeftSwipe ? velocityX >= 0 : velocityX <= 0;
                isFling = this.shouldFlingForVelocity(velocityX);
                duration = this.getSwipeDuration(ev, velocityX);
                initialScroll = this.getScrollX();
                if (initialScroll >= this.mMaxScroll && (this.isLeftSwipe == false ? isVelocityLeft == false || isFling == false : isVelocityLeft != false)) ** GOTO lbl-1000
                if (!(initialScroll > this.mMinScroll || isVelocityLeft && isFling)) lbl-1000:
                // 2 sources

                {
                    OSSwipeMenuLayout.mViewCache = this;
                    this.mScroller.springBack(initialScroll, this.mMinScroll, this.mMaxScroll);
                    this.invalidate();
                } else if (velocityX < 0) {
                    if (this.isLeftSwipe) {
                        if (isFling) {
                            this.smoothOpenMenuFling(velocityX);
                        } else {
                            this.smoothOpenMenu(duration);
                        }
                    } else if (isFling) {
                        this.smoothCloseMenuFling(velocityX);
                    } else if (-this.getScrollX() > this.mLimit) {
                        this.smoothOpenMenu();
                    } else {
                        this.smoothCloseMenu(duration);
                    }
                } else if (velocityX > 0) {
                    if (this.isLeftSwipe) {
                        if (isFling) {
                            this.smoothCloseMenuFling(velocityX);
                        } else if (this.getScrollX() > this.mLimit) {
                            this.smoothOpenMenu();
                        } else {
                            this.smoothCloseMenu(duration);
                        }
                    } else if (isFling) {
                        this.smoothOpenMenuFling(velocityX);
                    } else {
                        this.smoothOpenMenu(duration);
                    }
                } else {
                    this.dependOnLimitShowOrHideMenu(duration);
                }
                ** GOTO lbl106
lbl78:
                // 1 sources

                if (this.isLeftSwipe) {
                    if (this.getScrollX() > this.mScaleTouchSlop) {
                        if (ev.getX() < (float)(this.getWidth() - this.getScrollX())) {
                            this.smoothCloseMenu();
                        } else if (!this.availableClick) {
                            this.dependOnLimitShowOrHideMenu(this.mScrollerDuration);
                        }
                    } else if (-this.getScrollX() > this.mScaleTouchSlop) {
                        this.mScroller.springBack(this.getScrollX(), this.mMinScroll, this.mMaxScroll);
                        this.invalidate();
                    } else {
                        this.smoothCloseMenu();
                    }
                } else if (-this.getScrollX() > this.mScaleTouchSlop) {
                    if (ev.getX() > (float)(-this.getScrollX())) {
                        this.smoothCloseMenu();
                    } else if (!this.availableClick) {
                        this.dependOnLimitShowOrHideMenu(this.mScrollerDuration);
                    }
                } else if (this.getScrollX() > this.mScaleTouchSlop) {
                    this.mScroller.springBack(this.getScrollX(), this.mMinScroll, this.mMaxScroll);
                    this.invalidate();
                } else {
                    this.smoothCloseMenu();
                }
lbl106:
                // 20 sources

                this.releaseVelocityTracker();
                OSSwipeMenuLayout.isTouching = false;
                this.hasConsume = false;
                this.availableClick = false;
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void dependOnLimitShowOrHideMenu(int duration) {
        if (Math.abs(this.getScrollX()) > this.mLimit) {
            this.smoothOpenMenu(duration);
        } else {
            this.smoothCloseMenu(duration);
        }
    }

    private void closeCacheView() {
        if (mViewCache != null && mViewCache != this && OSSwipeMenuLayout.mViewCache.isSwipeEnable) {
            OSSwipeMenuLayout.mViewCache.cacheClose = true;
            mViewCache.abortScrollerAnimation();
            mViewCache.smoothCloseMenu();
        }
    }

    public static void closeMenu() {
        if (mViewCache != null) {
            mViewCache.abortScrollerAnimation();
            mViewCache.smoothCloseMenu();
        }
    }

    private void abortScrollerAnimation() {
        this.mScroller.abortAnimation();
    }

    private void softAbortScrollerAnimation() {
        this.mScroller.softAbortAnimation();
    }

    protected boolean shouldFlingForVelocity(int velocity) {
        return Math.abs(velocity) > this.mFlingThresholdVelocity;
    }

    private void resetOverScrollParams() {
        this.overScrollAmount = 0;
        this.cacheClose = false;
    }

    private int getSwipeDuration(MotionEvent ev, int velocity) {
        int duration;
        int sx = this.getScrollX();
        int dx = (int)(ev.getX() - (float)sx);
        int width = this.mSwipeCurrentHorizontal.getMenuWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageDelta = (float)Math.abs(dx) / (float)width;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, this.mScrollerDuration);
        return duration;
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isSwipeEnable) {
            switch (ev.getAction()) {
                case 0: {
                    if (!(this.isLeftSwipe ? this.getScrollX() > this.mScaleTouchSlop && ev.getX() < (float)(this.getWidth() - this.getScrollX()) : -this.getScrollX() > this.mScaleTouchSlop && ev.getX() > (float)(-this.getScrollX()))) break;
                    return true;
                }
                case 2: {
                    int disX = (int)(ev.getRawX() - this.mFirstP.x);
                    int disY = (int)(ev.getRawY() - this.mFirstP.y);
                    if (!(Math.abs(ev.getRawX() - this.mFirstP.x) > (float)this.mScaleTouchSlop) || Math.abs(disX) <= Math.abs(disY)) break;
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    return true;
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isSwipeEnable && !EXECUTEANIMATION) {
            switch (ev.getAction()) {
                case 2: {
                    if (ev.getPointerId(ev.getActionIndex()) != this.currentPointerId) {
                        this.currentPointerId = ev.getPointerId(ev.getActionIndex());
                        this.mLastP.set(ev.getX(0), ev.getY(0));
                    }
                    this.hasConsume = true;
                    float gap = this.mLastP.x - ev.getRawX();
                    if (Math.abs(gap) > 10.0f || Math.abs(this.getScrollX()) > 10) {
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    if (Math.abs(gap) > (float)this.mScaleTouchSlop) {
                        this.isUnMoved = false;
                    }
                    this.scrollBy((int)gap, 0);
                    this.mLastP.set(ev.getRawX(), ev.getRawY());
                    break;
                }
            }
            return true;
        }
        return super.onTouchEvent(ev);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.invalidateScroller();
        }
    }

    private void invalidateScroller() {
        int currentScroll = this.getScrollX();
        this.deltaX = this.mScroller.getCurrPos() - currentScroll;
        this.scrollTo(this.mScroller.getCurrPos(), 0);
        this.invalidate();
    }

    public void scrollBy(int x, int y) {
        this.deltaX = x;
        this.scrollTo(this.getScrollX() + x, y);
    }

    public void scrollTo(int x, int y) {
        boolean isBeforeStart;
        boolean isAfterEnd;
        if (this.mSwipeMenu.getMenuItems().isEmpty()) {
            return;
        }
        if (this.mIsExecuteAnimation) {
            super.scrollTo(x, y);
            return;
        }
        if (this.cacheClose) {
            super.scrollTo(x, y);
            return;
        }
        int primaryScroll = this.getScrollX() + this.deltaX;
        boolean bl = this.isLeftSwipe ? primaryScroll > this.mMaxScroll : (isAfterEnd = primaryScroll < this.mMinScroll);
        boolean bl2 = this.isLeftSwipe ? primaryScroll < this.mMinScroll : (isBeforeStart = primaryScroll > this.mMaxScroll);
        if (this.mScroller.isSpringing()) {
            super.scrollTo(x, y);
        } else if (isBeforeStart) {
            this.dampedOverScroll(primaryScroll - (this.isLeftSwipe ? this.mMinScroll : this.mMaxScroll));
        } else if (isAfterEnd) {
            this.dampedOverScroll(primaryScroll - (!this.isLeftSwipe ? this.mMinScroll : this.mMaxScroll));
        } else {
            super.scrollTo(x, y);
        }
        this.deltaX = 0;
    }

    protected void onDraw(Canvas canvas) {
        SwipeMenuItem swipeMenuItem;
        float start;
        int index;
        float itemDrawWidth;
        int menuCount;
        boolean canDraw;
        long l = System.currentTimeMillis();
        super.onDraw(canvas);
        if (this.mSwipeMenu == null || this.mSwipeMenu.getMenuItems().size() <= 0) {
            return;
        }
        canvas.save();
        int scrollX = this.getScrollX();
        boolean bl = this.isLeftSwipe ? scrollX > 0 : (canDraw = scrollX < 0);
        if (canDraw && !this.mIsExecuteAnimation) {
            menuCount = this.mSwipeMenu.getMenuItems().size();
            itemDrawWidth = Math.abs((float)scrollX / (float)menuCount);
            for (index = 0; index < menuCount; ++index) {
                start = itemDrawWidth * (float)index + (float)(this.isLeftSwipe ? this.getMeasuredWidth() : 0);
                swipeMenuItem = this.mSwipeMenu.getMenuItems().get(index);
                Drawable background = swipeMenuItem.getBackground();
                Drawable circleBackground = swipeMenuItem.getCircleBackground();
                boolean isImageType = TextUtils.isEmpty((CharSequence)swipeMenuItem.getText());
                if (this.isLeftSwipe) {
                    if (this.mIsHios && isImageType) {
                        if (scrollX < this.mSwipeMenu.getMenuTotalWidth()) {
                            start = (float)(scrollX + this.getMeasuredWidth()) - this.mSwipeMenu.getEdgeDistanceHios(index);
                            itemDrawWidth = swipeMenuItem.getWidth();
                        } else {
                            itemDrawWidth = ((float)(Math.abs(scrollX) - this.mSwipeMenu.getMenuPadding() * 2) - (float)(Math.abs(scrollX) - this.mSwipeMenu.getMenuTotalWidth()) * this.mSwipeMenu.getHiosSpaceRatio()) / (float)menuCount;
                            start = itemDrawWidth * (float)index + (float)this.getMeasuredWidth() + (float)this.mSwipeMenu.getMenuPadding() + (float)(Math.abs(scrollX) - this.mSwipeMenu.getMenuTotalWidth()) * this.mSwipeMenu.getHiosSpaceRatio() / 2.0f;
                        }
                        this.drawLeftImgHios(canvas, menuCount, index, start, swipeMenuItem, circleBackground, itemDrawWidth);
                        continue;
                    }
                    this.drawLeftBg(canvas, scrollX, menuCount, itemDrawWidth, index, start, background, isImageType);
                    if (isImageType) {
                        this.drawLeftImg(canvas, menuCount, index, start, swipeMenuItem, circleBackground);
                        continue;
                    }
                    this.drawLeftText(canvas, start, swipeMenuItem);
                    continue;
                }
                if (this.mIsHios && isImageType) {
                    itemDrawWidth = -scrollX < this.mSwipeMenu.getMenuTotalWidth() ? (float)swipeMenuItem.getWidth() : ((float)(Math.abs(scrollX) - this.mSwipeMenu.getMenuPadding() * 2) - (float)(Math.abs(scrollX) - this.mSwipeMenu.getMenuTotalWidth()) * this.mSwipeMenu.getHiosSpaceRatio()) / (float)menuCount;
                    this.drawRightImgHios(canvas, menuCount, index, start, swipeMenuItem, circleBackground, itemDrawWidth);
                    continue;
                }
                this.drawRightBg(canvas, scrollX, menuCount, itemDrawWidth, index, start, background, isImageType);
                if (isImageType) {
                    this.drawRightImg(canvas, menuCount, index, start, swipeMenuItem, circleBackground);
                    continue;
                }
                this.drawRightText(canvas, start, swipeMenuItem);
            }
        }
        if (this.mIsExecuteAnimation) {
            menuCount = this.mSwipeMenu.getMenuItems().size();
            itemDrawWidth = (float)this.mSwipeMenu.getMenuTotalWidth() / (float)this.mSwipeMenu.getMenuItems().size();
            for (index = 0; index < menuCount; ++index) {
                start = itemDrawWidth * (float)index + (float)(this.isLeftSwipe ? this.getMeasuredWidth() : 0);
                swipeMenuItem = this.mSwipeMenu.getMenuItems().get(index);
                boolean isImageType = TextUtils.isEmpty((CharSequence)swipeMenuItem.getText());
                Drawable background = swipeMenuItem.getBackground();
                Drawable circleBackground = swipeMenuItem.getCircleBackground();
                if (this.isLeftSwipe) {
                    if (!this.mIsHios || !isImageType) {
                        this.drawLeftBgAni(canvas, scrollX, menuCount, itemDrawWidth, index, start, background, isImageType);
                    }
                    if (isImageType) {
                        this.drawLeftImgAni(canvas, menuCount, index, start, swipeMenuItem, circleBackground);
                        continue;
                    }
                    this.drawLeftTextAni(canvas, scrollX, menuCount, itemDrawWidth, index, start, swipeMenuItem);
                    continue;
                }
                if (!this.mIsHios || !isImageType) {
                    this.drawRightBgAni(canvas, scrollX, menuCount, itemDrawWidth, index, start, background, isImageType);
                }
                if (isImageType) {
                    this.drawRightImgAni(canvas, menuCount, index, start, swipeMenuItem, circleBackground, itemDrawWidth);
                    continue;
                }
                this.drawRightTextAni(canvas, scrollX, menuCount, itemDrawWidth, index, start, swipeMenuItem);
            }
        }
        canvas.restore();
    }

    private void drawRightTextAni(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, SwipeMenuItem swipeMenuItem) {
        this.mMenuPaint.setTextSize((float)swipeMenuItem.getTextSize());
        this.mMenuPaint.setColor(swipeMenuItem.getTitleColor());
        Paint.FontMetrics fontMetrics = this.mMenuPaint.getFontMetrics();
        float measureText = this.mMenuPaint.measureText(swipeMenuItem.getText());
        float baseLineHeight = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        float baseLine = (float)this.mHeight / 2.0f + baseLineHeight;
        if (index == menuCount - 1) {
            float left = (float)scrollX + (-itemDrawWidth * (float)(menuCount - 1) - (float)scrollX - measureText) / 2.0f;
            canvas.drawText(swipeMenuItem.getText(), left, baseLine, this.mMenuPaint);
        } else {
            float left = -(start + (float)swipeMenuItem.getWidth()) + ((float)swipeMenuItem.getWidth() - measureText) / 2.0f;
            canvas.drawText(swipeMenuItem.getText(), left, baseLine, this.mMenuPaint);
        }
    }

    private void drawLeftTextAni(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, SwipeMenuItem swipeMenuItem) {
        if (index == menuCount - 1) {
            canvas.drawRect(start, 0.0f, (float)(scrollX + this.getMeasuredWidth()), (float)this.mHeight, this.mMenuPaint);
        } else {
            canvas.drawRect(start, 0.0f, start + itemDrawWidth, (float)this.mHeight, this.mMenuPaint);
        }
        this.mMenuPaint.setTextSize((float)swipeMenuItem.getTextSize());
        this.mMenuPaint.setColor(swipeMenuItem.getTitleColor());
        Paint.FontMetrics fontMetrics = this.mMenuPaint.getFontMetrics();
        float measureText = this.mMenuPaint.measureText(swipeMenuItem.getText());
        float baseLineHeight = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        float baseLine = (float)this.mHeight / 2.0f + baseLineHeight;
        if (index == menuCount - 1) {
            canvas.drawText(swipeMenuItem.getText(), start + ((float)scrollX - (float)(menuCount - 1) * itemDrawWidth - measureText) / 2.0f, baseLine, this.mMenuPaint);
        } else {
            canvas.drawText(swipeMenuItem.getText(), start + ((float)(swipeMenuItem.getWidth() / 2) - measureText / 2.0f), baseLine, this.mMenuPaint);
        }
    }

    private void drawRightText(Canvas canvas, float start, SwipeMenuItem swipeMenuItem) {
        this.mMenuPaint.setTextSize((float)swipeMenuItem.getTextSize());
        this.mMenuPaint.setColor(swipeMenuItem.getTitleColor());
        Paint.FontMetrics fontMetrics = this.mMenuPaint.getFontMetrics();
        float measureText = this.mMenuPaint.measureText(swipeMenuItem.getText());
        float baseLineHeight = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        float baseLine = (float)this.mHeight / 2.0f + baseLineHeight;
        float left = -(start + (float)swipeMenuItem.getWidth()) + ((float)swipeMenuItem.getWidth() - measureText) / 2.0f;
        canvas.drawText(swipeMenuItem.getText(), left, baseLine, this.mMenuPaint);
    }

    private void drawRightImg(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground) {
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        float imgLeft = -(start + (float)swipeMenuItem.getWidth()) + ((float)swipeMenuItem.getWidth() - imgWidth) / 2.0f;
        float imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        if (circleBackground != null || this.mIsHios) {
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else if (index == menuCount - 1) {
                this.mMenuPaint.setColor(this.mCircleDeleteDefBgColor);
            } else {
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            int radius = this.mSwipeMenu.getHiosCircleRadius();
            canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, (float)radius, this.mMenuPaint);
        }
        canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, imgTop, this.mMenuImagePaint);
    }

    private void drawRightImgHios(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground, float itemDrawWidth) {
        float imgLeft;
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        if (-this.getScrollX() < this.mSwipeMenu.getMenuTotalWidth()) {
            imgLeft = this.mSwipeMenu.getEdgeDistanceHios(index) - (float)swipeMenuItem.getWidth() + (float)this.getScrollX() + (itemDrawWidth - imgWidth) / 2.0f;
        } else {
            start = (float)this.getScrollX() + itemDrawWidth * (float)(menuCount - index) - itemDrawWidth + (float)this.mSwipeMenu.getMenuPadding() + (float)(Math.abs(this.getScrollX()) - this.mSwipeMenu.getMenuTotalWidth()) * this.mSwipeMenu.getHiosSpaceRatio() / 2.0f;
            imgLeft = start + (itemDrawWidth - imgWidth) / 2.0f;
        }
        float imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        if (circleBackground != null || this.mIsHios) {
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else if (index == menuCount - 1) {
                this.mMenuPaint.setColor(this.mCircleDeleteDefBgColor);
            } else {
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            int radius = this.mSwipeMenu.getHiosCircleRadius();
            canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, (float)radius, this.mMenuPaint);
        }
        canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, imgTop, this.mMenuImagePaint);
    }

    private void drawRightImgAni(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground, float itemDrawWidth) {
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        float imgLeft = 0.0f;
        float imgTop = 0.0f;
        if (index == menuCount - 1) {
            imgLeft = (float)this.getScrollX() + (-itemDrawWidth * (float)(menuCount - 1) - (float)this.getScrollX() - imgWidth) / 2.0f;
            imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        } else {
            imgLeft = -(start + (float)swipeMenuItem.getWidth()) + ((float)swipeMenuItem.getWidth() - imgWidth) / 2.0f;
            imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        }
        if (circleBackground != null || this.mIsHios) {
            float radius = this.mSwipeMenu.getHiosCircleRadius();
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
                this.mMenuDelPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else {
                this.mMenuDelPaint.setColor(this.mCircleDeleteDefBgColor);
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            if (this.mIsHios) {
                this.mMenuPaint.setAlpha(this.mAnimateAlpha);
                this.mMenuDelPaint.setAlpha(this.mAnimateDelAlpha);
            }
            if (index == menuCount - 1) {
                if (this.mIsHios) {
                    radius = (float)((double)radius * (0.5 * (double)(1.0f + this.mAnimateRatio)));
                }
                canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, radius, this.mMenuDelPaint);
            } else {
                canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, (float)this.mSwipeMenu.getHiosCircleRadius(), this.mMenuPaint);
            }
        }
        Bitmap bitmapTemp = swipeMenuItem.getImage();
        int bitmapTempWidth = bitmapTemp.getWidth();
        int bitmapTempHeight = bitmapTemp.getHeight();
        if (index == menuCount - 1) {
            this.mBitmapRectFSrc.set((int)imgLeft, (int)imgTop, (int)imgLeft + bitmapTempWidth, (int)imgTop + bitmapTempHeight);
            float scaleWidth = (float)((double)bitmapTempWidth * (0.5 * (double)(1.0f + this.mAnimateRatio)));
            float scaleHeight = (float)((double)bitmapTempHeight * (0.5 * (double)(1.0f + this.mAnimateRatio)));
            float offsetLeft = ((float)bitmapTempWidth - scaleWidth) / 2.0f;
            float offsetTop = ((float)bitmapTempHeight - scaleHeight) / 2.0f;
            this.mBitmapRectFDest.set((int)(imgLeft + offsetLeft), (int)(imgTop + offsetTop), (int)(imgLeft + offsetLeft + scaleWidth), (int)(imgTop + offsetTop + scaleHeight));
            canvas.drawBitmap(swipeMenuItem.getImage(), null, this.mBitmapRectFDest, this.mMenuImageDelPaint);
        } else {
            canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, imgTop, this.mMenuImagePaint);
        }
    }

    private void drawRightBg(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (background != null && background instanceof ColorDrawable) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        }
        if (index == menuCount - 1) {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect((float)scrollX, 0.0f, (float)scrollX + itemDrawWidth, (float)this.mHeight, this.mMenuPaint);
        } else {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(-(start + itemDrawWidth) - 1.0f, 0.0f, -start, (float)this.mHeight, this.mMenuPaint);
        }
    }

    private void drawRightBgHios(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (background != null) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        } else if (background == null && this.mIsHios && isImageType) {
            this.mMenuPaint.setColor(0);
        }
        if (index == menuCount - 1) {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect((float)scrollX, 0.0f, (float)scrollX + itemDrawWidth, (float)this.mHeight, this.mMenuPaint);
        } else {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(-(start + itemDrawWidth), 0.0f, -start, (float)this.mHeight, this.mMenuPaint);
        }
    }

    private void drawRightBgAni(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (!(background == null || this.mIsHios && isImageType)) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        } else {
            this.mMenuPaint.setColor(0);
        }
        if (index == menuCount - 1) {
            if (background == null && !this.mIsHios) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect((float)scrollX, 0.0f, -itemDrawWidth * (float)(menuCount - 1), (float)this.mHeight, this.mMenuPaint);
        } else {
            if (background == null && !this.mIsHios) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(-(start + itemDrawWidth), 0.0f, -start, (float)this.mHeight, this.mMenuPaint);
        }
    }

    private void drawLeftText(Canvas canvas, float start, SwipeMenuItem swipeMenuItem) {
        this.mMenuPaint.setTextSize((float)swipeMenuItem.getTextSize());
        this.mMenuPaint.setColor(swipeMenuItem.getTitleColor());
        Paint.FontMetrics fontMetrics = this.mMenuPaint.getFontMetrics();
        float measureText = this.mMenuPaint.measureText(swipeMenuItem.getText());
        float baseLineHeight = (fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom;
        int baseLine = (int)((float)(this.mHeight / 2) + baseLineHeight);
        canvas.drawText(swipeMenuItem.getText(), start + ((float)swipeMenuItem.getWidth() - measureText) / 2.0f, (float)baseLine, this.mMenuPaint);
    }

    private void drawLeftImgHios(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground, float itemDrawWidth) {
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        float imgLeft = start + (itemDrawWidth - imgWidth) / 2.0f;
        float imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        if (circleBackground != null || this.mIsHios) {
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else if (index == menuCount - 1) {
                this.mMenuPaint.setColor(this.mCircleDeleteDefBgColor);
            } else {
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            float radius = this.mSwipeMenu.getHiosCircleRadius();
            canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, radius, this.mMenuPaint);
        }
        canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, ((float)this.mHeight - imgHeight) / 2.0f, this.mMenuImagePaint);
    }

    private void drawLeftImg(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground) {
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        float imgLeft = start + ((float)swipeMenuItem.getWidth() - imgWidth) / 2.0f;
        float imgTop = ((float)this.mHeight - imgHeight) / 2.0f;
        if (circleBackground != null || this.mIsHios) {
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else if (index == menuCount - 1) {
                this.mMenuPaint.setColor(this.mCircleDeleteDefBgColor);
            } else {
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            float radius = this.mSwipeMenu.getHiosCircleRadius();
            canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, radius, this.mMenuPaint);
        }
        canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, ((float)this.mHeight - imgHeight) / 2.0f, this.mMenuImagePaint);
    }

    private void drawLeftImgAni(Canvas canvas, int menuCount, int index, float start, SwipeMenuItem swipeMenuItem, Drawable circleBackground) {
        float imgHeight = swipeMenuItem.getImage().getHeight();
        float imgWidth = swipeMenuItem.getImage().getWidth();
        float imgLeft = 0.0f;
        float imgTop = 0.0f;
        if (index == menuCount - 1) {
            imgLeft = start + (((float)(this.getScrollX() + this.getMeasuredWidth()) - start) / 2.0f - imgWidth / 2.0f);
            imgTop = (float)this.mHeight / 2.0f - imgHeight / 2.0f;
        } else {
            imgLeft = start + ((float)swipeMenuItem.getWidth() / 2.0f - imgWidth / 2.0f);
            imgTop = (float)this.mHeight / 2.0f - imgHeight / 2.0f;
        }
        if (circleBackground != null || this.mIsHios) {
            float radius = this.mSwipeMenu.getHiosCircleRadius();
            if (circleBackground != null) {
                this.mMenuPaint.setColor(((ColorDrawable)circleBackground).getColor());
                this.mMenuDelPaint.setColor(((ColorDrawable)circleBackground).getColor());
            } else {
                this.mMenuDelPaint.setColor(this.mCircleDeleteDefBgColor);
                this.mMenuPaint.setColor(this.mCircleDefBgColor);
            }
            if (this.mIsHios) {
                this.mMenuPaint.setAlpha(this.mAnimateAlpha);
                this.mMenuDelPaint.setAlpha(this.mAnimateDelAlpha);
            }
            if (index == menuCount - 1) {
                if (this.mIsHios) {
                    radius = (float)((double)radius * (0.5 * (double)(1.0f + this.mAnimateRatio)));
                }
                canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, radius, this.mMenuDelPaint);
            } else {
                canvas.drawCircle(imgLeft + imgWidth / 2.0f, imgTop + imgHeight / 2.0f, (float)this.mSwipeMenu.getHiosCircleRadius(), this.mMenuPaint);
            }
        }
        Bitmap bitmapTemp = swipeMenuItem.getImage();
        float bitmapTempWidth = bitmapTemp.getWidth();
        float bitmapTempHeight = bitmapTemp.getHeight();
        if (index == menuCount - 1) {
            this.mBitmapRectFSrc.set((int)imgLeft, (int)imgTop, (int)(imgLeft + bitmapTempWidth), (int)(imgTop + bitmapTempHeight));
            float scaleWidth = (float)((double)bitmapTempWidth * (0.5 * (double)(1.0f + this.mAnimateRatio)));
            float scaleHeight = (float)((double)bitmapTempHeight * (0.5 * (double)(1.0f + this.mAnimateRatio)));
            float offsetLeft = (bitmapTempWidth - scaleWidth) / 2.0f;
            float offsetTop = (bitmapTempHeight - scaleHeight) / 2.0f;
            this.mBitmapRectFDest.set((int)(imgLeft + offsetLeft), (int)(imgTop + offsetTop), (int)(imgLeft + offsetLeft + scaleWidth), (int)(imgTop + offsetTop + scaleHeight));
            canvas.drawBitmap(swipeMenuItem.getImage(), null, this.mBitmapRectFDest, this.mMenuImageDelPaint);
        } else {
            canvas.drawBitmap(swipeMenuItem.getImage(), imgLeft, imgTop, this.mMenuImagePaint);
        }
    }

    private void drawLeftBgHios(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (background != null) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        } else if (background == null && this.mIsHios) {
            this.mMenuPaint.setColor(0);
        }
        if (index == menuCount - 1) {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, (float)(scrollX + this.getMeasuredWidth()), (float)this.mHeight, this.mMenuPaint);
        } else {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, start + itemDrawWidth, (float)this.mHeight, this.mMenuPaint);
        }
    }

    private void drawLeftBg(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (background != null && background instanceof ColorDrawable) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        }
        if (index == menuCount - 1) {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, (float)(scrollX + this.getMeasuredWidth()), (float)this.mHeight, this.mMenuPaint);
        } else {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, start + itemDrawWidth + 1.0f, (float)this.mHeight, this.mMenuPaint);
        }
    }

    private void drawLeftBgAni(Canvas canvas, int scrollX, int menuCount, float itemDrawWidth, int index, float start, Drawable background, boolean isImageType) {
        if (!(background == null || this.mIsHios && isImageType)) {
            this.mMenuPaint.setColor(((ColorDrawable)background).getColor());
        } else {
            this.mMenuPaint.setColor(0);
        }
        if (index == menuCount - 1) {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mDeleteMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, (float)(scrollX + this.getMeasuredWidth()), (float)this.mHeight, this.mMenuPaint);
        } else {
            if (!(background != null || this.mIsHios && isImageType)) {
                this.mMenuPaint.setColor(this.mNormalMenuDefBgColor);
            }
            canvas.drawRect(start, 0.0f, start + itemDrawWidth, (float)this.mHeight, this.mMenuPaint);
        }
    }

    protected void dampedOverScroll(int amount) {
        float temOver = OverScroll.dampedScroll(amount, this.deltaX, this.getMeasuredWidth()) * (float)this.deltaX;
        this.overScrollAmount = (int)((float)this.overScrollAmount + temOver);
        int primaryScroll = this.getScrollX();
        int boundedScroll = Utilities.boundToRange(primaryScroll, this.mMinScroll, this.mMaxScroll);
        super.scrollTo(boundedScroll + this.overScrollAmount, 0);
    }

    protected void updateMinAndMaxScrollX() {
        this.mMinScroll = this.isLeftSwipe ? this.computeMinScroll() : -this.computeMaxScroll();
        this.mMaxScroll = this.isLeftSwipe ? this.computeMaxScroll() : this.computeMinScroll();
    }

    protected int computeMinScroll() {
        return 0;
    }

    protected int computeMaxScroll() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            return this.mMenuContentWidth;
        }
        return 0;
    }

    private void acquireVelocityTracker(MotionEvent event) {
        if (null == this.mVelocityTracker) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (null != this.mVelocityTracker) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public boolean performLongClick() {
        if (Math.abs(this.getScrollX()) > this.mScaleTouchSlop) {
            return false;
        }
        return super.performLongClick();
    }

    public void doDeleteAnimation(RecyclerView.ViewHolder viewHolder, DeleteAnimationListener deleteAnimationListener) {
        this.doDeleteAnimationCore(viewHolder, deleteAnimationListener, null);
    }

    public void doDeleteAnimation(RecyclerView.ViewHolder viewHolder, DeleteAnimationListenerCompat deleteAnimationListenerCompat) {
        this.doDeleteAnimationCore(viewHolder, null, deleteAnimationListenerCompat);
    }

    public void doDeleteAnimationCore(RecyclerView.ViewHolder viewHolder, final DeleteAnimationListener deleteAnimationListener, final DeleteAnimationListenerCompat deleteAnimationListenerCompat) {
        if (viewHolder != null) {
            viewHolder.setIsRecyclable(false);
        }
        if (this.mSwipeCurrentHorizontal != null && this.mSwipeCurrentHorizontal.isMenuOpen(this.getScrollX())) {
            if (this.deleteSpringAnimation != null && this.deleteSpringAnimation.isRunning()) {
                this.deleteSpringAnimation.cancel();
            }
            this.deleteSpringAnimation = new SpringAnimation(new FloatValueHolder());
            final int tempFinal = this.isLeftSwipe ? this.getMeasuredWidth() - this.mSwipeMenu.getMenuTotalWidth() / this.mSwipeMenu.getMenuItems().size() : -(this.getMeasuredWidth() - this.mSwipeMenu.getMenuTotalWidth() / this.mSwipeMenu.getMenuItems().size());
            this.deleteSpringAnimation.setSpring(new SpringForce((float)tempFinal).setStiffness(400.0f).setDampingRatio(1.0f));
            final int temScrollX = this.getScrollX();
            this.deleteSpringAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float v, float v1) {
                    if (OSSwipeMenuLayout.this.mIsHios && OSSwipeMenuLayout.this.mSwipeMenu.isMenuImageType()) {
                        float aniRadio = v / (float)tempFinal;
                        if (aniRadio * 2.0f <= 1.0f) {
                            int aniAlpha = (int)((1.0f - aniRadio * 2.0f) * 255.0f);
                            OSSwipeMenuLayout.this.mAnimateAlpha = aniAlpha;
                            OSSwipeMenuLayout.this.mMenuImagePaint.setAlpha(aniAlpha);
                        } else {
                            OSSwipeMenuLayout.this.mAnimateAlpha = 0;
                            OSSwipeMenuLayout.this.mMenuImagePaint.setAlpha(0);
                        }
                    }
                    OSSwipeMenuLayout.this.scrollTo(temScrollX + (int)v, 0);
                }
            });
            final ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            final int topMargin = layoutParams.topMargin;
            final int bottomMargin = layoutParams.bottomMargin;
            this.deleteSpringAnimation.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

                public void onAnimationEnd(DynamicAnimation dynamicAnimation, boolean b, float v, float v1) {
                    if (OSSwipeMenuLayout.this.deleteChangeHeightAnimation != null && OSSwipeMenuLayout.this.deleteChangeHeightAnimation.isRunning()) {
                        OSSwipeMenuLayout.this.deleteChangeHeightAnimation.cancel();
                    }
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation = ValueAnimator.ofFloat((float[])new float[]{OSSwipeMenuLayout.this.getHeight(), 0.0f});
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation.setDuration(300L);
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            float animatedFraction1 = animation.getAnimatedFraction();
                            if (deleteAnimationListenerCompat != null && OSSwipeMenuLayout.this.mSwipeMenu != null) {
                                deleteAnimationListenerCompat.onVerticalAniUpdate(animatedFraction1);
                            }
                            if ((topMargin != 0 || bottomMargin != 0) && layoutParams != null) {
                                layoutParams.setMargins(layoutParams.leftMargin, (int)((float)topMargin * (1.0f - animatedFraction1)), layoutParams.rightMargin, (int)((float)bottomMargin * (1.0f - animatedFraction1)));
                            }
                            if (OSSwipeMenuLayout.this.mIsHios && OSSwipeMenuLayout.this.mSwipeMenu.isMenuImageType()) {
                                float animatedFraction = animatedFraction1;
                                if (animatedFraction * 2.0f <= 1.0f) {
                                    OSSwipeMenuLayout.this.mMenuImageDelPaint.setAlpha((int)((1.0f - animatedFraction) * 255.0f));
                                    OSSwipeMenuLayout.this.mAnimateDelAlpha = (int)((1.0f - animatedFraction * 2.0f) * 255.0f);
                                    OSSwipeMenuLayout.this.mAnimateRatio = 1.0f - animatedFraction * 2.0f;
                                } else {
                                    OSSwipeMenuLayout.this.mMenuImageDelPaint.setAlpha(0);
                                    OSSwipeMenuLayout.this.mAnimateDelAlpha = 0;
                                    OSSwipeMenuLayout.this.mAnimateRatio = 0.0f;
                                }
                            }
                            float value = ((Float)animation.getAnimatedValue()).floatValue();
                            ViewGroup.LayoutParams layoutParams = OSSwipeMenuLayout.this.getLayoutParams();
                            layoutParams.height = (int)value;
                            OSSwipeMenuLayout.this.setLayoutParams(layoutParams);
                        }
                    });
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            if (deleteAnimationListener != null && OSSwipeMenuLayout.this.mSwipeMenu != null) {
                                deleteAnimationListener.onAnimationEnd(OSSwipeMenuLayout.this.mSwipeMenu.getAdapterPosition());
                            }
                            if (deleteAnimationListenerCompat != null && OSSwipeMenuLayout.this.mSwipeMenu != null) {
                                deleteAnimationListenerCompat.onAnimationEnd(OSSwipeMenuLayout.this.mSwipeMenu.getAdapterPosition());
                            }
                            EXECUTEANIMATION = false;
                            OSSwipeMenuLayout.this.mIsExecuteAnimation = false;
                        }

                        public void onAnimationCancel(Animator animation) {
                            if (deleteAnimationListener != null && OSSwipeMenuLayout.this.mSwipeMenu != null) {
                                deleteAnimationListener.onAnimationEnd(OSSwipeMenuLayout.this.mSwipeMenu.getAdapterPosition());
                            }
                            if (deleteAnimationListenerCompat != null && OSSwipeMenuLayout.this.mSwipeMenu != null) {
                                deleteAnimationListenerCompat.onAnimationEnd(OSSwipeMenuLayout.this.mSwipeMenu.getAdapterPosition());
                            }
                            EXECUTEANIMATION = false;
                            OSSwipeMenuLayout.this.mIsExecuteAnimation = false;
                        }
                    });
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f));
                    OSSwipeMenuLayout.this.deleteChangeHeightAnimation.start();
                }
            });
            EXECUTEANIMATION = true;
            this.mIsExecuteAnimation = true;
            this.isSwipeEnable = false;
            mViewCache = null;
            this.deleteSpringAnimation.start();
        }
    }

    public void reuseItem(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder == null) {
            return;
        }
        viewHolder.setIsRecyclable(true);
        viewHolder.itemView.scrollTo(0, 0);
        this.isSwipeEnable = true;
    }

    public static void release() {
        SwipeMenuItem.release();
        if (mViewCache != null) {
            mViewCache = null;
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.resetAnimation();
        OSSwipeMenuLayout.release();
    }

    public void resetAnimation() {
        if (this.deleteSpringAnimation != null && this.deleteSpringAnimation.isRunning()) {
            this.deleteSpringAnimation.cancel();
        }
        if (this.deleteChangeHeightAnimation != null && this.deleteChangeHeightAnimation.isRunning()) {
            this.deleteChangeHeightAnimation.cancel();
        }
    }

    public static interface DeleteAnimationListenerCompat
    extends DeleteAnimationListener {
        public void onVerticalAniUpdate(float var1);
    }

    public static interface DeleteAnimationListener {
        public void onAnimationEnd(int var1);
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemClickListener(View var1, int var2, int var3);
    }
}

