/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sort;

import android.util.Log;
import com.transsion.sort.HanziToPinyin;
import com.transsion.sort.IContactLocale;
import com.transsion.sort.LocaleSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ContactLocaleUtils
implements IContactLocale {
    public static final String TAG = "ContactLocaleUtils";
    public static final Locale LOCALE_ARABIC = new Locale("ar");
    public static final Locale LOCALE_GREEK = new Locale("el");
    public static final Locale LOCALE_HEBREW = new Locale("he");
    public static final Locale LOCALE_SERBIAN = new Locale("sr");
    public static final Locale LOCALE_UKRAINIAN = new Locale("uk");
    public static final Locale LOCALE_THAI = new Locale("th");
    private static final String JAPANESE_LANGUAGE = Locale.JAPANESE.getLanguage().toLowerCase();
    private static ContactLocaleUtils sSingleton;
    private final LocaleSet mLocales;
    private final ContactLocaleUtilsBase mUtils;

    private ContactLocaleUtils(LocaleSet locales) {
        this.mLocales = locales == null ? LocaleSet.getDefault() : locales;
        this.mUtils = this.mLocales.isPrimaryLanguage(JAPANESE_LANGUAGE) ? new JapaneseContactUtils(this.mLocales) : new ContactLocaleUtilsBase(this.mLocales);
        Log.i((String)TAG, (String)("AddressBook Labels [" + this.mLocales.toString() + "]: " + this.getLabels().toString()));
    }

    public boolean isLocale(LocaleSet locales) {
        return this.mLocales.equals(locales);
    }

    public static synchronized ContactLocaleUtils getInstance() {
        if (sSingleton == null) {
            sSingleton = new ContactLocaleUtils(LocaleSet.getDefault());
        }
        return sSingleton;
    }

    public static synchronized void setLocale(Locale locale) {
        ContactLocaleUtils.setLocales(new LocaleSet(locale));
    }

    public static synchronized void setLocales(LocaleSet locales) {
        if (sSingleton == null || !sSingleton.isLocale(locales)) {
            sSingleton = new ContactLocaleUtils(locales);
        }
    }

    @Override
    public String getSortKey(String name, int nameStyle) {
        return this.mUtils.getSortKey(name);
    }

    @Override
    public int getBucketIndex(String name) {
        return this.mUtils.getBucketIndex(name);
    }

    @Override
    public int getNumberBucketIndex() {
        return this.mUtils.getNumberBucketIndex();
    }

    @Override
    public int getBucketCount() {
        return this.mUtils.getBucketCount();
    }

    @Override
    public String getBucketLabel(int bucketIndex) {
        return this.mUtils.getBucketLabel(bucketIndex);
    }

    @Override
    public String getLabel(String name) {
        return this.getBucketLabel(this.getBucketIndex(name));
    }

    @Override
    public ArrayList<String> getLabels() {
        return this.mUtils.getLabels();
    }

    private static class ContactLocaleUtilsBase {
        private static final String BUCKETS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ#";
        private static final String EMPTY_STRING = "";
        private static final String NUMBER_STRING = "#";
        private int mAlphabeticIndexBucketCount;
        private int mNumberBucketIndex;
        private boolean mEnableSecondaryLocalePinyin;
        private Object mAlphabeticIndex;
        private Method mGetBucketIndexMethod;
        private Method mGetBucketLabelMethod;

        public ContactLocaleUtilsBase(LocaleSet locales) {
            Locale secondaryLocale = locales.getSecondaryLocale();
            this.mEnableSecondaryLocalePinyin = locales.isSecondaryLocaleSimplifiedChinese();
            Log.e((String)ContactLocaleUtils.TAG, (String)("ContactLocaleUtilsBase : " + locales + ", mEnableSecondaryLocalePinyin :" + this.mEnableSecondaryLocalePinyin));
            try {
                Class<?> clazz = Class.forName("libcore.icu.AlphabeticIndex");
                this.mGetBucketIndexMethod = clazz.getDeclaredMethod("getBucketIndex", String.class);
                this.mGetBucketLabelMethod = clazz.getDeclaredMethod("getBucketLabel", Integer.TYPE);
                Method addLabels = clazz.getDeclaredMethod("addLabels", Locale.class);
                Method setMaxLabelCount = clazz.getDeclaredMethod("setMaxLabelCount", Integer.TYPE);
                this.mAlphabeticIndex = clazz.getConstructor(Locale.class).newInstance(locales.getPrimaryLocale());
                setMaxLabelCount.invoke(this.mAlphabeticIndex, 300);
                if (secondaryLocale != null) {
                    addLabels.invoke(this.mAlphabeticIndex, secondaryLocale);
                }
                addLabels.invoke(this.mAlphabeticIndex, Locale.ENGLISH);
                addLabels.invoke(this.mAlphabeticIndex, Locale.JAPANESE);
                addLabels.invoke(this.mAlphabeticIndex, Locale.KOREAN);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_THAI);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_ARABIC);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_HEBREW);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_GREEK);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_UKRAINIAN);
                addLabels.invoke(this.mAlphabeticIndex, LOCALE_SERBIAN);
                this.mAlphabeticIndexBucketCount = (Integer)clazz.getDeclaredMethod("getBucketCount", new Class[0]).invoke(this.mAlphabeticIndex, new Object[0]);
                this.mNumberBucketIndex = this.mAlphabeticIndexBucketCount - 1;
            }
            catch (Exception e) {
                this.mAlphabeticIndexBucketCount = BUCKETS.length();
                this.mNumberBucketIndex = this.mAlphabeticIndexBucketCount - 1;
                Log.e((String)ContactLocaleUtils.TAG, (String)("init error : " + e));
            }
        }

        public String getSortKey(String name) {
            return name;
        }

        public int getNumberBucketIndex() {
            return this.mNumberBucketIndex;
        }

        public int getBucketIndex(String name) {
            boolean prefixIsNumeric = false;
            int length = name.length();
            int offset = 0;
            while (offset < length) {
                int codePoint = Character.codePointAt(name, offset);
                if (Character.isDigit(codePoint)) {
                    prefixIsNumeric = true;
                    break;
                }
                if (!Character.isSpaceChar(codePoint) && codePoint != 43 && codePoint != 40 && codePoint != 41 && codePoint != 46 && codePoint != 45 && codePoint != 35) break;
                offset += Character.charCount(codePoint);
            }
            if (prefixIsNumeric) {
                return this.mNumberBucketIndex;
            }
            if (this.mEnableSecondaryLocalePinyin) {
                name = HanziToPinyin.getInstance().transliterate(name);
            }
            int bucket = -1;
            if (this.mGetBucketIndexMethod != null) {
                try {
                    bucket = (Integer)this.mGetBucketIndexMethod.invoke(this.mAlphabeticIndex, name);
                }
                catch (Exception e) {
                    Log.e((String)ContactLocaleUtils.TAG, (String)("getBucketIndex error : " + e));
                }
            } else {
                int index;
                bucket = name.isEmpty() ? this.mNumberBucketIndex : ((index = BUCKETS.indexOf(name.substring(0, 1).toUpperCase())) != -1 ? index : this.mNumberBucketIndex);
                if (bucket != -1) {
                    return bucket;
                }
            }
            if (bucket < 0) {
                return -1;
            }
            if (bucket == 0) {
                return this.mNumberBucketIndex;
            }
            if (bucket >= this.mNumberBucketIndex) {
                return bucket + 1;
            }
            return bucket;
        }

        public int getBucketCount() {
            return this.mAlphabeticIndexBucketCount + 1;
        }

        public String getBucketLabel(int bucketIndex) {
            if (bucketIndex < 0 || bucketIndex >= this.getBucketCount()) {
                return EMPTY_STRING;
            }
            if (bucketIndex == this.mNumberBucketIndex) {
                return NUMBER_STRING;
            }
            if (bucketIndex > this.mNumberBucketIndex) {
                --bucketIndex;
            }
            if (this.mGetBucketLabelMethod != null) {
                try {
                    return (String)this.mGetBucketLabelMethod.invoke(this.mAlphabeticIndex, bucketIndex);
                }
                catch (Exception e) {
                    Log.e((String)ContactLocaleUtils.TAG, (String)("getBucketLabel error : " + e));
                }
            }
            return BUCKETS.substring(bucketIndex, bucketIndex + 1);
        }

        public ArrayList<String> getLabels() {
            int bucketCount = this.getBucketCount();
            ArrayList<String> labels = new ArrayList<String>(bucketCount);
            int i = 0;
            while (i < bucketCount) {
                labels.add(this.getBucketLabel(i));
                ++i;
            }
            return labels;
        }
    }

    private static class JapaneseContactUtils
    extends ContactLocaleUtilsBase {
        private static final String JAPANESE_MISC_LABEL = "\u4ed6";
        private final int mMiscBucketIndex = super.getBucketIndex("\u65e5");
        private static final Set<Character.UnicodeBlock> CJ_BLOCKS;

        static {
            HashSet<Character.UnicodeBlock> set = new HashSet<Character.UnicodeBlock>();
            set.add(Character.UnicodeBlock.HIRAGANA);
            set.add(Character.UnicodeBlock.KATAKANA);
            set.add(Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS);
            set.add(Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS);
            set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
            set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
            set.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
            set.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
            set.add(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT);
            set.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
            set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS);
            set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
            set.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
            CJ_BLOCKS = Collections.unmodifiableSet(set);
        }

        public JapaneseContactUtils(LocaleSet locales) {
            super(locales);
        }

        private static boolean isChineseOrJapanese(int codePoint) {
            return CJ_BLOCKS.contains(Character.UnicodeBlock.of(codePoint));
        }

        @Override
        public int getBucketIndex(String name) {
            int bucketIndex = super.getBucketIndex(name);
            if (bucketIndex == this.mMiscBucketIndex && !JapaneseContactUtils.isChineseOrJapanese(Character.codePointAt(name, 0)) || bucketIndex > this.mMiscBucketIndex) {
                return bucketIndex + 1;
            }
            return bucketIndex;
        }

        @Override
        public int getBucketCount() {
            return super.getBucketCount() + 1;
        }

        @Override
        public String getBucketLabel(int bucketIndex) {
            if (bucketIndex == this.mMiscBucketIndex) {
                return JAPANESE_MISC_LABEL;
            }
            if (bucketIndex > this.mMiscBucketIndex) {
                --bucketIndex;
            }
            return super.getBucketLabel(bucketIndex);
        }
    }
}

