/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.entity.SelectDialogEntity;
import java.util.ArrayList;
import java.util.List;

public class SelectDialogAdapter
extends BaseAdapter {
    private Context mContext;
    private List<SelectDialogEntity> mList;
    private List<Boolean> mCheckedList = new ArrayList<Boolean>();

    public SelectDialogAdapter(Context context, List<SelectDialogEntity> list, boolean isAll) {
        this.mContext = context;
        this.mList = list;
        this.initCheckList(isAll);
    }

    private void initCheckList(boolean isAll) {
        for (int i = 0; i < this.mList.size(); ++i) {
            this.mCheckedList.add(isAll);
        }
    }

    public int getCount() {
        return this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        SelectDialogEntity entity = this.mList.get(position);
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_select_dialog_item_layout, parent, false);
            holder = new ViewHolder();
            holder.setView(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.bindData(entity);
        holder.mCheckView.setChecked(this.mCheckedList.get(position).booleanValue());
        return convertView;
    }

    public void setCheckedItem(int pos) {
        this.mCheckedList.set(pos, this.mCheckedList.get(pos) == false);
        this.notifyDataSetChanged();
    }

    public List<Boolean> getCheckedList() {
        return this.mCheckedList;
    }

    public int getCheckCount() {
        int count = 0;
        for (int i = 0; i < this.mCheckedList.size(); ++i) {
            if (!this.mCheckedList.get(i).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private static class ViewHolder {
        private ImageView mIconView;
        private TextView mTitleView;
        private CheckBox mCheckView;

        private ViewHolder() {
        }

        public void setView(View view) {
            this.mIconView = (ImageView)view.findViewById(R.id.image_select_item_icon);
            this.mTitleView = (TextView)view.findViewById(R.id.text_select_item_title);
            this.mCheckView = (CheckBox)view.findViewById(R.id.check_select_item);
        }

        public void bindData(SelectDialogEntity entity) {
            Drawable icon = entity.getIcon();
            String title = entity.getTitle();
            if (icon != null) {
                this.mIconView.setImageDrawable(icon);
            }
            if (title != null) {
                this.mTitleView.setText((CharSequence)title);
            }
        }
    }
}

