/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;
import java.lang.ref.WeakReference;

public class InputDialog {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private EditText mEditText;
    private TextView mErrorText;
    private TextView mNumText;
    private View mInputView;
    private View mDividerView;
    private int mErrorColor;
    private int mNormalColor;
    private final int DELAY_TIME = 500;
    private boolean mShowSoftInput;

    public InputDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.mErrorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mNormalColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_secondary_color);
    }

    public InputDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setCancelable(boolean cancelAble) {
        this.mBuilder.setCancelable(cancelAble);
        return this;
    }

    public InputDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mBuilder.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return this;
    }

    public void setTextWatcher(TextWatcher textWatcher) {
        this.mEditText.addTextChangedListener(textWatcher);
    }

    public void removeTextWatcher(TextWatcher textWatcher) {
        this.mEditText.removeTextChangedListener(textWatcher);
    }

    public InputDialog setGetInputPositiveButton(CharSequence text, final OnPositiveButtonListener listener) {
        this.mBuilder.setPositiveButton(text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(InputDialog.this.mEditText.getText().toString());
                }
            }
        });
        return this;
    }

    public InputDialog setGetInputPositiveButton(int textId, OnPositiveButtonListener listener) {
        return this.setGetInputPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public InputDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public InputDialog setError(int messageId) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mErrorText = (TextView)this.mInputView.findViewById(R.id.error_text);
        this.mErrorText.setText((CharSequence)this.mContext.getResources().getString(messageId));
        this.mDividerView.setBackgroundColor(this.mErrorColor);
        return this;
    }

    public InputDialog setError(CharSequence message) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mErrorText = (TextView)this.mInputView.findViewById(R.id.error_text);
        this.mErrorText.setText(message);
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.mErrorText.setVisibility(8);
            this.mDividerView.setBackgroundColor(this.mNormalColor);
        } else {
            this.mErrorText.setVisibility(0);
            this.mDividerView.setBackgroundColor(this.mErrorColor);
        }
        return this;
    }

    public InputDialog setInputText(int inputTextId) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mEditText = (EditText)this.mInputView.findViewById(R.id.input_edit_text);
        this.mEditText.addTextChangedListener((TextWatcher)new MyTextWatcher(this, 0));
        this.mEditText.setText((CharSequence)this.mContext.getResources().getString(inputTextId));
        return this;
    }

    public InputDialog setInputText(String inputText) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mEditText = (EditText)this.mInputView.findViewById(R.id.input_edit_text);
        this.mEditText.addTextChangedListener((TextWatcher)new MyTextWatcher(this, 0));
        this.mEditText.setText((CharSequence)inputText);
        return this;
    }

    public InputDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setInput(OnInputListener listener) {
        return this.setInput(null, null, listener);
    }

    public InputDialog setInput(CharSequence text, CharSequence textHint, OnInputListener listener) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mEditText = (EditText)this.mInputView.findViewById(R.id.input_edit_text);
        this.mEditText.addTextChangedListener((TextWatcher)new MyTextWatcher(this, 0));
        this.mEditText.setText(text);
        this.mEditText.setHint(textHint);
        if (listener != null) {
            listener.onInput(this.mEditText);
        }
        return this;
    }

    public InputDialog setInputNum(CharSequence text, CharSequence textHint, int textNum, OnInputNumListener listener) {
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.mEditText = (EditText)this.mInputView.findViewById(R.id.input_edit_text);
        this.mEditText.setText(text);
        this.mEditText.setHint(textHint);
        this.mNumText = (TextView)this.mInputView.findViewById(R.id.num_text);
        this.mEditText.addTextChangedListener((TextWatcher)new MyTextWatcher(this, textNum));
        if (textNum == 0) {
            this.mNumText.setVisibility(8);
        } else {
            this.mNumText.setVisibility(0);
            this.mEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(textNum)});
        }
        if (text.toString().length() < textNum) {
            this.mEditText.setText(text);
            this.mNumText.setText((CharSequence)(String.format("%d", text.toString().length()) + "/" + String.format("%d", textNum)));
        } else {
            this.mNumText.setText((CharSequence)(String.format("%d", textNum) + "/" + String.format("%d", textNum)));
            this.mEditText.setText((CharSequence)text.toString().substring(0, textNum));
        }
        if (listener != null) {
            listener.onInputNum(this.mEditText, this.mNumText);
        }
        return this;
    }

    private void addInputView() {
        this.mInputView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_input_dialog_layout, null);
        this.mBuilder.setView(this.mInputView);
        this.mDividerView = this.mInputView.findViewById(R.id.divider_view);
    }

    public InputDialog setShowSoftInput(boolean showSoftInput) {
        this.mShowSoftInput = showSoftInput;
        return this;
    }

    public PromptDialog create() {
        PromptDialog dialog = this.mBuilder.create();
        dialog.getWindow().setSoftInputMode(16);
        if (this.mShowSoftInput && this.mEditText != null) {
            if (this.mEditText.getText().length() != 0) {
                this.mEditText.setSelection(this.mEditText.getText().length());
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputDialog.this.mEditText.requestFocus();
                    InputMethodManager inputMethodManager = (InputMethodManager)InputDialog.this.mContext.getSystemService("input_method");
                    inputMethodManager.showSoftInput((View)InputDialog.this.mEditText, 0);
                }
            }, 500L);
        }
        return dialog;
    }

    public PromptDialog show() {
        PromptDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public Button getButton(int witch) {
        return this.mBuilder.dialog.getButton(witch);
    }

    public EditText getmEditText() {
        return this.mEditText;
    }

    public TextView getmErrorText() {
        return this.mErrorText;
    }

    public InputDialog setAutoDismiss(boolean autoDismiss) {
        this.mBuilder.setAutoDismiss(autoDismiss);
        return this;
    }

    private static class MyTextWatcher
    implements TextWatcher {
        private WeakReference<InputDialog> mInputDialogWeakReference;
        private int mTextNum;

        public MyTextWatcher(InputDialog inputDialog, int textNum) {
            if (inputDialog != null) {
                this.mInputDialogWeakReference = new WeakReference<InputDialog>(inputDialog);
                this.mTextNum = textNum;
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @SuppressLint(value={"DefaultLocale"})
        public void afterTextChanged(Editable s) {
            if (this.mInputDialogWeakReference.get() != null && ((InputDialog)this.mInputDialogWeakReference.get()).mNumText != null && ((InputDialog)this.mInputDialogWeakReference.get()).mNumText.getVisibility() == 0) {
                if (s.length() < this.mTextNum) {
                    ((InputDialog)this.mInputDialogWeakReference.get()).mNumText.setText((CharSequence)new StringBuilder().append(s.length()).append("/").append(this.mTextNum));
                } else {
                    ((InputDialog)this.mInputDialogWeakReference.get()).mNumText.setText((CharSequence)new StringBuilder().append(this.mTextNum).append("/").append(this.mTextNum));
                }
            }
        }
    }

    public static interface OnPositiveButtonListener {
        public void onClick(String var1);
    }

    public static interface OnInputNumListener {
        public void onInputNum(EditText var1, TextView var2);
    }

    public static interface OnInputListener {
        public void onInput(EditText var1);
    }
}

