/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;

public class ProgressDialog {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private ProgressBar mProgressBar;
    private int mMaxProgress = 100;

    public ProgressDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
    }

    public ProgressDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public ProgressDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public ProgressDialog setMessage(CharSequence title) {
        this.mBuilder.setMessage(title);
        return this;
    }

    public ProgressDialog setMessage(int title) {
        this.mBuilder.setMessage(title);
        return this;
    }

    public ProgressDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public ProgressDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public ProgressDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public ProgressDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public ProgressDialog setProgress(int progress) {
        if (this.mProgressBar == null) {
            this.mProgressBar = (ProgressBar)LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_dialog_progress, null);
            this.mBuilder.setView((View)this.mProgressBar);
        }
        this.mProgressBar.setProgress(progress > this.mMaxProgress ? this.mMaxProgress : progress);
        return this;
    }

    public ProgressDialog setSecondaryProgress(int secondaryProgress) {
        if (this.mProgressBar == null) {
            this.mProgressBar = (ProgressBar)LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_dialog_progress, null);
            this.mBuilder.setView((View)this.mProgressBar);
        }
        this.mProgressBar.setSecondaryProgress(secondaryProgress > this.mMaxProgress ? this.mMaxProgress : secondaryProgress);
        return this;
    }

    public ProgressDialog setMaxProgress(int maxProgress) {
        this.mMaxProgress = maxProgress;
        return this;
    }

    public ProgressDialog setCancelable(boolean cancelAble) {
        this.mBuilder.setCancelable(cancelAble);
        return this;
    }

    public ProgressDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mBuilder.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return this;
    }

    public PromptDialog create() {
        PromptDialog dialog = this.mBuilder.create();
        dialog.getWindow().setSoftInputMode(0);
        return dialog;
    }

    public PromptDialog show() {
        PromptDialog dialog = this.create();
        dialog.show();
        return dialog;
    }
}

