/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieAnimationView;
import com.transsion.widgetslib.R;

public class LoadingView
extends FrameLayout {
    private boolean mShowOnColorFull;
    private LottieAnimationView mAnimationView;
    private Runnable mRunnable;

    public LoadingView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public LoadingView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void showOnColorFull(boolean showColorFull) {
        this.mShowOnColorFull = showColorFull;
        this.release();
        this.init();
    }

    private void init() {
        try {
            this.addView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_loading, null));
            this.mAnimationView = (LottieAnimationView)this.findViewById(R.id.loadingView);
            this.mRunnable = new Runnable(){

                @Override
                public void run() {
                    String loadingViewName = "loading_medium.json";
                    int width = LoadingView.this.getMeasuredWidth();
                    Resources resources = LoadingView.this.getContext().getResources();
                    if (resources != null) {
                        loadingViewName = width <= resources.getDimensionPixelSize(R.dimen.os_loading_small_size) ? (LoadingView.this.mShowOnColorFull ? "loading_small_colorfull.json" : "loading_small.json") : (width <= resources.getDimensionPixelSize(R.dimen.os_loading_medium_size) ? (LoadingView.this.mShowOnColorFull ? "loading_medium_colorfull.json" : "loading_medium.json") : (LoadingView.this.mShowOnColorFull ? "loading_large_colorfull.json" : "loading_large.json"));
                    }
                    LoadingView.this.mAnimationView.setAnimation(loadingViewName);
                    LoadingView.this.mAnimationView.playAnimation();
                }
            };
            this.post(this.mRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
        try {
            if (this.mRunnable != null) {
                this.removeCallbacks(this.mRunnable);
            }
            this.removeAllViews();
            if (this.mAnimationView != null) {
                this.mAnimationView.cancelAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

