/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.letter;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.ArrayList;

public class LetterSelectorLayout
extends FrameLayout
implements HasTypeface {
    public static final int LETTER_TOUCH_ACTION_DOWN = 1;
    public static final int LETTER_TOUCH_ACTION_UP = 2;
    public static final int LETTER_TOUCH_MOVE = 3;
    public static final String mHeart = "\u2661";
    static final float PI_2HALF = 1.5707964f;
    static final float SCALE_FACTOR_2 = 1.2f;
    static final float SCALE_FACTOR = 0.76394373f;
    Interpolator animationInterpolator = new DecelerateInterpolator();
    private Paint txtPaint = new Paint(1);
    private Paint txtMaxPaint = new Paint(1);
    private Paint txtAnimationPaint = new Paint(1);
    private Paint indicatorPaint = new Paint(1);
    private Paint indicatorLetterPaint = new Paint(1);
    private Paint selectedLetterPaint = new Paint(1);
    private float letterSize;
    private float letterMaxSize;
    private float letterIndicatorSize;
    private float precLetterHeight;
    private float precLetterMaxHeight;
    private float precLetterIndicatorHeight;
    private long duration = 180L;
    private long letterIndicatorMinDurationTime = 1000L;
    private boolean isLeft = false;
    private boolean alignRight = true;
    private LetterSelectorConfig alphabetSearchConfig;
    private String[] letters = new String[]{"\u2665", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private float touchFrameStart = 0.0f;
    private float touchFrameOffset = 0.0f;
    private float letterTouchMaxDistance;
    private float letterTouchVerticalDistance;
    private LetterBlock[] letterBlocks = null;
    private int touchIndicatorRadius;
    private int letterIndicatorRadius;
    private int letterIndicatorStart;
    private int selectorPaddingTop;
    private int selectorPaddingBottom;
    private int selectorPaddingStart;
    private boolean requestMeasure = false;
    private int width = 0;
    private int height = 0;
    private int letterColor = -8750470;
    private int indicatorColor = -16731411;
    private int letterIndicatorColor = -1;
    private int selectedLetterColor = -8750470;
    private String selectedLetter;
    private ArrayList<String> selectedLetters;
    private boolean selectedLetterColorEnable = true;
    private boolean topAndBottomClickableEnable = false;
    private Bitmap letterIndicatorBitmap;
    private int letterIndicatorBitmapSize;
    private boolean letterIndicatorBitmapEnable;
    private RectF tmpRect = new RectF();
    private float touchSlot = 0.0f;
    private boolean touchSlotEnable = true;
    private boolean showSelector = true;
    private boolean isShowSelectorAnimation = false;
    private ValueAnimator showSelectorAnimator;
    private int letterOx = 0;
    private LetterSelectorConfig.LetterSelectorListener letterSelectorListener;
    private LetterAnimationStatus animationStatus = new LetterAnimationStatus();
    private LetterBlock touchBlock = null;
    float downX;
    float downY;
    float touchX;
    float touchY;
    boolean touching = false;
    boolean touchMoving = false;
    boolean touchFirstCall = false;
    boolean touchIndicatorEnable = false;
    long touchTime;
    long touchMove;
    private Runnable touchIndicatorRunnable = new Runnable(){

        @Override
        public void run() {
            LetterSelectorLayout.this.touchIndicatorEnable = false;
            LetterSelectorLayout.this.animationStatus.startIndicator();
            LetterSelectorLayout.this.invalidateClip();
        }
    };

    public LetterSelectorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.requestMeasure = true;
    }

    public LetterSelectorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LetterSelectorLayout(Context context) {
        super(context);
        this.init();
    }

    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int valueToDimen(int unit, int value) {
        return (int)TypedValue.applyDimension((int)unit, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setClickable(true);
        this.touchFrameStart = this.dpToPx(48);
        this.selectorPaddingTop = this.dpToPx(72);
        this.selectorPaddingBottom = this.dpToPx(72);
        this.selectorPaddingStart = this.dpToPx(9);
        this.touchFrameOffset = 2.0f;
        this.letterSize = this.valueToDimen(2, 11);
        this.letterMaxSize = this.valueToDimen(2, 40);
        this.letterIndicatorSize = this.valueToDimen(2, 30);
        this.touchIndicatorRadius = this.dpToPx(9);
        this.letterIndicatorRadius = this.getContext().getResources().getDimensionPixelOffset(R.dimen.letter_indicator_radius);
        this.letterIndicatorStart = this.dpToPx(92);
        this.txtPaint.setTextSize(this.letterSize);
        this.txtPaint.setColor(this.letterColor);
        this.txtPaint.setStyle(Paint.Style.FILL);
        this.txtMaxPaint.setTextSize(this.letterMaxSize);
        this.txtMaxPaint.setColor(this.letterColor);
        this.selectedLetterPaint.setColor(this.selectedLetterColor);
        this.selectedLetterPaint.setTextSize(this.letterSize);
        this.indicatorLetterPaint.setColor(this.letterIndicatorColor);
        this.indicatorLetterPaint.setTextSize(this.letterIndicatorSize);
        this.indicatorPaint.setColor(this.toAlphaColor(0.5f, this.indicatorColor));
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.touchSlot = ViewConfiguration.get((Context)this.getContext().getApplicationContext()).getScaledTouchSlop();
        this.letterIndicatorBitmapSize = this.dpToPx(64);
        this.letterIndicatorBitmapEnable = this.letterIndicatorBitmap != null;
        this.updateFontHeight();
    }

    private void updateFontHeight() {
        this.txtAnimationPaint.setTextSize(this.letterSize);
        this.precLetterHeight = this.getTextHeightOffset(this.txtAnimationPaint);
        this.txtAnimationPaint.setTextSize(this.letterMaxSize);
        this.precLetterMaxHeight = this.getTextHeightOffset(this.txtAnimationPaint);
        this.txtAnimationPaint.setTextSize(this.letterIndicatorSize);
        this.precLetterIndicatorHeight = this.getTextHeightOffset(this.txtAnimationPaint);
    }

    private void showSelector(boolean isShow, boolean animation) {
        if (isShow == this.showSelector) {
            return;
        }
        this.showSelector = isShow;
        this.isShowSelectorAnimation = false;
        if (this.showSelectorAnimator != null) {
            this.showSelectorAnimator.end();
        }
        this.checkLayoutDirection();
        int ox = 0;
        if (!isShow) {
            int txtWidth = this.dpToPx(48);
            int n = ox = this.isLeft ? -this.selectorPaddingStart - txtWidth : this.selectorPaddingStart + this.selectorPaddingStart;
        }
        if (ox == this.letterOx) {
            return;
        }
        if (!animation) {
            this.letterOx = ox;
            this.invalidateClip();
            return;
        }
        this.isShowSelectorAnimation = true;
        final int targetOx = ox;
        final int sourceOx = this.letterOx;
        final int deltaOx = targetOx - sourceOx;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(this.duration);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                float ox = (float)sourceOx + (float)deltaOx * value;
                LetterSelectorLayout.this.letterOx = (int)ox;
                LetterSelectorLayout.this.invalidateClip();
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                LetterSelectorLayout.this.letterOx = targetOx;
                LetterSelectorLayout.this.invalidateClip();
            }

            public void onAnimationCancel(Animator animation) {
            }
        });
        valueAnimator.setInterpolator((TimeInterpolator)this.animationInterpolator);
        valueAnimator.start();
        this.showSelectorAnimator = valueAnimator;
    }

    private int toAlphaColor(float alpha, int color2) {
        return Color.argb((int)((int)(alpha * 255.0f) & 0xFF), (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    private int toAlpha(float alpha) {
        return (int)(alpha * 255.0f);
    }

    public LetterSelectorConfig getLetterSelectorConfig(boolean alignRight, boolean dimenDP) {
        if (this.alphabetSearchConfig == null) {
            this.alphabetSearchConfig = new LetterSelectorConfig(this);
            this.requestMeasure = true;
        }
        this.alignRight = alignRight;
        this.alphabetSearchConfig.dimenDP = dimenDP;
        return this.alphabetSearchConfig;
    }

    private void checkLayoutDirection() {
        boolean isRTL = this.getLayoutDirection() == 1;
        this.isLeft = isRTL && this.alignRight || !isRTL && !this.alignRight;
    }

    private void letterSelectorMeasure() {
        if (this.width != this.getWidth() || this.height != this.getHeight()) {
            this.requestMeasure = true;
        }
        if (!this.requestMeasure) {
            return;
        }
        String[] letters = this.letters;
        this.checkLayoutDirection();
        this.requestMeasure = false;
        this.width = this.getWidth();
        this.height = this.getHeight();
        int selectorHeight = this.height - this.selectorPaddingTop - this.selectorPaddingBottom;
        float textHeight = this.precLetterHeight;
        int lettersSize = letters.length;
        float dy = (float)selectorHeight - (float)lettersSize * textHeight;
        float letterGap = 0.0f;
        if (lettersSize > 1) {
            letterGap = dy / (float)(lettersSize - 1);
        }
        float letterGridHeight = textHeight + letterGap;
        float letterGridHeightHalf = letterGridHeight * 0.5f;
        boolean needRecreate = true;
        LetterBlock[] sourceLetterBlock = this.letterBlocks;
        if (sourceLetterBlock != null && sourceLetterBlock.length == lettersSize) {
            boolean fullEqual = true;
            for (int i = 0; i < lettersSize; ++i) {
                String letter = letters[i];
                if (letter.equalsIgnoreCase(sourceLetterBlock[i].letter)) continue;
                fullEqual = false;
                break;
            }
            if (fullEqual) {
                needRecreate = false;
            }
        }
        LetterBlock[] blockArray = null;
        if (needRecreate) {
            blockArray = new LetterBlock[lettersSize];
        }
        float maxLetterWidth = 0.0f;
        float y = (float)(this.height - this.selectorPaddingBottom) - textHeight;
        int i = lettersSize - 1;
        while (i >= 0) {
            float txtWidth;
            String letter = letters[i];
            LetterBlock letterBlock = null;
            if (needRecreate) {
                blockArray[i] = letterBlock = new LetterBlock();
            } else {
                letterBlock = sourceLetterBlock[i];
            }
            letterBlock.letter = letter;
            letterBlock.index = i--;
            letterBlock.y = y;
            letterBlock.yTouchStart = y - letterGridHeightHalf;
            letterBlock.yTouchEnd = y + letterGridHeightHalf;
            letterBlock.letterNormalWidth = txtWidth = this.txtPaint.measureText(letter);
            letterBlock.letterNormalWidthHalf = txtWidth * 0.5f;
            maxLetterWidth = Math.max(maxLetterWidth, txtWidth);
            y -= letterGridHeight;
        }
        if (needRecreate) {
            this.letterBlocks = blockArray;
        }
        for (i = 0; i < lettersSize; ++i) {
            LetterBlock alphabetBlock = this.letterBlocks[i];
            alphabetBlock.x = this.isLeft ? (float)this.selectorPaddingStart + (maxLetterWidth - alphabetBlock.letterNormalWidth) * 0.5f : (float)(this.width - this.selectorPaddingStart) - (maxLetterWidth - alphabetBlock.letterNormalWidth) * 0.5f - alphabetBlock.letterNormalWidth;
        }
        this.letterTouchVerticalDistance = this.letterTouchMaxDistance = (float)(this.letterIndicatorStart - this.selectorPaddingStart);
    }

    private float getTextHeightOffset(Paint textPaint) {
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        float dy = (fm.bottom - fm.top - textPaint.getTextSize()) * 0.5f;
        float textHeightY = -dy;
        return textHeightY += textPaint.getTextSize();
    }

    private float toDeltaTime(long time, long pduration) {
        float value = (float)time * 1.0f / (float)pduration;
        return value;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (!this.showSelector && !this.isShowSelectorAnimation || this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters()) {
            return;
        }
        this.letterSelectorMeasure();
        LetterAnimationStatus animationStatus = this.animationStatus;
        float valueIndicator = 1.0f;
        boolean finishIndicatorAnimation = true;
        float indicatorDuration = 0.8f * (float)this.duration;
        if (!this.touchIndicatorEnable && animationStatus.indicator) {
            long time = SystemClock.uptimeMillis() - animationStatus.indicatorTime;
            if ((float)time < indicatorDuration) {
                valueIndicator = this.toDeltaTime(time, (long)indicatorDuration);
                finishIndicatorAnimation = false;
                animationStatus.indicatorValue = valueIndicator;
                if (!this.touching) {
                    valueIndicator = 1.0f - valueIndicator;
                }
            } else {
                animationStatus.indicator = false;
            }
        }
        float valueLetterMove = 1.0f;
        boolean finshLetterMoveAnimation = true;
        if (animationStatus.letterMove) {
            long time = SystemClock.uptimeMillis() - animationStatus.letterMoveTime;
            if (time < this.duration) {
                valueLetterMove = this.toDeltaTime(time, this.duration);
                finshLetterMoveAnimation = false;
                animationStatus.letterMoveValue = valueLetterMove;
                if (!this.touching) {
                    valueLetterMove = 1.0f - valueLetterMove;
                }
                valueLetterMove = this.animationInterpolator.getInterpolation(valueLetterMove);
            } else {
                animationStatus.letterMove = false;
                if (!this.touching) {
                    this.clearLetterTouchDistance();
                }
            }
        }
        this.drawLetters(canvas, valueLetterMove, finshLetterMoveAnimation);
        this.drawLetterIndicator(canvas, valueIndicator, finishIndicatorAnimation);
        if (this.touching || animationStatus.indicator || animationStatus.letterMove) {
            this.invalidateClip();
        }
    }

    private void drawLetterIndicator(Canvas canvas, float deltaTime, boolean animFinish) {
        float dx;
        if (this.touchBlock == null || !this.touching && !this.touchIndicatorEnable && animFinish) {
            return;
        }
        float cy = this.touchY;
        if (this.letterBlocks.length > 2) {
            float textHeight = this.precLetterHeight;
            float minCy = this.letterBlocks[0].y + textHeight * 0.5f;
            float maxCy = this.letterBlocks[this.letterBlocks.length - 1].y + textHeight * 0.5f;
            if (cy < minCy) {
                cy = minCy;
            }
            if (cy > maxCy) {
                cy = maxCy;
            }
        }
        int letterAlpha = 255;
        if (!animFinish) {
            letterAlpha = this.toAlpha(deltaTime);
        }
        this.indicatorLetterPaint.setAlpha(letterAlpha);
        this.indicatorPaint.setAlpha((int)((float)letterAlpha * 0.93f));
        float textHeight = this.precLetterIndicatorHeight;
        float txtMeasure = this.txtAnimationPaint.measureText(this.touchBlock.letter);
        float txtX = -txtMeasure * 0.5f;
        float cx = 0.0f;
        if (this.isLeft) {
            dx = (float)this.selectorPaddingStart + (float)(this.letterIndicatorStart - this.selectorPaddingStart) * 0.76394373f;
            txtX += dx;
            cx = dx;
        } else {
            dx = (float)this.selectorPaddingStart + (float)(this.letterIndicatorStart - this.selectorPaddingStart) * 0.76394373f;
            cx = (float)this.width - dx;
            txtX += cx;
        }
        if (this.letterIndicatorBitmapEnable) {
            int size = this.letterIndicatorBitmapSize;
            int sizeHalf = size >> 1;
            RectF tmpRect = this.tmpRect;
            tmpRect.set(cx - (float)sizeHalf, cy - (float)sizeHalf, cx + (float)sizeHalf, cy + (float)sizeHalf);
            canvas.drawBitmap(this.letterIndicatorBitmap, null, tmpRect, this.indicatorPaint);
        } else {
            canvas.drawCircle(cx, cy, (float)this.letterIndicatorRadius, this.indicatorPaint);
        }
        canvas.drawText(this.touchBlock.letter, txtX, cy + textHeight * 0.5f, this.indicatorLetterPaint);
    }

    private void drawLetters(Canvas canvas, float deltaTime, boolean animFinish) {
        float textHeight = this.precLetterHeight;
        int size = this.letterBlocks.length;
        int ox = this.letterOx;
        float verticalMaxDistance = this.letterTouchVerticalDistance;
        float letterMaxDistance = this.letterTouchMaxDistance;
        for (int i = 0; i < size; ++i) {
            LetterBlock block = this.letterBlocks[i];
            if (block.targetTouchMove) {
                float targetTouchDistance = block.targetTouchDistance;
                float fontScale = block.targetTouchScale;
                float fontAlpha = 0.0f;
                if (!animFinish) {
                    targetTouchDistance *= deltaTime;
                    fontAlpha = fontScale *= deltaTime;
                    fontAlpha = 1.0f - fontAlpha;
                } else {
                    fontAlpha = 1.0f - block.targetTouchScale;
                }
                float txtSize = this.letterSize + (this.letterMaxSize - this.letterSize) * fontScale;
                float scale = txtSize / this.letterMaxSize;
                this.txtMaxPaint.setAlpha(this.toAlpha(fontAlpha));
                float touchTextHeight = this.precLetterHeight + (this.precLetterMaxHeight - this.precLetterHeight) * fontScale;
                float deltaFontY = (touchTextHeight - textHeight) * 0.5f;
                float dy = Math.abs(verticalMaxDistance - targetTouchDistance);
                double radian = 1.5707963267948966 * (double)dy / (double)verticalMaxDistance;
                float sinValue = (float)Math.sin(radian);
                float r = 0.0f;
                r = sinValue == 0.0f ? letterMaxDistance * 0.76394373f : 1.2f * dy / sinValue;
                float cosValue = (float)Math.cos(radian);
                float newValue = r * cosValue;
                float dx = this.isLeft ? newValue : -newValue;
                int count = canvas.save();
                canvas.translate((float)ox + block.x + dx, block.y + touchTextHeight - deltaFontY);
                canvas.scale(scale, scale);
                canvas.drawText(block.letter, 0.0f, 0.0f, this.txtMaxPaint);
                canvas.restoreToCount(count);
                continue;
            }
            if (this.selectedLetterColorEnable && !this.touching && (block.letter.equalsIgnoreCase(this.selectedLetter) || this.selectedLetters != null && this.selectedLetters.contains(block.letter))) {
                canvas.drawText(block.letter, (float)ox + block.x, block.y + textHeight, this.selectedLetterPaint);
                continue;
            }
            canvas.drawText(block.letter, (float)ox + block.x, block.y + textHeight, this.txtPaint);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isSelectorDisable()) {
            return super.onInterceptTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                if (!this.touchEnable(ev.getX(), ev.getY())) break;
                this.requestDisallowInterceptTouchEvent(true);
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean touchEnable(float x, float y) {
        if (!this.topAndBottomClickableEnable && (y < (float)this.selectorPaddingTop || y > (float)(this.height - this.selectorPaddingBottom))) {
            return false;
        }
        if (this.isLeft && x <= this.touchFrameStart && x >= this.touchFrameOffset) {
            return true;
        }
        return !this.isLeft && x >= (float)this.width - this.touchFrameStart && x <= (float)this.width - this.touchFrameOffset;
    }

    private boolean isSelectorDisable() {
        return !this.showSelector || this.letterBlocks == null || this.letterBlocks.length == 0 || this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (this.isSelectorDisable()) {
            if (this.touching) {
                this.handleTouchUpLetter();
            }
            return super.onTouchEvent(event);
        }
        this.touchX = x;
        this.touchY = y;
        switch (event.getAction()) {
            case 0: {
                if (!this.touchEnable(x, y)) {
                    return false;
                }
                this.requestDisallowInterceptTouchEvent(true);
                this.touchMoving = false;
                this.touchFirstCall = false;
                this.touchTime = SystemClock.uptimeMillis();
                this.touchMove = -1L;
                this.downX = x;
                this.downY = y;
                this.handleTouchDownLetter(y, 1);
                break;
            }
            case 1: 
            case 3: {
                this.handleTouchUpLetter();
                break;
            }
            case 2: {
                if (!this.touching) {
                    this.handleTouchDownLetter(y, 3);
                    break;
                }
                if (this.touchSlotEnable && !this.touchMoving) {
                    if (Math.abs(y - this.downY) > this.touchSlot || Math.abs(x - this.downX) > this.touchSlot) {
                        this.touchMoving = true;
                    }
                    if (!this.touchMoving) break;
                }
                this.handleTouchMoveLetter(y, 3);
            }
        }
        this.invalidateClip();
        return true;
    }

    private void invalidateClip() {
        int maxHalf = Math.round(Math.max((float)this.letterIndicatorRadius, (float)this.letterIndicatorBitmapSize * 0.5f));
        if (this.isLeft) {
            this.invalidate(0, 0, this.letterIndicatorStart + maxHalf, this.height);
        } else {
            this.invalidate(this.width - this.letterIndicatorStart - maxHalf, 0, this.width, this.height);
        }
    }

    private void handleTouchUpLetter() {
        long deltaTime = SystemClock.uptimeMillis() - this.touchTime;
        if (this.touching) {
            if (deltaTime < this.letterIndicatorMinDurationTime) {
                this.touchIndicatorEnable = true;
                this.getHandler().postDelayed(this.touchIndicatorRunnable, this.letterIndicatorMinDurationTime - deltaTime);
            } else {
                this.animationStatus.startIndicator();
            }
        }
        if (this.letterSelectorListener != null) {
            this.letterSelectorListener.onTouchLetter(null, 0, 2);
        }
        this.animationStatus.startLetterTouchUp();
        for (LetterBlock block : this.letterBlocks) {
            block.unpressed();
        }
        this.touching = false;
    }

    private void clearLetterTouchDistance() {
        for (LetterBlock block : this.letterBlocks) {
            block.updateTouchDistanceValue(this.letterTouchVerticalDistance + 1.0f);
        }
    }

    private void handleTouchDownLetter(float y, int touchType) {
        LetterBlock itouchBlock = this.handleTouchLetter(y, touchType);
        if (itouchBlock != null) {
            this.touchBlock = itouchBlock;
            this.touching = true;
            this.touchIndicatorEnable = false;
            this.getHandler().removeCallbacks(this.touchIndicatorRunnable);
            this.animationStatus.startIndicator();
            if (!this.touchSlotEnable) {
                this.updateTouchDistance();
            }
        }
    }

    private void updateTouchDistance() {
        float textHeight = this.precLetterHeight;
        float textHeightHalf = textHeight * 0.5f;
        float touchY = this.touchY;
        for (LetterBlock block : this.letterBlocks) {
            block.updateTouchDistanceValue(touchY - block.y - textHeightHalf);
        }
        this.animationStatus.startLetterTouchMove();
    }

    private void handleTouchMoveLetter(float y, int touchType) {
        LetterBlock itouchBlock = this.handleTouchLetter(y, touchType);
        if (itouchBlock != null) {
            this.touchBlock = itouchBlock;
        }
        this.updateTouchDistance();
    }

    private LetterBlock handleTouchLetter(float y, int touchType) {
        LetterBlock itouchBlock = null;
        int size = this.letterBlocks.length;
        for (int i = 0; i < size; ++i) {
            LetterBlock block = this.letterBlocks[i];
            if (block.inTouch(y)) {
                itouchBlock = block;
                this.callTouchLetter(block, touchType);
                continue;
            }
            if (this.touching && i == 0 && block.isTouchTop(y)) {
                itouchBlock = block;
                this.callTouchLetter(block, touchType);
                continue;
            }
            if (this.touching && i == size - 1 && block.isTouchBottom(y)) {
                itouchBlock = block;
                this.callTouchLetter(block, touchType);
                continue;
            }
            block.unpressed();
        }
        return itouchBlock;
    }

    private void callTouchLetter(LetterBlock block, int touchType) {
        if (!(this.letterSelectorListener == null || this.touchFirstCall && block.pressed)) {
            this.letterSelectorListener.onTouchLetter(String.valueOf(block.letter), block.index, touchType);
            this.touchFirstCall = true;
        }
        block.pressed();
    }

    public void setTypeface(Typeface typeface) {
        if (this.txtPaint != null) {
            this.txtPaint.setTypeface(typeface);
        }
        if (this.txtMaxPaint != null) {
            this.txtMaxPaint.setTypeface(typeface);
        }
        if (this.txtAnimationPaint != null) {
            this.txtAnimationPaint.setTypeface(typeface);
        }
        if (this.indicatorPaint != null) {
            this.indicatorPaint.setTypeface(typeface);
        }
        if (this.indicatorLetterPaint != null) {
            this.indicatorLetterPaint.setTypeface(typeface);
        }
        if (this.selectedLetterPaint != null) {
            this.selectedLetterPaint.setTypeface(typeface);
        }
    }

    static /* synthetic */ String[] access$3102(LetterSelectorLayout x0, String[] x1) {
        x0.letters = x1;
        return x1;
    }

    public class LetterBlock {
        public static final int STATUS_NONE = 1;
        public static final int STATUS_SELECTED = 2;
        public static final int STATUS_UNSELECTED = 4;
        public int index;
        public String letter;
        public float x;
        public float y;
        public float yTouchStart;
        public float yTouchEnd;
        public float letterNormalWidth;
        public float letterNormalWidthHalf;
        public float fontSize;
        public boolean pressed = false;
        public float targetTouchDistance = 0.0f;
        public float targetTouchScale = 1.0f;
        public boolean targetTouchMove = false;

        public boolean inTouch(float ty) {
            return ty >= this.yTouchStart && ty <= this.yTouchEnd;
        }

        public boolean isTouchTop(float ty) {
            return ty < this.yTouchStart;
        }

        public boolean isTouchBottom(float ty) {
            return ty > this.yTouchEnd;
        }

        public boolean pressed() {
            if (this.pressed) {
                return false;
            }
            this.pressed = true;
            return true;
        }

        public boolean unpressed() {
            if (!this.pressed) {
                return false;
            }
            this.pressed = false;
            return true;
        }

        public void updateTouchDistanceValue(float touchDistance) {
            float absTouchDistance = Math.abs(touchDistance);
            if (absTouchDistance >= LetterSelectorLayout.this.letterTouchVerticalDistance) {
                this.targetTouchMove = false;
                this.targetTouchScale = 1.0f;
                this.targetTouchDistance = 0.0f;
                return;
            }
            absTouchDistance = LetterSelectorLayout.this.letterTouchVerticalDistance - absTouchDistance;
            this.targetTouchMove = true;
            this.targetTouchDistance = absTouchDistance;
            this.targetTouchScale = this.targetTouchDistance / LetterSelectorLayout.this.letterTouchVerticalDistance;
        }
    }

    private class LetterAnimationStatus {
        public boolean indicator = false;
        public long indicatorTime;
        public float indicatorValue;
        public boolean letterMove = false;
        public long letterMoveTime;
        public float letterMoveValue;
        public boolean letterMoving = false;

        private LetterAnimationStatus() {
        }

        public void startIndicator() {
            this.indicatorTime = SystemClock.uptimeMillis();
            if (this.indicator && this.indicatorValue < 1.0f) {
                float delta = 1.0f - this.indicatorValue;
                long deltaTime = (long)((float)LetterSelectorLayout.this.duration * delta);
                this.indicatorTime -= deltaTime;
            }
            this.indicator = true;
        }

        public void startLetterTouchMove() {
            if (this.letterMoving) {
                return;
            }
            this.letterMoving = true;
            this.startLetterMove();
        }

        private void startLetterMove() {
            this.letterMoveTime = SystemClock.uptimeMillis();
            if (this.letterMove && this.letterMoveValue < 1.0f) {
                float delta = 1.0f - this.letterMoveValue;
                long deltaTime = (long)((float)LetterSelectorLayout.this.duration * delta);
                this.letterMoveTime -= deltaTime;
            }
            this.letterMove = true;
        }

        public void startLetterTouchUp() {
            this.letterMoving = false;
            this.startLetterMove();
        }
    }

    public static class LetterSelectorConfig {
        private LetterSelectorLayout letterSelector;
        private Context context;
        private boolean dimenDP = true;

        public static int dpToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        public static int spToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)2, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        private int dimenSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.dpToPx(this.context, size);
            }
            return size;
        }

        private int dimenSpSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.spToPx(this.context, size);
            }
            return size;
        }

        private LetterSelectorConfig(LetterSelectorLayout alphabetSearchLayout) {
            this.letterSelector = alphabetSearchLayout;
            this.context = this.letterSelector.getContext();
        }

        public void initConfig(Context context) {
            Resources res = context.getResources();
            this.setSelectorPadding(context.getResources().getDimensionPixelSize(R.dimen.letter_top_padding), res.getDimensionPixelSize(R.dimen.letter_bottom_padding), res.getDimensionPixelSize(R.dimen.letter_end_padding));
            this.setSelectorFontSize(res.getDimensionPixelSize(R.dimen.blade_list_section_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_max_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_indicate_font_Size));
            this.setSelectorFontColor(ContextCompat.getColor((Context)context, (int)R.color.letter_color), ContextCompat.getColor((Context)context, (int)R.color.letter_select_color));
            String osType = Utils.getOsType();
            int selectorColor = R.color.os_platform_basic_color_hios;
            if (TextUtils.isEmpty((CharSequence)osType)) {
                selectorColor = R.color.os_platform_basic_color_hios;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[1])) {
                selectorColor = R.color.os_platform_basic_color_xos;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[0])) {
                selectorColor = R.color.os_platform_basic_color_hios;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[2])) {
                selectorColor = R.color.os_platform_basic_color_itel;
            }
            this.setSelectorSelectedLetterColor(ContextCompat.getColor((Context)context, (int)selectorColor));
            this.setTouchIndicator(ContextCompat.getColor((Context)context, (int)selectorColor), res.getDimensionPixelSize(R.dimen.blade_touch_width));
            this.setTouchFrameStart(res.getDimensionPixelSize(R.dimen.blade_touch_width));
        }

        public LetterSelectorConfig registerLetterSelectorListener(LetterSelectorListener letterSelectorTouchListener) {
            this.letterSelector.letterSelectorListener = letterSelectorTouchListener;
            return this;
        }

        public LetterSelectorConfig setSelectorPadding(int paddingTop, int paddingBottom, int paddingStart) {
            this.letterSelector.selectorPaddingTop = this.dimenSize(paddingTop);
            this.letterSelector.selectorPaddingBottom = this.dimenSize(paddingBottom);
            this.letterSelector.selectorPaddingStart = this.dimenSize(paddingStart);
            return this;
        }

        public LetterSelectorConfig updateSelectorTopPadding(int paddingTop) {
            this.letterSelector.selectorPaddingTop = this.dimenSize(paddingTop);
            this.requestSelectorLayout();
            return this;
        }

        public LetterSelectorConfig setTouchFrameStart(int touchStart) {
            this.letterSelector.touchFrameStart = this.dimenSize(touchStart);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorStart(int letterIndicatorStart) {
            this.letterSelector.letterIndicatorStart = this.dimenSize(letterIndicatorStart);
            return this;
        }

        public LetterSelectorConfig setSelectorFontSize(int letterSize, int letterMaxSize, int letterIndicatorSize) {
            this.letterSelector.letterSize = this.dimenSpSize(letterSize);
            this.letterSelector.letterMaxSize = this.dimenSpSize(letterMaxSize);
            this.letterSelector.letterIndicatorSize = this.dimenSpSize(letterIndicatorSize);
            this.letterSelector.txtPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.selectedLetterPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.txtMaxPaint.setTextSize(this.letterSelector.letterMaxSize);
            this.letterSelector.indicatorLetterPaint.setTextSize(this.letterSelector.letterIndicatorSize);
            this.letterSelector.updateFontHeight();
            return this;
        }

        public LetterSelectorConfig setSelectorFontColor(int letterColor, int letterIndicatorColor) {
            this.letterSelector.letterColor = letterColor;
            this.letterSelector.txtPaint.setColor(letterColor);
            this.letterSelector.txtMaxPaint.setColor(letterColor);
            this.letterSelector.letterIndicatorColor = letterIndicatorColor;
            this.letterSelector.indicatorLetterPaint.setColor(letterIndicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorColor(int indicatorColor) {
            this.letterSelector.indicatorColor = indicatorColor;
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorSize(int radiusTouchIndicator, int radiusLetterIndicator) {
            this.letterSelector.touchIndicatorRadius = this.dimenSize(radiusTouchIndicator);
            this.letterSelector.letterIndicatorRadius = this.dimenSize(radiusLetterIndicator);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorMinDurationTime(long letterIndicatorMinDurationTime) {
            this.letterSelector.letterIndicatorMinDurationTime = letterIndicatorMinDurationTime;
            return this;
        }

        public LetterSelectorConfig setSelectorAnimationInterpolator(Interpolator animationInterpolator) {
            if (animationInterpolator == null) {
                animationInterpolator = new LinearInterpolator();
            }
            this.letterSelector.animationInterpolator = animationInterpolator;
            return this;
        }

        public LetterSelectorConfig requestSelectorInvalidate() {
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig requestSelectorLayout() {
            this.letterSelector.requestMeasure = true;
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig setTouchIndicator(int indicatorColor, int indicatorRadius) {
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            this.letterSelector.touchIndicatorRadius = this.dimenSize(indicatorRadius);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetterColor(int selectedLetterColor) {
            this.letterSelector.selectedLetterColor = selectedLetterColor;
            this.letterSelector.selectedLetterPaint.setColor(selectedLetterColor);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetter(String selectedLetter) {
            this.letterSelector.selectedLetter = selectedLetter;
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetters(ArrayList<String> letters) {
            this.letterSelector.selectedLetters = letters;
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetterColorEnable(boolean selectedLetterColorEnable) {
            this.letterSelector.selectedLetterColorEnable = selectedLetterColorEnable;
            return this;
        }

        public LetterSelectorConfig setSelectorTopAndBottomClickableEnable(boolean topAndBottomClickableEnable) {
            this.letterSelector.topAndBottomClickableEnable = topAndBottomClickableEnable;
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorBitmap(Bitmap letterIndicatorBitmap, int bitmapDrawSize) {
            this.letterSelector.letterIndicatorBitmap = letterIndicatorBitmap;
            this.letterSelector.letterIndicatorBitmapSize = this.dimenSize(bitmapDrawSize);
            this.letterSelector.letterIndicatorBitmapEnable = letterIndicatorBitmap != null;
            return this;
        }

        public LetterSelectorConfig setAlphabetAnimationDuration(int duration) {
            this.letterSelector.duration = duration;
            return this;
        }

        public LetterSelectorConfig setSelectorLetters(String[] letters) {
            LetterSelectorLayout.access$3102(this.letterSelector, letters);
            return this;
        }

        public LetterSelectorConfig showSelector(boolean isShow, boolean animation) {
            this.letterSelector.showSelector(isShow, animation);
            return this;
        }

        public boolean isSelectorShow() {
            return this.letterSelector.showSelector;
        }

        public boolean isSelectorTouching() {
            return this.letterSelector.touching;
        }

        public LetterSelectorConfig setTouchSlotEnable(boolean touchSlotEnable) {
            this.letterSelector.touchSlotEnable = touchSlotEnable;
            return this;
        }

        public static interface LetterSelectorListener {
            public void onTouchLetter(String var1, int var2, int var3);

            public boolean enabledDrawLetters();
        }
    }
}

