/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslistitemlayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.transsion.widgetscore.utils.CoreUtils;
import com.transsion.widgetslistitemlayout.OSFixedClipLayout;
import com.transsion.widgetslistitemlayout.R;
import java.util.Arrays;

public class OSCollapseLinerLayout
extends LinearLayout
implements OSFixedClipLayout {
    private Path mPath;
    private RectF mRectF;
    private float[] mRadii;
    private float mRadius;
    private int mFixedHeight;
    private int mCollapseHeight;
    private boolean mIsSettingFixedHeight;
    private boolean mIsNeedClipCorners;

    public OSCollapseLinerLayout(Context context) {
        super(context);
        this.init();
    }

    public OSCollapseLinerLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public OSCollapseLinerLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClickable(true);
        this.setOrientation(1);
        this.mRadius = this.getResources().getDimension(R.dimen.os_list_item_corners_radius);
        if (this.getBackground() == null) {
            this.mIsNeedClipCorners = true;
            int backgroundColor = CoreUtils.mOsType[0].equalsIgnoreCase(CoreUtils.getOsType()) ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_liv_hios_normal) : CoreUtils.getOsBgPrimary((Context)this.getContext());
            this.setBackgroundColor(backgroundColor);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIsSettingFixedHeight) {
            this.setMeasuredDimension(widthMeasureSpec, this.mFixedHeight);
            this.mIsSettingFixedHeight = false;
        }
    }

    @Override
    public void setFixedHeight(int fixedHeight) {
        this.mFixedHeight = fixedHeight;
        this.mIsSettingFixedHeight = true;
        this.requestLayout();
    }

    @Override
    public int getFixedHeight() {
        return this.mFixedHeight;
    }

    public void draw(Canvas canvas) {
        if (CoreUtils.mOsType[0].equalsIgnoreCase(CoreUtils.getOsType()) && this.mIsNeedClipCorners) {
            if (this.mPath == null) {
                this.mPath = new Path();
                this.mRectF = new RectF();
                this.mRadii = new float[8];
            }
            Arrays.fill(this.mRadii, this.mRadius);
            this.mPath.reset();
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.addRoundRect(this.mRectF, this.mRadii, Path.Direction.CCW);
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
    }

    private void expandViewsWithAnim(final int fromIndex, final int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            return;
        }
        int collapseHeight = this.computeCollapseHeight(fromIndex, toIndex);
        if (this.mCollapseHeight != collapseHeight) {
            this.mCollapseHeight = collapseHeight;
        }
        final int endValue = this.mFixedHeight + this.mCollapseHeight;
        if (this.mCollapseHeight <= 0 || endValue <= this.mFixedHeight) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mFixedHeight, endValue});
        animator.setDuration(300L);
        animator.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)this.getContext(), (int)R.anim.os_interpolator_liv_item_collapse));
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object value = animation.getAnimatedValue();
                if (value instanceof Integer) {
                    OSCollapseLinerLayout.this.setFixedHeight((Integer)value);
                    float fraction = animation.getAnimatedFraction();
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        OSCollapseLinerLayout.this.getChildAt(i).setAlpha(fraction);
                    }
                }
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                for (int i = fromIndex; i <= toIndex; ++i) {
                    OSCollapseLinerLayout.this.getChildAt(i).setAlpha(1.0f);
                }
                OSCollapseLinerLayout.this.setFixedHeight(endValue);
            }
        });
        animator.start();
    }

    private void collapseViewsWithAnim(final int fromIndex, final int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            return;
        }
        int collapseHeight = this.computeCollapseHeight(fromIndex, toIndex);
        if (this.mCollapseHeight != collapseHeight) {
            this.mCollapseHeight = collapseHeight;
        }
        int measuredHeight = this.getMeasuredHeight();
        final int endValue = measuredHeight - this.mCollapseHeight;
        if (measuredHeight <= 0 || endValue >= measuredHeight) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{measuredHeight, endValue});
        animator.setDuration(300L);
        animator.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)this.getContext(), (int)R.anim.os_interpolator_liv_item_collapse));
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object value = animation.getAnimatedValue();
                if (value instanceof Integer) {
                    OSCollapseLinerLayout.this.setFixedHeight((Integer)value);
                    float fraction = animation.getAnimatedFraction();
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        OSCollapseLinerLayout.this.getChildAt(i).setAlpha(1.0f - fraction);
                    }
                }
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                for (int i = fromIndex; i <= toIndex; ++i) {
                    OSCollapseLinerLayout.this.getChildAt(i).setAlpha(0.0f);
                }
                OSCollapseLinerLayout.this.setFixedHeight(endValue);
            }
        });
        animator.start();
    }

    private void expandViewsWithAnim(int index) {
        this.expandViewsWithAnim(index, index);
    }

    public void expandViewsWithAnim(View fromView, View toView) {
        this.expandViewsWithAnim(this.indexOfChild(fromView), this.indexOfChild(toView));
    }

    public void expandViewsWithAnim(View fromView, int itemCount) {
        int fromIndex = this.indexOfChild(fromView);
        this.expandViewsWithAnim(fromIndex, fromIndex + itemCount - 1);
    }

    public void expandViewsWithAnim(View view) {
        this.expandViewsWithAnim(this.indexOfChild(view));
    }

    private void collapseViewsWithAnim(int index) {
        this.collapseViewsWithAnim(index, index);
    }

    public void collapseViewsWithAnim(View fromView, View toView) {
        this.collapseViewsWithAnim(this.indexOfChild(fromView), this.indexOfChild(toView));
    }

    public void collapseViewsWithAnim(View fromView, int itemCount) {
        int fromIndex = this.indexOfChild(fromView);
        this.collapseViewsWithAnim(fromIndex, fromIndex + itemCount - 1);
    }

    public void collapseViewsWithAnim(View view) {
        this.collapseViewsWithAnim(this.indexOfChild(view));
    }

    private int computeCollapseHeight(int fromIndex, int toIndex) {
        int collapseHeight = 0;
        for (int i = fromIndex; i <= toIndex; ++i) {
            View child = this.getChildAt(i);
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int heightUsed = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            collapseHeight += heightUsed;
        }
        return collapseHeight;
    }

    private void collapseViews(final int fromIndex, final int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            return;
        }
        for (int i = fromIndex; i <= toIndex; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() != 8) continue;
            view.setVisibility(0);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                OSCollapseLinerLayout.this.mCollapseHeight = OSCollapseLinerLayout.this.computeCollapseHeight(fromIndex, toIndex);
                int fixedHeight = OSCollapseLinerLayout.this.getMeasuredHeight() - OSCollapseLinerLayout.this.mCollapseHeight;
                if (fixedHeight > 0) {
                    OSCollapseLinerLayout.this.setFixedHeight(fixedHeight);
                }
            }
        });
    }

    private void collapseViews(int index) {
        this.collapseViews(index, index);
    }

    public void collapseViews(View fromView, View toView) {
        this.collapseViews(this.indexOfChild(fromView), this.indexOfChild(toView));
    }

    public void collapseViews(View fromView, int itemCount) {
        int fromIndex = this.indexOfChild(fromView);
        this.collapseViews(fromIndex, fromIndex + itemCount - 1);
    }

    public void collapseViews(View view) {
        this.collapseViews(this.indexOfChild(view));
    }
}

