/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslistitemlayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.transsion.widgetscore.utils.CoreUtils;
import com.transsion.widgetslib.view.BadgeView;
import com.transsion.widgetslib.widget.seekbar.OSSeekbar;
import com.transsion.widgetslistitemlayout.OSFixedClipLayout;
import com.transsion.widgetslistitemlayout.OSRoundImageView;
import com.transsion.widgetslistitemlayout.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class OSListItemView
extends RelativeLayout
implements OSFixedClipLayout {
    private static final int ITEM_TYPE_CONTENT = 0;
    private static final int ITEM_TYPE_TITLE = 1;
    public static final int LEFT_DRAWABLE_DIMEN_SMALL = 0;
    public static final int LEFT_DRAWABLE_DIMEN_BIG = 1;
    private static final int RIGHT_LAYOUT_TYPE_NOTHING = 0;
    private static final int RIGHT_LAYOUT_TYPE_CUSTOM = 1;
    private static final int RIGHT_LAYOUT_TYPE_IMAGE = 2;
    private static final int RIGHT_LAYOUT_TYPE_RADIO_BUTTON = 3;
    private static final int RIGHT_LAYOUT_TYPE_SWITCH = 4;
    private static final int ITEM_MIN_HEIGHT = 60;
    private static final int ITEM_PADDING_TOP = 15;
    private static final int LEFT_IMAGE_H1_DIMEN = 38;
    public static final int ANIM_DURATION = 300;
    private int mItemType;
    private String mTitle;
    private String mSubtitle;
    private String mDescribeTitle;
    private String mDescribeSubtitle;
    private Drawable mLeftDrawable;
    private Drawable mRightDrawable;
    private boolean mIsShowLeftDrawable;
    private boolean mIsSetRightDrawable;
    private int mLeftDrawableDimen;
    private int mRightLayoutType;
    private int mCornersAngleType;
    private boolean mIsSubProgressbar;
    private boolean mIsSubSeekbar;
    private boolean mIsShowRightDivideLine;
    private boolean mIsShowRedDot;
    private boolean mIsShowGroupTitleArrow;
    private Path mPath;
    private RectF mRectF;
    private float[] mRadii;
    private float mRadius;
    private Switch mSwitch;
    private RadioButton mRadioButton;
    private ProgressBar mProgressBar;
    private OSSeekbar mSeekBar;
    private TextView mViewTitle;
    private TextView mViewSubtitle;
    private TextView mViewGroupTitle;
    private TextView mViewDescribeTitle;
    private TextView mViewDescribeSubtitle;
    private ImageView mRightImageView;
    private BadgeView mBadgeView;
    private ImageView mViewGroupTitleArrow;
    private OSRoundImageView mViewLeftImage;
    private boolean mIsGroupArrowExpend;
    private ObjectAnimator mAnimArrowExpend;
    private boolean mIsSettingFixedHeight;
    private int mFixedHeight;
    private boolean mIsHiOS;
    private View mTitleLayout;
    private View mRightLayout;
    private View mDescribeLayout;
    private View mViewRightDivideLine;

    public OSListItemView(Context context) {
        this(context, 0);
    }

    public OSListItemView(Context context, int itemType) {
        super(context);
        this.mItemType = itemType;
        this.init(context, null);
    }

    public OSListItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public OSListItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OSListItemView);
            int indexCount = typedArray.getIndexCount();
            for (int at = 0; at < indexCount; ++at) {
                int index = typedArray.getIndex(at);
                if (index == R.styleable.OSListItemView_lil_title) {
                    this.mTitle = typedArray.getString(index);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_subtitle) {
                    this.mSubtitle = typedArray.getString(index);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_describe_title) {
                    this.mDescribeTitle = typedArray.getString(index);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_describe_subtitle) {
                    this.mDescribeSubtitle = typedArray.getString(index);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_left_image) {
                    this.mLeftDrawable = typedArray.getDrawable(index);
                    this.mIsShowLeftDrawable = true;
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_left_image_dimen) {
                    this.mLeftDrawableDimen = typedArray.getInt(index, 0);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_right_layout_type) {
                    this.mRightLayoutType = typedArray.getInt(index, 0);
                    if (this.mRightLayoutType != 2) continue;
                    this.mIsSetRightDrawable = true;
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_right_image) {
                    this.mRightDrawable = typedArray.getDrawable(index);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_sub_progressbar) {
                    this.mIsSubProgressbar = typedArray.getBoolean(index, false);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_sub_seekbar) {
                    this.mIsSubSeekbar = typedArray.getBoolean(index, false);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_right_show_divide_line) {
                    this.mIsShowRightDivideLine = typedArray.getBoolean(index, false);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_corners_angle_type) {
                    this.mCornersAngleType = typedArray.getInt(index, 0);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_item_type) {
                    this.mItemType = typedArray.getInt(index, 0);
                    continue;
                }
                if (index == R.styleable.OSListItemView_lil_describe_show_red_dot) {
                    this.mIsShowRedDot = typedArray.getBoolean(index, false);
                    continue;
                }
                if (index != R.styleable.OSListItemView_lil_group_title_show_arrow) continue;
                this.mIsShowGroupTitleArrow = typedArray.getBoolean(index, false);
            }
            typedArray.recycle();
        }
        this.setClickable(true);
        OSListItemView.inflate((Context)this.getContext(), (int)R.layout.os_view_list_item_layout, (ViewGroup)this);
        this.mRadius = this.getResources().getDimension(R.dimen.os_list_item_corners_radius);
        this.mIsHiOS = CoreUtils.mOsType[0].equalsIgnoreCase(CoreUtils.getOsType());
        if (this.mItemType == 1) {
            this.setMinimumHeight(this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_title_min_height));
            int paddingStart = this.mIsHiOS ? this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_padding) : this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_padding_xos);
            this.setPadding(paddingStart, this.getPaddingTop(), paddingStart, this.getPaddingBottom());
        } else {
            this.setMinimumHeight(this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_content_min_height));
            if (this.getBackground() == null) {
                ColorDrawable drawablePress;
                ColorDrawable drawableNormal;
                int pressColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_press_primary_color);
                if (this.mIsHiOS) {
                    float insetRadius = this.getResources().getDimension(R.dimen.os_list_item_corners_radius_inset);
                    float[] innerRadii = new float[8];
                    Arrays.fill(innerRadii, insetRadius);
                    ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(innerRadii, null, null));
                    shapeDrawable.getPaint().setColor(pressColor);
                    float insetPadding = this.getResources().getDimension(R.dimen.os_list_item_bg_inset_padding);
                    InsetDrawable insetDrawable = new InsetDrawable((Drawable)shapeDrawable, (int)insetPadding);
                    drawableNormal = new ColorDrawable(ContextCompat.getColor((Context)this.getContext(), (int)R.color.os_liv_hios_normal));
                    drawablePress = new LayerDrawable(new Drawable[]{drawableNormal, insetDrawable});
                } else {
                    drawableNormal = new ColorDrawable(CoreUtils.getOsBgPrimary((Context)this.getContext()));
                    drawablePress = new ColorDrawable(pressColor);
                }
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{16842919}, (Drawable)drawablePress);
                stateListDrawable.addState(new int[0], (Drawable)drawableNormal);
                this.setBackground((Drawable)stateListDrawable);
            }
        }
        this.layoutViews();
    }

    private void layoutViews() {
        if (this.mItemType == 1) {
            if (this.mViewGroupTitle == null) {
                ((ViewStub)this.findViewById(R.id.lil_stub_type_item_group_title)).inflate();
                this.mViewGroupTitle = (TextView)this.findViewById(R.id.lil_type_item_group_title_title);
            }
            if (this.mIsShowGroupTitleArrow) {
                this.initGroupTitleArrow();
            }
        } else {
            RelativeLayout.LayoutParams layoutParams;
            int paddingStart;
            int paddingEnd;
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            int paddingTop = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)metrics);
            if (this.mIsHiOS) {
                paddingStart = paddingEnd = this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_padding);
            } else {
                paddingStart = this.getResources().getDimensionPixelOffset(R.dimen.os_list_item_padding_xos);
                paddingEnd = (int)TypedValue.applyDimension((int)1, (float)22.0f, (DisplayMetrics)metrics);
            }
            if (this.mIsShowLeftDrawable) {
                int dimension;
                if (this.mViewLeftImage == null) {
                    if (!this.mIsHiOS) {
                        paddingStart = (int)TypedValue.applyDimension((int)1, (float)22.0f, (DisplayMetrics)metrics);
                    }
                    this.mViewLeftImage = (OSRoundImageView)((ViewStub)this.findViewById(R.id.lil_stub_left_layout)).inflate();
                    RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)this.mViewLeftImage.getLayoutParams();
                    layoutParams2.addRule(15);
                    layoutParams2.addRule(20);
                    this.mViewLeftImage.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
                    if (this.mTitleLayout != null) {
                        RelativeLayout.LayoutParams titleLayoutLayoutParams = (RelativeLayout.LayoutParams)this.mTitleLayout.getLayoutParams();
                        titleLayoutLayoutParams.removeRule(20);
                        titleLayoutLayoutParams.addRule(17, this.mViewLeftImage.getId());
                        this.mTitleLayout.setLayoutParams((ViewGroup.LayoutParams)titleLayoutLayoutParams);
                    }
                }
                if (this.mLeftDrawableDimen == 1) {
                    dimension = (int)TypedValue.applyDimension((int)1, (float)38.0f, (DisplayMetrics)metrics);
                    int actualMinHeight = 68;
                    if (actualMinHeight > 60) {
                        int actualPaddingTop = 11;
                        paddingTop = (int)TypedValue.applyDimension((int)1, (float)actualPaddingTop, (DisplayMetrics)metrics);
                    }
                } else {
                    dimension = (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)metrics);
                }
                layoutParams = (RelativeLayout.LayoutParams)this.mViewLeftImage.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                this.mViewLeftImage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (this.mLeftDrawable != null) {
                    this.mViewLeftImage.setImageDrawable(this.mLeftDrawable);
                }
            }
            if (this.mTitle != null) {
                if (this.mTitleLayout == null) {
                    this.mTitleLayout = ((ViewStub)this.findViewById(R.id.lil_stub_title_layout)).inflate();
                    RelativeLayout.LayoutParams titleLayoutLayoutParams = (RelativeLayout.LayoutParams)this.mTitleLayout.getLayoutParams();
                    if (this.mViewLeftImage == null) {
                        titleLayoutLayoutParams.addRule(20);
                    } else {
                        titleLayoutLayoutParams.addRule(17, this.mViewLeftImage.getId());
                    }
                    titleLayoutLayoutParams.addRule(15);
                    this.mTitleLayout.setLayoutParams((ViewGroup.LayoutParams)titleLayoutLayoutParams);
                }
                if (this.mViewTitle == null) {
                    this.mViewTitle = (TextView)this.mTitleLayout.findViewById(R.id.lil_title);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
                    this.mViewTitle.setText((CharSequence)this.mTitle);
                }
                if (this.mIsShowRedDot && this.mBadgeView == null) {
                    this.mBadgeView = (BadgeView)((ViewStub)this.mTitleLayout.findViewById(R.id.os_stub_list_view_red_point)).inflate();
                }
                if (this.mSubtitle != null) {
                    if (this.mViewSubtitle == null) {
                        this.mViewSubtitle = (TextView)((ViewStub)this.mTitleLayout.findViewById(R.id.lil_stub_subtitle)).inflate();
                        paddingTop = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)metrics);
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.mSubtitle)) {
                        this.mViewSubtitle.setText((CharSequence)this.mSubtitle);
                    }
                }
                if (this.mIsSubProgressbar && this.mProgressBar == null) {
                    this.mProgressBar = (ProgressBar)((ViewStub)this.mTitleLayout.findViewById(R.id.lil_stub_sub_progressbar)).inflate();
                    LinearLayout.LayoutParams layoutParams3 = (LinearLayout.LayoutParams)this.mProgressBar.getLayoutParams();
                    if (this.mViewSubtitle == null) {
                        layoutParams3.topMargin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
                    }
                    this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
                    paddingTop = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
                    this.setTitleLayoutPadding(metrics, this.mTitleLayout);
                }
                if (this.mIsSubSeekbar && this.mSeekBar == null) {
                    this.mSeekBar = (OSSeekbar)((ViewStub)this.mTitleLayout.findViewById(R.id.lil_stub_sub_seekbar)).inflate();
                    int paddingLeft = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)metrics);
                    this.mSeekBar.setPadding(paddingLeft, 0, paddingLeft, 0);
                    layoutParams = (LinearLayout.LayoutParams)this.mSeekBar.getLayoutParams();
                    if (this.mViewSubtitle == null) {
                        layoutParams.topMargin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
                    }
                    this.mSeekBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    paddingTop = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
                    this.setTitleLayoutPadding(metrics, this.mTitleLayout);
                }
            }
            if (this.mRightLayoutType == 0) {
                if (!this.mIsHiOS) {
                    paddingEnd = (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)metrics);
                }
            } else {
                if (this.mRightLayout == null) {
                    this.mRightLayout = ((ViewStub)this.findViewById(R.id.lil_stub_right_layout)).inflate();
                }
                if (this.mIsShowRightDivideLine && this.mViewRightDivideLine == null) {
                    this.mViewRightDivideLine = ((ViewStub)this.findViewById(R.id.lil_stub_right_divide_line)).inflate();
                }
                if (this.mRightLayoutType == 2) {
                    if (this.mRightImageView == null) {
                        this.mRightImageView = (ImageView)((ViewStub)this.findViewById(R.id.lil_stub_right_image)).inflate();
                    }
                    if (this.mIsSetRightDrawable) {
                        if (this.mRightDrawable == null) {
                            this.mRightImageView.setImageResource(R.drawable.os_list_item_next);
                        } else {
                            this.mRightImageView.setImageDrawable(this.mRightDrawable);
                        }
                    }
                    if (this.mDescribeTitle != null) {
                        if (this.mDescribeLayout == null) {
                            this.mDescribeLayout = ((ViewStub)this.findViewById(R.id.lil_stub_describe_layout)).inflate();
                        }
                        if (this.mViewDescribeTitle == null) {
                            this.mViewDescribeTitle = (TextView)((ViewStub)this.findViewById(R.id.lil_stub_describe_title)).inflate();
                        }
                        if (!TextUtils.isEmpty((CharSequence)this.mDescribeTitle)) {
                            this.mViewDescribeTitle.setText((CharSequence)this.mDescribeTitle);
                        }
                        if (this.mDescribeSubtitle != null) {
                            if (this.mViewDescribeSubtitle == null) {
                                this.mViewDescribeSubtitle = (TextView)((ViewStub)this.findViewById(R.id.lil_stub_describe_subtitle)).inflate();
                            }
                            if (!TextUtils.isEmpty((CharSequence)this.mDescribeSubtitle)) {
                                this.mViewDescribeSubtitle.setText((CharSequence)this.mDescribeSubtitle);
                            }
                        }
                        final int finalPaddingEnd = paddingEnd;
                        final int finalPaddingStart = paddingStart;
                        this.mRightImageView.post(new Runnable(){

                            @Override
                            public void run() {
                                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)OSListItemView.this.mDescribeLayout.getLayoutParams();
                                int width = OSListItemView.this.getWidth();
                                if (width <= 0) {
                                    return;
                                }
                                int maxPixels = (width - finalPaddingStart - finalPaddingEnd) / 2 - OSListItemView.this.mRightImageView.getWidth() - layoutParams.rightMargin - layoutParams.leftMargin;
                                OSListItemView.this.mViewDescribeTitle.setMaxWidth(maxPixels);
                                if (OSListItemView.this.mViewDescribeSubtitle != null) {
                                    OSListItemView.this.mViewDescribeSubtitle.setMaxWidth(maxPixels);
                                }
                            }
                        });
                    }
                } else if (this.mRightLayoutType == 3) {
                    this.mRadioButton = (RadioButton)((ViewStub)this.findViewById(R.id.lil_stub_right_radio)).inflate();
                } else if (this.mRightLayoutType == 4) {
                    this.mSwitch = (Switch)((ViewStub)this.findViewById(R.id.lil_stub_right_switch)).inflate();
                }
                RelativeLayout.LayoutParams rightImageLayoutParams = (RelativeLayout.LayoutParams)this.mRightLayout.getLayoutParams();
                rightImageLayoutParams.addRule(15);
                rightImageLayoutParams.addRule(21);
                this.mRightLayout.setLayoutParams((ViewGroup.LayoutParams)rightImageLayoutParams);
                if (this.mTitleLayout != null) {
                    RelativeLayout.LayoutParams titleLayoutLayoutParams = (RelativeLayout.LayoutParams)this.mTitleLayout.getLayoutParams();
                    titleLayoutLayoutParams.addRule(16, this.mRightLayout.getId());
                    this.mTitleLayout.setLayoutParams((ViewGroup.LayoutParams)titleLayoutLayoutParams);
                }
            }
            this.setPadding(paddingStart, paddingTop, paddingEnd, paddingTop);
        }
    }

    private void setTitleLayoutPadding(DisplayMetrics metrics, View titleLayout) {
        titleLayout.setPadding(titleLayout.getPaddingLeft(), (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)metrics), titleLayout.getPaddingRight(), titleLayout.getPaddingBottom());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mIsSettingFixedHeight) {
            this.setMeasuredDimension(widthMeasureSpec, this.mFixedHeight);
            this.mIsSettingFixedHeight = false;
        }
    }

    @Override
    public void setFixedHeight(int fixedHeight) {
        this.mFixedHeight = fixedHeight;
        this.mIsSettingFixedHeight = true;
        this.requestLayout();
    }

    @Override
    public int getFixedHeight() {
        return this.mFixedHeight;
    }

    public void startTypeTitleArrowAnim() {
        if (this.isTypeTitleArrowAnimRunning()) {
            return;
        }
        if (this.mIsGroupArrowExpend) {
            this.mAnimArrowExpend.setFloatValues(new float[]{180.0f, 0.0f});
        } else {
            this.mAnimArrowExpend.setFloatValues(new float[]{0.0f, 180.0f});
        }
        this.mAnimArrowExpend.start();
    }

    public boolean isTypeTitleArrowAnimRunning() {
        return this.mAnimArrowExpend != null && this.mAnimArrowExpend.isRunning();
    }

    public boolean isShowGroupTitleArrow() {
        return this.mIsShowGroupTitleArrow;
    }

    public void setShowGroupTitleArrow(boolean showGroupTitleArrow) {
        if (this.mItemType != 1) {
            return;
        }
        this.mIsShowGroupTitleArrow = showGroupTitleArrow;
        if (this.mViewGroupTitleArrow == null) {
            this.initGroupTitleArrow();
        }
        this.mViewGroupTitleArrow.setVisibility(showGroupTitleArrow ? 0 : 8);
    }

    private void initGroupTitleArrow() {
        if (this.mViewGroupTitleArrow == null) {
            this.mViewGroupTitleArrow = (ImageView)((ViewStub)this.findViewById(R.id.lil_stub_type_item_group_title_arrow)).inflate();
        }
        if (this.mViewGroupTitle == null) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mViewGroupTitle.getLayoutParams();
        layoutParams.addRule(16, this.mViewGroupTitleArrow.getId());
        this.mViewGroupTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mAnimArrowExpend = ObjectAnimator.ofFloat((Object)this.mViewGroupTitleArrow, (String)"rotationX", (float[])new float[]{0.0f, 0.0f});
        this.mAnimArrowExpend.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)this.getContext(), (int)R.anim.os_interpolator_liv_item_collapse));
        this.mAnimArrowExpend.setDuration(300L);
        this.mAnimArrowExpend.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                OSListItemView.this.mIsGroupArrowExpend = !OSListItemView.this.mIsGroupArrowExpend;
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimArrowExpend != null && this.mAnimArrowExpend.isRunning()) {
            this.mAnimArrowExpend.cancel();
        }
    }

    public void draw(Canvas canvas) {
        if (CoreUtils.mOsType[0].equalsIgnoreCase(CoreUtils.getOsType())) {
            if (this.mPath == null) {
                this.mPath = new Path();
                this.mRectF = new RectF();
                this.mRadii = new float[8];
            }
            if (this.mCornersAngleType == 1) {
                Arrays.fill(this.mRadii, this.mRadius);
            } else if (this.mCornersAngleType == 2) {
                Arrays.fill(this.mRadii, 0, 4, this.mRadius);
                Arrays.fill(this.mRadii, 4, this.mRadii.length, 0.0f);
            } else if (this.mCornersAngleType == 3) {
                Arrays.fill(this.mRadii, 0, 4, 0.0f);
                Arrays.fill(this.mRadii, 4, this.mRadii.length, this.mRadius);
            } else {
                Arrays.fill(this.mRadii, 0.0f);
            }
            this.mPath.reset();
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.addRoundRect(this.mRectF, this.mRadii, Path.Direction.CCW);
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
    }

    public void resetCornersRadius() {
        this.mCornersAngleType = 0;
        this.invalidate();
    }

    public void cornersRound() {
        this.mCornersAngleType = 1;
        this.invalidate();
    }

    public void topCornersRound() {
        this.mCornersAngleType = 2;
        this.invalidate();
    }

    public void bottomCornersRound() {
        this.mCornersAngleType = 3;
        this.invalidate();
    }

    @Nullable
    public Switch getSwitch() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mRightLayoutType = 4;
        if (this.mSwitch == null) {
            this.layoutViews();
        }
        return this.mSwitch;
    }

    @Nullable
    public RadioButton getRadioButton() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mRightLayoutType = 3;
        if (this.mRadioButton == null) {
            this.layoutViews();
        }
        return this.mRadioButton;
    }

    @Nullable
    public ProgressBar getProgressBar() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mTitle = "";
        this.mIsSubProgressbar = true;
        if (this.mProgressBar == null) {
            this.layoutViews();
        }
        return this.mProgressBar;
    }

    @Nullable
    public OSSeekbar getSeekBar() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mTitle = "";
        this.mIsSubSeekbar = true;
        if (this.mSeekBar == null) {
            this.layoutViews();
        }
        return this.mSeekBar;
    }

    @Nullable
    public TextView getViewTitle() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mTitle = "";
        if (this.mViewTitle == null) {
            this.layoutViews();
        }
        return this.mViewTitle;
    }

    @Nullable
    public TextView getViewSubtitle() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mSubtitle = "";
        if (this.mViewSubtitle == null) {
            this.layoutViews();
        }
        return this.mViewSubtitle;
    }

    @Nullable
    public TextView getViewDescribeTitle() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mRightLayoutType = 2;
        this.mDescribeTitle = "";
        this.mIsSetRightDrawable = true;
        if (this.mViewDescribeTitle == null) {
            this.layoutViews();
        }
        return this.mViewDescribeTitle;
    }

    @Nullable
    public TextView getViewDescribeSubtitle() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mRightLayoutType = 2;
        this.mDescribeSubtitle = "";
        if (this.mViewDescribeSubtitle == null) {
            this.layoutViews();
        }
        return this.mViewDescribeSubtitle;
    }

    @Nullable
    public ImageView getRightImageView() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mRightLayoutType = 2;
        if (this.mRightImageView == null) {
            this.layoutViews();
        }
        return this.mRightImageView;
    }

    public boolean isGroupArrowExpend() {
        return this.mIsGroupArrowExpend;
    }

    public void setGroupArrowExpend(boolean groupArrowExpend) {
        if (this.mItemType != 1) {
            return;
        }
        this.mIsGroupArrowExpend = groupArrowExpend;
        this.setShowGroupTitleArrow(true);
        if (this.mViewGroupTitleArrow != null) {
            this.mViewGroupTitleArrow.setRotationX(groupArrowExpend ? -180.0f : 0.0f);
        }
    }

    @Nullable
    public TextView getViewGroupTitle() {
        if (this.mItemType != 1) {
            return null;
        }
        if (this.mViewGroupTitle == null) {
            this.layoutViews();
        }
        return this.mViewGroupTitle;
    }

    @Nullable
    public BadgeView getBadgeView() {
        if (this.mItemType != 0) {
            return null;
        }
        this.mTitle = "";
        this.mIsShowRedDot = true;
        if (this.mBadgeView == null) {
            this.layoutViews();
        }
        return this.mBadgeView;
    }

    public void setRedDotVisible(boolean isVisible) {
        if (this.mViewTitle == null) {
            return;
        }
        if (this.mBadgeView == null) {
            this.mBadgeView = (BadgeView)((ViewStub)this.findViewById(R.id.os_stub_list_view_red_point)).inflate();
        }
        this.mBadgeView.setVisibility(isVisible ? 0 : 8);
    }

    @Nullable
    public OSRoundImageView getViewLeftImage(int dimenType) {
        if (this.mItemType != 0) {
            return null;
        }
        this.mIsShowLeftDrawable = true;
        this.mLeftDrawableDimen = dimenType;
        if (this.mViewLeftImage == null) {
            this.layoutViews();
        }
        return this.mViewLeftImage;
    }

    @Nullable
    public View getViewRightDivideLine() {
        if (this.mItemType != 0) {
            return null;
        }
        if (this.mRightLayoutType == 0) {
            return null;
        }
        if (this.mViewRightDivideLine == null) {
            this.mViewRightDivideLine = ((ViewStub)this.findViewById(R.id.lil_stub_right_divide_line)).inflate();
        }
        return this.mViewRightDivideLine;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeftDrawableDimenType {
    }
}

