/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslistitemlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.transsion.widgetslistitemlayout.R;
import java.util.Arrays;

public class OSRoundImageView
extends AppCompatImageView {
    private final Path mPath = new Path();
    private final RectF mRectF = new RectF();
    private final float[] mRadii = new float[8];
    private float mRadius;
    private boolean mIsNeedClip;

    public OSRoundImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public OSRoundImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public OSRoundImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OSRoundImageView);
            int indexCount = typedArray.getIndexCount();
            for (int at = 0; at < indexCount; ++at) {
                int index = typedArray.getIndex(at);
                if (index != R.styleable.OSRoundImageView_os_riv_radius) continue;
                this.mRadius = typedArray.getDimension(index, 0.0f);
            }
            typedArray.recycle();
        }
        boolean bl = this.mIsNeedClip = this.mRadius > 0.0f;
        if (this.mIsNeedClip) {
            Arrays.fill(this.mRadii, this.mRadius);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mIsNeedClip) {
            this.mPath.reset();
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.addRoundRect(this.mRectF, this.mRadii, Path.Direction.CCW);
            canvas.clipPath(this.mPath);
        }
        super.draw(canvas);
    }

    public void setRadius(float radius) {
        if (radius < 0.0f) {
            return;
        }
        this.mIsNeedClip = true;
        this.mRadius = radius;
        Arrays.fill(this.mRadii, this.mRadius);
        this.invalidate();
    }
}

