/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.fresh;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class TranssionApolloPropertySourcesHandler {
    private static final String APOLLO_PROPERTY_SOURCE_NAME = "ApolloPropertySources";
    public static final String CONFIG_NAMESPACES = "apollo.nameSpaces";
    private static final Multimap<Integer, String> NAMESPACE_NAMES = LinkedHashMultimap.create();
    private static ConfigurableEnvironment ENVIRONMENT;
    private static final ConfigPropertySourceFactory configPropertySourceFactory;

    public static boolean addNamespaces(Collection<String> namespaces, int order) {
        return NAMESPACE_NAMES.putAll((Object)order, namespaces);
    }

    public static ConfigurableEnvironment getEnvironment() {
        return ENVIRONMENT;
    }

    public static void initializePropertySources(ConfigurableEnvironment environment) {
        ENVIRONMENT = environment;
        CompositePropertySource composite = (CompositePropertySource)environment.getPropertySources().get(APOLLO_PROPERTY_SOURCE_NAME);
        if (composite == null) {
            composite = new CompositePropertySource(APOLLO_PROPERTY_SOURCE_NAME);
            environment.getPropertySources().addFirst((PropertySource)composite);
        }
        TranssionApolloPropertySourcesHandler.loadConfigNamespaces(environment);
        ImmutableSortedSet orders = ImmutableSortedSet.copyOf((Iterable)NAMESPACE_NAMES.keySet());
        composite.getPropertySources().clear();
        HashSet<String> nameSpaceSet = new HashSet<String>();
        for (Integer order : orders) {
            for (String namespace : NAMESPACE_NAMES.get((Object)order)) {
                if (nameSpaceSet.contains(namespace)) continue;
                Config config = ConfigService.getConfig((String)namespace);
                ConfigPropertySource configPropertySource = configPropertySourceFactory.getConfigPropertySource(namespace, config);
                composite.addPropertySource((PropertySource)configPropertySource);
                nameSpaceSet.add(namespace);
            }
        }
    }

    private static void loadConfigNamespaces(ConfigurableEnvironment environment) {
        try {
            String configNameSpaces = environment.getProperty(CONFIG_NAMESPACES, "application");
            Object[] namespaces = configNameSpaces.split(",");
            NAMESPACE_NAMES.putAll((Object)Integer.MAX_VALUE, (Iterable)Lists.newArrayList((Object[])namespaces));
        }
        catch (Exception e) {
            throw new RuntimeException("load apollo config namespace error.", e);
        }
    }

    static {
        configPropertySourceFactory = (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    }
}

