/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.legacy;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.google.common.base.Preconditions;
import com.transsion.framework.microservice.starter.apollo.legacy.TranssionConfigService;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ApolloAnnotationProcessor
implements BeanPostProcessor,
PriorityOrdered {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        this.processFields(bean, clazz.getDeclaredFields());
        this.processMethods(bean, clazz.getDeclaredMethods());
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void processFields(Object bean, Field[] declaredFields) {
        for (Field field : declaredFields) {
            ApolloConfig annotation = (ApolloConfig)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloConfig.class);
            if (annotation == null) continue;
            Preconditions.checkArgument((boolean)Config.class.isAssignableFrom(field.getType()), (String)"Invalid type: %s for field: %s, should be Config", (Object[])new Object[]{field.getType(), field});
            String namespace = annotation.value();
            Config config = TranssionConfigService.getConfig(namespace);
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)bean, (Object)config);
        }
    }

    private void processMethods(Object bean, Method[] declaredMethods) {
        for (Method method : declaredMethods) {
            String[] namespaces;
            ApolloConfigChangeListener annotation = (ApolloConfigChangeListener)AnnotationUtils.findAnnotation((Method)method, ApolloConfigChangeListener.class);
            if (annotation == null) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (Object[])new Object[]{parameterTypes.length, method});
            Preconditions.checkArgument((boolean)ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", (Object[])new Object[]{parameterTypes[0], method});
            ReflectionUtils.makeAccessible((Method)method);
            for (String namespace : namespaces = annotation.value()) {
                Config config = TranssionConfigService.getConfig(namespace);
                config.addChangeListener(changeEvent -> ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{changeEvent}));
            }
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

