/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.legacy;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.enums.EnvUtils;
import com.ctrip.framework.foundation.Foundation;
import com.transsion.framework.microservice.starter.apollo.legacy.ApolloPropertySourcesHandler;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class ApolloEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private int order = -2147483637;

    public int getOrder() {
        return this.order;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String appId = environment.getProperty("transsion.appId");
        if (StringUtils.isEmpty((Object)appId)) {
            System.out.println("can not find appId property in spring environment.");
            return;
        }
        Env apolloEnv = EnvUtils.transformEnv((String)Foundation.server().getEnvType());
        environment.addActiveProfile(apolloEnv.name().toLowerCase());
        ApolloPropertySourcesHandler.initializePropertySources(environment);
    }
}

