/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.legacy;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.transsion.framework.microservice.starter.apollo.legacy.TranssionConfigService;
import java.util.Collection;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class ApolloPropertySourcesHandler {
    private static final String APOLLO_PROPERTY_SOURCE_NAME = "ApolloPropertySources";
    public static final String CONFIG_NAMESPACES = "apollo.nameSpaces";
    private static final Multimap<Integer, String> NAMESPACE_NAMES = LinkedHashMultimap.create();
    private static ConfigurableEnvironment ENVIRONMENT;
    private static final ConfigPropertySourceFactory configPropertySourceFactory;

    public static boolean addNamespaces(Collection<String> namespaces, int order) {
        return NAMESPACE_NAMES.putAll((Object)order, namespaces);
    }

    public static ConfigurableEnvironment getEnvironment() {
        return ENVIRONMENT;
    }

    public static void initializePropertySources(ConfigurableEnvironment environment) {
        ENVIRONMENT = environment;
        CompositePropertySource composite = (CompositePropertySource)environment.getPropertySources().get(APOLLO_PROPERTY_SOURCE_NAME);
        if (composite == null) {
            composite = new CompositePropertySource(APOLLO_PROPERTY_SOURCE_NAME);
            environment.getPropertySources().addFirst((PropertySource)composite);
        }
        ApolloPropertySourcesHandler.loadConfigNamespaces(environment);
        ImmutableSortedSet orders = ImmutableSortedSet.copyOf((Iterable)NAMESPACE_NAMES.keySet());
        composite.getPropertySources().clear();
        for (Integer order : orders) {
            for (String namespace : NAMESPACE_NAMES.get((Object)order)) {
                Config config = TranssionConfigService.getConfig(namespace);
                composite.addPropertySource((PropertySource)configPropertySourceFactory.getConfigPropertySource(namespace, config));
            }
        }
    }

    private static void loadConfigNamespaces(ConfigurableEnvironment environment) {
        try {
            String configNameSpaces = environment.getProperty(CONFIG_NAMESPACES);
            if (StringUtils.isEmpty((Object)configNameSpaces)) {
                return;
            }
            Object[] namespaces = configNameSpaces.split(",");
            NAMESPACE_NAMES.putAll((Object)Integer.MAX_VALUE, (Iterable)Lists.newArrayList((Object[])namespaces));
        }
        catch (Exception e) {
            throw new RuntimeException("load apollo config namespace error.", e);
        }
    }

    static {
        configPropertySourceFactory = (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    }
}

