/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.legacy;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.internals.ConfigManager;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.tracer.Tracer;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class TranssionConfigService {
    private static final TranssionConfigService s_instance = new TranssionConfigService();
    private PlexusContainer m_container;
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    private TranssionConfigService() {
        try {
            DefaultContainerConfiguration configuration = new DefaultContainerConfiguration();
            configuration.setContainerConfiguration("META-INF/components-transsion.xml");
            this.m_container = new DefaultPlexusContainer((ContainerConfiguration)configuration);
            this.m_container.dispose();
        }
        catch (PlexusContainerException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            TranssionConfigService transsionConfigService = this;
            synchronized (transsionConfigService) {
                if (this.m_configManager == null) {
                    try {
                        this.m_configManager = (ConfigManager)this.m_container.lookup(ConfigManager.class);
                    }
                    catch (ComponentLookupException ex) {
                        ApolloConfigException exception = new ApolloConfigException("Unable to load ConfigManager!", (Throwable)ex);
                        Tracer.logError((Throwable)exception);
                        throw exception;
                    }
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            TranssionConfigService transsionConfigService = this;
            synchronized (transsionConfigService) {
                if (this.m_configRegistry == null) {
                    try {
                        this.m_configRegistry = (ConfigRegistry)this.m_container.lookup(ConfigRegistry.class);
                    }
                    catch (ComponentLookupException ex) {
                        ApolloConfigException exception = new ApolloConfigException("Unable to load ConfigRegistry!", (Throwable)ex);
                        Tracer.logError((Throwable)exception);
                        throw exception;
                    }
                }
            }
        }
        return this.m_configRegistry;
    }

    public static Config getAppConfig() {
        return TranssionConfigService.getConfig("application");
    }

    public static Config getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static ConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(Config config) {
        TranssionConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final Config config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            public Config create(String namespace) {
                return config;
            }

            public ConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        TranssionConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setContainer(PlexusContainer m_container) {
        TranssionConfigService transsionConfigService = s_instance;
        synchronized (transsionConfigService) {
            TranssionConfigService.s_instance.m_container = m_container;
            TranssionConfigService.s_instance.m_configManager = null;
            TranssionConfigService.s_instance.m_configRegistry = null;
        }
    }
}

