/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter.apollo.legacy;

import com.ctrip.framework.apollo.util.ConfigUtil;
import com.transsion.framework.microservice.starter.apollo.legacy.ApolloPropertySourcesHandler;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;
import org.unidal.lookup.annotation.Named;

@Named(type=ConfigUtil.class)
public class TranssionConfigUtil
extends ConfigUtil {
    public static final String APPID_KEY = "transsion.appId";
    public static final String CONFIG_NAMESPACES = "apollo.nameSpaces";
    private String appId;
    private String domain;

    public TranssionConfigUtil() {
        this.initConfig();
    }

    private void initConfig() {
        try {
            ConfigurableEnvironment env = ApolloPropertySourcesHandler.getEnvironment();
            if (env == null) {
                throw new RuntimeException("init apollo error, spring envrionment is not inited.");
            }
            this.appId = env.getProperty(APPID_KEY);
            if (StringUtils.isEmpty((Object)this.appId)) {
                throw new RuntimeException("'transsion.appId' is empty , check config in spring envrionment.");
            }
            String domainKey = "apollo." + this.getApolloEnv().name().toLowerCase();
            this.domain = env.getProperty(domainKey);
            if (StringUtils.isEmpty((Object)this.domain)) {
                throw new RuntimeException(String.format("'%s' is empty, check config in spring envrionment.", domainKey));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("init apollo config error.", e);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMetaServerDomainName() {
        return this.domain;
    }
}

