/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.framework.microservice.starter;

import com.transsion.framework.microservice.exception.NoStackException;
import com.transsion.framework.microservice.starter.CommonProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CommonProperties.class})
public class CommonAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CommonAutoConfiguration.class);
    private CommonProperties commonProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    public CommonAutoConfiguration(CommonProperties commonProperties) {
        this.commonProperties = commonProperties;
        logger.debug("constructing ....");
    }

    @PostConstruct
    public void init() {
        if (StringUtils.isEmpty((Object)this.commonProperties.getAppId())) {
            logger.error("appid is null");
            throw new NoStackException("transsion.appId must be defined in src/main/resources/application.properties", "APPID_NOT_FOUND", CommonAutoConfiguration.class.getCanonicalName(), "newCommonProperties");
        }
        if (StringUtils.isEmpty((Object)this.applicationContext.getId())) {
            throw new NoStackException("spring.application.name must be defined in src/main/resources/application.properties", "SERVICE_NAME_NOT_FOUND", CommonAutoConfiguration.class.getCanonicalName(), "newCommonProperties");
        }
    }
}

