/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.gamead.view.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.MobileAds;
import com.transsion.gamead.proguard.u4;
import com.transsion.gamead.view.webview.H5Bridge;
import com.transsion.gamead.view.webview.H5WebChromeClient;
import com.transsion.gamead.view.webview.H5WebViewClient;
import com.transsion.gamead.view.webview.H5WebViewEventListener;

public class H5WebView
extends WebView {
    private H5WebViewClient client;
    private H5WebChromeClient chromeClient;
    private H5Bridge.CommonBridge commonBridge;

    public H5WebView(@NonNull Context context) {
        H5WebView h5WebView = this;
        super(context);
        h5WebView.init();
    }

    public H5WebView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        H5WebView h5WebView = this;
        super(context, attributeSet);
        h5WebView.init();
    }

    public H5WebView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n5) {
        H5WebView h5WebView = this;
        super(context, attributeSet, n5);
        h5WebView.init();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        H5WebChromeClient h5WebChromeClient;
        H5WebViewClient h5WebViewClient;
        Object object = this.getSettings();
        object.setJavaScriptEnabled(true);
        object.setCacheMode(-1);
        object.setDomStorageEnabled(true);
        int n5 = Build.VERSION.SDK_INT;
        if (n5 >= 21) {
            object.setMixedContentMode(0);
        }
        H5WebView h5WebView = this;
        WebSettings webSettings = object;
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setAllowUniversalAccessFromFileURLs(true);
        webSettings.setCacheMode(-1);
        webSettings.setDatabaseEnabled(true);
        object = webSettings.getUserAgentString();
        webSettings.setUserAgentString((String)object + "GameSDK");
        object = h5WebViewClient;
        h5WebView.client = new H5WebViewClient();
        h5WebView.setWebViewClient((WebViewClient)object);
        object = h5WebChromeClient;
        h5WebView.chromeClient = new H5WebChromeClient();
        h5WebView.setWebChromeClient((WebChromeClient)object);
        if (n5 >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
            MobileAds.registerWebView((WebView)this);
        }
    }

    public void addJsInterface() {
        if (this.commonBridge == null) {
            this.commonBridge = new H5Bridge.CommonBridge(this.getContext());
        }
        H5WebView h5WebView = this;
        h5WebView.addJavascriptInterface(h5WebView.commonBridge, "commonBridge");
        h5WebView.addJavascriptInterface(new H5Bridge.H5ActivityBridge(), "activityBridge");
    }

    public void setCommonBridgeListener(H5Bridge.CommonBridge.Listener listener) {
        H5Bridge.CommonBridge commonBridge = ((H5WebView)((Object)commonBridge)).commonBridge;
        if (commonBridge != null) {
            commonBridge.setListener(listener);
        }
    }

    public void setCommonBridgeUIListener(final H5Bridge.CommonBridge.UIListener uIListener) {
        if (this.commonBridge != null) {
            u4.a(new Runnable(){

                @Override
                public void run() {
                    H5WebView.this.commonBridge.setUiListener(uIListener);
                }
            });
        }
    }

    public void setEventListener(H5WebViewEventListener h5WebViewEventListener) {
        H5WebViewClient h5WebViewClient = ((H5WebView)((Object)this)).client;
        if (h5WebViewClient != null) {
            h5WebViewClient.setListener(h5WebViewEventListener);
        }
        if ((this = ((H5WebView)((Object)this)).chromeClient) != null) {
            ((H5WebChromeClient)((Object)this)).setListener(h5WebViewEventListener);
        }
    }
}

