/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.transsion.game.datastore.AppDb;
import com.transsion.game.datastore.dao.BaseConfigDao;
import com.transsion.game.datastore.dao.BaseConfigDao_Impl;
import com.transsion.game.datastore.dao.GameConfigDao;
import com.transsion.game.datastore.dao.GameConfigDao_Impl;
import com.transsion.game.datastore.dao.OrderDao;
import com.transsion.game.datastore.dao.OrderDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public final class AppDb_Impl
extends AppDb {
    private volatile BaseConfigDao _baseConfigDao;
    private volatile GameConfigDao _gameConfigDao;
    private volatile OrderDao _orderDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Order` (`id` TEXT NOT NULL, `encryptInfo` TEXT, `key` TEXT, `iv` TEXT, `retryCount` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `BaseConfig` (`configId` TEXT NOT NULL, `mcc` TEXT, `level` TEXT, `amount` TEXT, `mccMnc` TEXT, PRIMARY KEY(`configId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `GameConfig` (`appKey` TEXT NOT NULL, `productId` TEXT NOT NULL, `productName` TEXT, `level` TEXT, PRIMARY KEY(`appKey`, `productId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'f7bf0cd49d7ec5d8bbe98e912c9b2e11')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Order`");
                _db.execSQL("DROP TABLE IF EXISTS `BaseConfig`");
                _db.execSQL("DROP TABLE IF EXISTS `GameConfig`");
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AppDb_Impl.this.mDatabase = _db;
                AppDb_Impl.this.internalInitInvalidationTracker(_db);
                if (AppDb_Impl.this.mCallbacks != null) {
                    int _size = AppDb_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDb_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsOrder = new HashMap<String, TableInfo.Column>(5);
                _columnsOrder.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsOrder.put("encryptInfo", new TableInfo.Column("encryptInfo", "TEXT", false, 0, null, 1));
                _columnsOrder.put("key", new TableInfo.Column("key", "TEXT", false, 0, null, 1));
                _columnsOrder.put("iv", new TableInfo.Column("iv", "TEXT", false, 0, null, 1));
                _columnsOrder.put("retryCount", new TableInfo.Column("retryCount", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysOrder = new HashSet(0);
                HashSet _indicesOrder = new HashSet(0);
                TableInfo _infoOrder = new TableInfo("Order", _columnsOrder, _foreignKeysOrder, _indicesOrder);
                TableInfo _existingOrder = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Order");
                if (!_infoOrder.equals((Object)_existingOrder)) {
                    return new RoomOpenHelper.ValidationResult(false, "Order(com.transsion.game.datastore.table.OrderTable).\n Expected:\n" + _infoOrder + "\n Found:\n" + _existingOrder);
                }
                HashMap<String, TableInfo.Column> _columnsBaseConfig = new HashMap<String, TableInfo.Column>(5);
                _columnsBaseConfig.put("configId", new TableInfo.Column("configId", "TEXT", true, 1, null, 1));
                _columnsBaseConfig.put("mcc", new TableInfo.Column("mcc", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("level", new TableInfo.Column("level", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("amount", new TableInfo.Column("amount", "TEXT", false, 0, null, 1));
                _columnsBaseConfig.put("mccMnc", new TableInfo.Column("mccMnc", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysBaseConfig = new HashSet(0);
                HashSet _indicesBaseConfig = new HashSet(0);
                TableInfo _infoBaseConfig = new TableInfo("BaseConfig", _columnsBaseConfig, _foreignKeysBaseConfig, _indicesBaseConfig);
                TableInfo _existingBaseConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"BaseConfig");
                if (!_infoBaseConfig.equals((Object)_existingBaseConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "BaseConfig(com.transsion.game.datastore.table.BaseConfigTable).\n Expected:\n" + _infoBaseConfig + "\n Found:\n" + _existingBaseConfig);
                }
                HashMap<String, TableInfo.Column> _columnsGameConfig = new HashMap<String, TableInfo.Column>(4);
                _columnsGameConfig.put("appKey", new TableInfo.Column("appKey", "TEXT", true, 1, null, 1));
                _columnsGameConfig.put("productId", new TableInfo.Column("productId", "TEXT", true, 2, null, 1));
                _columnsGameConfig.put("productName", new TableInfo.Column("productName", "TEXT", false, 0, null, 1));
                _columnsGameConfig.put("level", new TableInfo.Column("level", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysGameConfig = new HashSet(0);
                HashSet _indicesGameConfig = new HashSet(0);
                TableInfo _infoGameConfig = new TableInfo("GameConfig", _columnsGameConfig, _foreignKeysGameConfig, _indicesGameConfig);
                TableInfo _existingGameConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"GameConfig");
                if (!_infoGameConfig.equals((Object)_existingGameConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "GameConfig(com.transsion.game.datastore.table.GameConfigTable).\n Expected:\n" + _infoGameConfig + "\n Found:\n" + _existingGameConfig);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "f7bf0cd49d7ec5d8bbe98e912c9b2e11", "cc988b0b0b341ed5b85156fafb942b5c");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"Order", "BaseConfig", "GameConfig"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `Order`");
            _db.execSQL("DELETE FROM `BaseConfig`");
            _db.execSQL("DELETE FROM `GameConfig`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseConfigDao baseConfigDao() {
        if (this._baseConfigDao != null) {
            return this._baseConfigDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._baseConfigDao == null) {
                this._baseConfigDao = new BaseConfigDao_Impl(this);
            }
            return this._baseConfigDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameConfigDao gameConfigDao() {
        if (this._gameConfigDao != null) {
            return this._gameConfigDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._gameConfigDao == null) {
                this._gameConfigDao = new GameConfigDao_Impl(this);
            }
            return this._gameConfigDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderDao orderDao() {
        if (this._orderDao != null) {
            return this._orderDao;
        }
        AppDb_Impl appDb_Impl = this;
        synchronized (appDb_Impl) {
            if (this._orderDao == null) {
                this._orderDao = new OrderDao_Impl(this);
            }
            return this._orderDao;
        }
    }
}

