/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore;

import android.app.Application;
import android.content.Context;
import android.util.ArrayMap;
import androidx.annotation.NonNull;
import com.transsion.game.datastore.cache.DbInit;

public class DataInitializer {
    private static volatile DataInitializer sDataInitializer;
    private final Application application;
    private final ArrayMap<Class<?>, DbInit<?, ?>> dbInitMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void init(Builder builder) {
        DataInitializer newDataInitializer = builder.build();
        DataInitializer dataInitializer = sDataInitializer;
        if (dataInitializer == null) {
            Class<DataInitializer> clazz = DataInitializer.class;
            // MONITORENTER : com.transsion.game.datastore.DataInitializer.class
            dataInitializer = sDataInitializer;
            if (dataInitializer == null) {
                sDataInitializer = dataInitializer = newDataInitializer;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        if (newDataInitializer.dbInitMap.size() <= 0) return;
        dataInitializer.add(newDataInitializer.dbInitMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DataInitializer get() {
        DataInitializer dataInitializer = sDataInitializer;
        if (dataInitializer != null) return dataInitializer;
        Class<DataInitializer> clazz = DataInitializer.class;
        synchronized (DataInitializer.class) {
            dataInitializer = sDataInitializer;
            if (dataInitializer != null) return dataInitializer;
            throw new NullPointerException();
        }
    }

    public static Context getContext() {
        Application application = DataInitializer.get().application;
        if (application == null) {
            throw new NullPointerException();
        }
        return application;
    }

    public static <T> DbInit<?, T> getDbInit(Class<T> daoClz) {
        return DataInitializer.get().getDbInitInternal(daoClz);
    }

    private DataInitializer(Builder builder) {
        this.application = builder.application;
        this.dbInitMap = builder.dbInitMap;
    }

    private synchronized void add(@NonNull ArrayMap<Class<?>, DbInit<?, ?>> dbInitMap) {
        for (int i = 0; i < dbInitMap.size(); ++i) {
            this.dbInitMap.put(dbInitMap.keyAt(i), dbInitMap.valueAt(i));
        }
    }

    private synchronized <T> DbInit<?, T> getDbInitInternal(Class<T> daoClz) {
        return (DbInit)this.dbInitMap.get(daoClz);
    }

    public static class Builder {
        private final Application application;
        private final ArrayMap<Class<?>, DbInit<?, ?>> dbInitMap = new ArrayMap();

        public Builder(Application application) {
            this.application = application;
        }

        public <T> Builder addDbInit(@NonNull Class<T> daoClz, @NonNull DbInit<?, T> dbInit) {
            this.dbInitMap.put(daoClz, dbInit);
            return this;
        }

        private DataInitializer build() {
            return new DataInitializer(this);
        }
    }
}

