/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.transsion.game.datastore.dao.GameConfigDao;
import com.transsion.game.datastore.table.GameConfigTable;
import java.util.ArrayList;
import java.util.List;

public final class GameConfigDao_Impl
extends GameConfigDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GameConfigTable> __insertionAdapterOfGameConfigTable;
    private final SharedSQLiteStatement __preparedStmtOfClearTable;

    public GameConfigDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGameConfigTable = new EntityInsertionAdapter<GameConfigTable>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `GameConfig` (`appKey`,`productId`,`productName`,`level`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GameConfigTable value) {
                if (value.appKey == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.appKey);
                }
                if (value.productId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.productId);
                }
                if (value.productName == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.productName);
                }
                if (value.level == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.level);
                }
            }
        };
        this.__preparedStmtOfClearTable = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from gameconfig where appKey = ?";
                return "delete from gameconfig where appKey = ?";
            }
        };
    }

    @Override
    public void insertGameConfig(List<GameConfigTable> list) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGameConfigTable.insert(list);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearAndInsertWithoutNull(String appKey, List<GameConfigTable> list) {
        this.__db.beginTransaction();
        try {
            GameConfigDao_Impl.super.clearAndInsertWithoutNull(appKey, list);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTable(String appKey) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearTable.acquire();
        int _argIndex = 1;
        if (appKey == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, appKey);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearTable.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count() {
        String _sql = "select count(*) from gameconfig";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select count(*) from gameconfig", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GameConfigTable getGameConfig(String appKey, String productId) {
        String _sql = "select * from gameconfig where appKey=? and productId=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from gameconfig where appKey=? and productId=?", (int)2);
        int _argIndex = 1;
        if (appKey == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, appKey);
        }
        _argIndex = 2;
        if (productId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, productId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            GameConfigTable _result;
            int _cursorIndexOfAppKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appKey");
            int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
            int _cursorIndexOfProductName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productName");
            int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"level");
            if (_cursor.moveToFirst()) {
                String _tmpAppKey = _cursor.getString(_cursorIndexOfAppKey);
                String _tmpProductId = _cursor.getString(_cursorIndexOfProductId);
                _result = new GameConfigTable(_tmpAppKey, _tmpProductId);
                _result.productName = _cursor.getString(_cursorIndexOfProductName);
                _result.level = _cursor.getString(_cursorIndexOfLevel);
            } else {
                _result = null;
            }
            GameConfigTable gameConfigTable = _result;
            return gameConfigTable;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GameConfigTable> getGameConfig(String appKey) {
        String _sql = "select * from gameconfig where appKey=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from gameconfig where appKey=?", (int)1);
        int _argIndex = 1;
        if (appKey == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, appKey);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfAppKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"appKey");
            int _cursorIndexOfProductId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productId");
            int _cursorIndexOfProductName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"productName");
            int _cursorIndexOfLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"level");
            ArrayList<GameConfigTable> _result = new ArrayList<GameConfigTable>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpAppKey = _cursor.getString(_cursorIndexOfAppKey);
                String _tmpProductId = _cursor.getString(_cursorIndexOfProductId);
                GameConfigTable _item = new GameConfigTable(_tmpAppKey, _tmpProductId);
                _item.productName = _cursor.getString(_cursorIndexOfProductName);
                _item.level = _cursor.getString(_cursorIndexOfLevel);
                _result.add(_item);
            }
            ArrayList<GameConfigTable> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

