/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.transsion.game.datastore.dao.OrderDao;
import com.transsion.game.datastore.table.OrderTable;
import java.util.ArrayList;
import java.util.List;

public final class OrderDao_Impl
implements OrderDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrderTable> __insertionAdapterOfOrderTable;
    private final SharedSQLiteStatement __preparedStmtOfUpdateRetryCount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteById;

    public OrderDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderTable = new EntityInsertionAdapter<OrderTable>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Order` (`id`,`encryptInfo`,`key`,`iv`,`retryCount`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderTable value) {
                if (value.id == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.id);
                }
                if (value.encryptInfo == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.encryptInfo);
                }
                if (value.key == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.key);
                }
                if (value.iv == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.iv);
                }
                stmt.bindLong(5, (long)value.retryCount);
            }
        };
        this.__preparedStmtOfUpdateRetryCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update `order` set retryCount=? where id=?";
                return "update `order` set retryCount=? where id=?";
            }
        };
        this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from `order` where id=?";
                return "delete from `order` where id=?";
            }
        };
    }

    @Override
    public void insertOrder(OrderTable orderTable) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfOrderTable.insert((Object)orderTable);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRetryCount(String id, int count) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateRetryCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)count);
        _argIndex = 2;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateRetryCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteById(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteById.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getOrderIds() {
        String _sql = "select id from `order`";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select id from `order`", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderTable getOrderById(String id) {
        String _sql = "select * from `order` where id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from `order` where id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            OrderTable _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfEncryptInfo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"encryptInfo");
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfIv = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv");
            int _cursorIndexOfRetryCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retryCount");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result = new OrderTable(_tmpId);
                _result.encryptInfo = _cursor.getString(_cursorIndexOfEncryptInfo);
                _result.key = _cursor.getString(_cursorIndexOfKey);
                _result.iv = _cursor.getString(_cursorIndexOfIv);
                _result.retryCount = _cursor.getInt(_cursorIndexOfRetryCount);
            } else {
                _result = null;
            }
            OrderTable orderTable = _result;
            return orderTable;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

