/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.game.datastore.sp;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.security.crypto.EncryptedSharedPreferences;
import com.transsion.game.datastore.DataInitializer;
import com.transsion.game.datastore.sp.EncryptedSP;
import com.transsion.game.datastore.sp.FadeSharedPreferences;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class EncryptedSpUtil {
    private static final String SP_FILE_NAME = "gamepay_security_config";

    private static Context getContext() {
        return DataInitializer.getContext();
    }

    @NonNull
    public static SharedPreferences getSecuritySp() {
        Context context = EncryptedSpUtil.getContext();
        if (Build.VERSION.SDK_INT < 23) {
            return new EncryptedSP(context, SP_FILE_NAME);
        }
        try {
            return EncryptedSharedPreferences.create((String)SP_FILE_NAME, (String)"_androidx_security_master_key_", (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
            return new FadeSharedPreferences();
        }
    }
}

