/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.gamesdk.scroll;

import android.app.Activity;
import android.content.Context;
import android.text.Layout;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.transsion.gamesdk.scroll.R;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LogUtilPlugin {
    private static TextView textView;
    protected static final List<String> mAdInfoList;
    private static final SimpleDateFormat sdf;

    public static void init(final Activity activity, final int marginTop) {
        Log.d((String)"LogUtilPlugin", (String)"init: ");
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                View view = LayoutInflater.from((Context)activity).inflate(R.layout.game_text_log_layout, null, false);
                textView = (TextView)view.findViewById(R.id.textView);
                if (marginTop > 0) {
                    ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)textView.getLayoutParams();
                    params.topMargin = marginTop;
                    view.setLayoutParams((ViewGroup.LayoutParams)params);
                }
                textView.setMovementMethod(ScrollingMovementMethod.getInstance());
                activity.addContentView(view, new ViewGroup.LayoutParams(-1, -1));
            }
        });
    }

    public static void addAndShow(Activity activity, final String showInfo) {
        Log.d((String)"LogUtilPlugin", (String)("addAndShow: " + showInfo));
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (textView != null) {
                    String data = sdf.format(new Date(System.currentTimeMillis()));
                    mAdInfoList.add(data + ":" + showInfo);
                    StringBuilder sb = new StringBuilder();
                    for (String s : mAdInfoList) {
                        sb.append(s).append("\n");
                    }
                    textView.setText((CharSequence)sb.toString());
                    int textHintViewHeight = LogUtilPlugin.getTextHintViewHeight(textView);
                    if (-1 == textHintViewHeight) {
                        return;
                    }
                    if (textHintViewHeight > textView.getHeight()) {
                        textView.scrollTo(0, textHintViewHeight - textView.getHeight());
                    }
                }
            }
        });
    }

    private static int getTextHintViewHeight(TextView view) {
        Layout layout2 = view.getLayout();
        if (layout2 == null) {
            return -1;
        }
        int desired = layout2.getLineTop(view.getLineCount());
        int padding = view.getCompoundPaddingTop() + view.getCompoundPaddingBottom();
        return desired + padding;
    }

    static {
        mAdInfoList = new ArrayList<String>();
        sdf = new SimpleDateFormat("HH:mm:ss");
    }
}

