/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.udp;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.transsion.iot.communication.packet.resp.BasicInfo;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient;", "", "()V", "BROADCAST_PORT", "", "MSG_RECEIVE_DATA", "MSG_RECEIVE_ERROR", "mHandler", "Landroid/os/Handler;", "mPort", "mReceiveThread", "Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "mSocket", "Ljava/net/DatagramSocket;", "setReceiveHandler", "", "handler", "startReceive", "port", "stopReceive", "SocketReceiveThread", "communication_release"})
public final class UDPClient {
    @NotNull
    public static final UDPClient INSTANCE = new UDPClient();
    public static final int BROADCAST_PORT = 6000;
    public static final int MSG_RECEIVE_DATA = 100;
    public static final int MSG_RECEIVE_ERROR = -100;
    private static SocketReceiveThread mReceiveThread;
    private static Handler mHandler;
    private static int mPort;
    @Nullable
    private static DatagramSocket mSocket;

    private UDPClient() {
    }

    public final void startReceive(int port) {
        mPort = port;
        try {
            Object object;
            if (mSocket != null && (object = mSocket) != null) {
                ((DatagramSocket)object).close();
            }
            if ((mSocket = new DatagramSocket(mPort)) == null) {
                mSocket = new DatagramSocket(null);
                object = mSocket;
                if (object != null) {
                    ((DatagramSocket)object).setReuseAddress(true);
                }
                object = mSocket;
                if (object != null) {
                    ((DatagramSocket)object).bind(new InetSocketAddress(mPort));
                }
            }
            if ((object = (mReceiveThread = new SocketReceiveThread())) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
                throw null;
            }
            ((Thread)object).start();
        }
        catch (Exception e) {
            Handler handler = mHandler;
            if (handler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                throw null;
            }
            Message message = handler.obtainMessage();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler.obtainMessage()");
            Message msg = message;
            msg.what = -100;
            msg.obj = e.getMessage();
            message = mHandler;
            if (message == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                throw null;
            }
            message.sendMessage(msg);
        }
    }

    public static /* synthetic */ void startReceive$default(UDPClient uDPClient, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 6000;
        }
        uDPClient.startReceive(n);
    }

    public final void stopReceive() {
        Object object = mReceiveThread;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
            throw null;
        }
        ((SocketReceiveThread)object).threadExit();
        object = mHandler;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
            throw null;
        }
        object.removeMessages(-100);
        object = mHandler;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
            throw null;
        }
        object.removeMessages(100);
        if (mSocket != null && (object = mSocket) != null) {
            ((DatagramSocket)object).close();
        }
    }

    public final void setReceiveHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        mHandler = handler;
    }

    static {
        mPort = 6000;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0003\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "Ljava/lang/Thread;", "()V", "threadExit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "run", "", "communication_release"})
    public static final class SocketReceiveThread
    extends Thread {
        @NotNull
        private AtomicBoolean threadExit = new AtomicBoolean(false);

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (!this.threadExit.get()) {
                Message msg;
                Message message;
                Handler handler;
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                    DatagramSocket datagramSocket = mSocket;
                    if (datagramSocket != null) {
                        datagramSocket.receive(datagramPacket);
                    }
                    int n = 0;
                    int n2 = datagramPacket.getLength();
                    boolean bl = false;
                    String receiveData = new String(buffer, n, n2, Charsets.UTF_8);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"receiveData=", (Object)receiveData));
                    BasicInfo basicInfo = (BasicInfo)new Gson().fromJson(receiveData, BasicInfo.class);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"basicInfo=", (Object)basicInfo));
                    Handler handler2 = mHandler;
                    if (handler2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    Message message2 = handler2.obtainMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"mHandler.obtainMessage()");
                    Message msg2 = message2;
                    msg2.what = 100;
                    msg2.obj = basicInfo;
                    message2 = mHandler;
                    if (message2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    message2.sendMessage(msg2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    handler = mHandler;
                    if (handler == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    message = handler.obtainMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler.obtainMessage()");
                    msg = message;
                    msg.what = -100;
                    msg.obj = e.getMessage();
                    message = mHandler;
                    if (message == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    message.sendMessage(msg);
                    this.threadExit();
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                    handler = mHandler;
                    if (handler == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    message = handler.obtainMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler.obtainMessage()");
                    msg = message;
                    msg.what = -100;
                    msg.obj = e.getMessage();
                    message = mHandler;
                    if (message == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mHandler");
                        throw null;
                    }
                    message.sendMessage(msg);
                    this.threadExit();
                }
            }
        }

        public final void threadExit() {
            this.threadExit.set(true);
        }
    }
}

