package com.transsion.iot.communication.packet

import com.transsion.iot.communication.ResponseCode
import java.io.Serializable

/**
 * @Author fuhuang.fan
 * @Date 2022/7/8/008 15:24
 * @Description
 */
class ResponseData <T> (var code: Int, var data: T, var id: String, var serviceId: String, var msg: String? = null): Serializable {
    override fun toString(): String {
        return "RequestData(id='$id', code ='$code', data='$data', serviceId='$serviceId', msg='$msg')"
    }

    fun isSuccess(): Boolean {
        return code == ResponseCode.CODE_SUCCESS
    }
}