/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.packet;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/transsion/iot/communication/packet/TCPPacket;", "", "()V", "PACKET_FOOTER_H", "", "getPACKET_FOOTER_H", "()I", "PACKET_FOOTER_L", "getPACKET_FOOTER_L", "PACKET_HEADER_H", "getPACKET_HEADER_H", "PACKET_HEADER_L", "getPACKET_HEADER_L", "TAG", "", "getTAG", "()Ljava/lang/String;", "getData", "byteArray", "", "count", "getPacket", "data", "intToByteArray2", "num", "communication_release"})
public final class TCPPacket {
    @NotNull
    public static final TCPPacket INSTANCE = new TCPPacket();
    @NotNull
    private static final String TAG = "TCPPacket";
    private static final int PACKET_HEADER_H = 192;
    private static final int PACKET_HEADER_L;
    private static final int PACKET_FOOTER_H;
    private static final int PACKET_FOOTER_L;

    private TCPPacket() {
    }

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    public final int getPACKET_HEADER_H() {
        return PACKET_HEADER_H;
    }

    public final int getPACKET_HEADER_L() {
        return PACKET_HEADER_L;
    }

    public final int getPACKET_FOOTER_H() {
        return PACKET_FOOTER_H;
    }

    public final int getPACKET_FOOTER_L() {
        return PACKET_FOOTER_L;
    }

    @NotNull
    public final byte[] getPacket(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CharSequence charSequence = data;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return new byte[0];
        }
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] tempArray = byArray;
        int length = tempArray.length;
        byte[] byteArray = new byte[length + 8];
        byteArray[0] = (byte)PACKET_HEADER_H;
        byteArray[1] = (byte)PACKET_HEADER_L;
        byteArray[2] = 0;
        byteArray[3] = 0;
        System.arraycopy(this.intToByteArray2(length), 0, byteArray, 4, 2);
        System.arraycopy(tempArray, 0, byteArray, 6, length);
        byteArray[length + 6] = (byte)PACKET_FOOTER_H;
        byteArray[length + 7] = (byte)PACKET_FOOTER_L;
        return byteArray;
    }

    @NotNull
    public final String getData(@NotNull byte[] byteArray, int count) {
        int n;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
                if (count <= 8) break block5;
                byte[] byArray = byteArray;
                n = 0;
                if (!(byArray.length == 0) && byteArray.length >= 8) break block6;
            }
            return "";
        }
        if (byteArray[0] != (byte)PACKET_HEADER_H || byteArray[1] != (byte)PACKET_HEADER_L) {
            Log.d((String)TAG, (String)"receive header is invalid");
            return "";
        }
        if (byteArray[count - 1] != (byte)PACKET_FOOTER_L || byteArray[count - 2] != (byte)PACKET_FOOTER_H) {
            Log.d((String)TAG, (String)"receive footer is invalid");
            return "";
        }
        int dataLength = ByteBuffer.wrap(byteArray, 4, 2).getInt();
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"receive length=", (Object)dataLength));
        n = 6;
        boolean bl = false;
        return new String(byteArray, n, dataLength, Charsets.UTF_8);
    }

    private final byte[] intToByteArray2(int num) {
        byte[] byteArray = new byte[2];
        byte lowH = (byte)(num >> 8 & 0xFF);
        byte lowL = (byte)(num & 0xFF);
        byteArray[0] = lowH;
        byteArray[1] = lowL;
        return byteArray;
    }

    static {
        PACKET_FOOTER_H = 12;
    }
}

