/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.udp;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.transsion.iot.communication.packet.resp.BasicInfo;
import com.transsion.iot.communication.udp.IUDPMessageReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient;", "", "()V", "BROADCAST_PORT", "", "mMessageReceivers", "Ljava/util/ArrayList;", "Lcom/transsion/iot/communication/udp/IUDPMessageReceiver;", "Lkotlin/collections/ArrayList;", "mPort", "mReceiveThread", "Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "mSocket", "Ljava/net/DatagramSocket;", "onReceiveError", "", "errMsg", "", "onReceiveMessage", "basicInfo", "Lcom/transsion/iot/communication/packet/resp/BasicInfo;", "registerMessageReceiver", "receiver", "startReceive", "port", "stopReceive", "unregisterMessageReceiver", "SocketReceiveThread", "communication_release"})
public final class UDPClient {
    @NotNull
    public static final UDPClient INSTANCE = new UDPClient();
    public static final int BROADCAST_PORT = 6000;
    private static SocketReceiveThread mReceiveThread;
    private static int mPort;
    @Nullable
    private static DatagramSocket mSocket;
    @NotNull
    private static ArrayList<IUDPMessageReceiver> mMessageReceivers;

    private UDPClient() {
    }

    public final void registerMessageReceiver(@NotNull IUDPMessageReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        mMessageReceivers.add(receiver);
    }

    public final void unregisterMessageReceiver(@NotNull IUDPMessageReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        mMessageReceivers.remove(receiver);
    }

    private final void onReceiveMessage(BasicInfo basicInfo) {
        for (IUDPMessageReceiver receiver : mMessageReceivers) {
            receiver.onMessageReceived(basicInfo);
        }
    }

    private final void onReceiveError(String errMsg) {
        for (IUDPMessageReceiver receiver : mMessageReceivers) {
            receiver.onErrorReceived(errMsg);
        }
    }

    public final void startReceive(int port) {
        mPort = port;
        try {
            Object object;
            if (mSocket != null && (object = mSocket) != null) {
                ((DatagramSocket)object).close();
            }
            if ((mSocket = new DatagramSocket(mPort)) == null) {
                mSocket = new DatagramSocket(null);
                object = mSocket;
                if (object != null) {
                    ((DatagramSocket)object).setReuseAddress(true);
                }
                object = mSocket;
                if (object != null) {
                    ((DatagramSocket)object).bind(new InetSocketAddress(mPort));
                }
            }
            if ((object = (mReceiveThread = new SocketReceiveThread())) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
                throw null;
            }
            ((Thread)object).start();
        }
        catch (Exception e) {
            this.onReceiveError(e.getMessage());
        }
    }

    public static /* synthetic */ void startReceive$default(UDPClient uDPClient, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 6000;
        }
        uDPClient.startReceive(n);
    }

    public final void stopReceive() {
        Object object = mReceiveThread;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
            throw null;
        }
        ((SocketReceiveThread)object).threadExit();
        try {
            object = mSocket;
            if (object != null) {
                ((DatagramSocket)object).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        mPort = 6000;
        mMessageReceivers = new ArrayList();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0003\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "Ljava/lang/Thread;", "()V", "threadExit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "run", "", "communication_release"})
    public static final class SocketReceiveThread
    extends Thread {
        @NotNull
        private AtomicBoolean threadExit = new AtomicBoolean(false);

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (!this.threadExit.get()) {
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                    DatagramSocket datagramSocket = mSocket;
                    if (datagramSocket != null) {
                        datagramSocket.receive(datagramPacket);
                    }
                    int n = 0;
                    int n2 = datagramPacket.getLength();
                    boolean bl = false;
                    String receiveData = new String(buffer, n, n2, Charsets.UTF_8);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"receiveData=", (Object)receiveData));
                    BasicInfo basicInfo = (BasicInfo)new Gson().fromJson(receiveData, BasicInfo.class);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"basicInfo=", (Object)basicInfo));
                    INSTANCE.onReceiveMessage(basicInfo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    INSTANCE.onReceiveError(e.getMessage());
                    this.threadExit();
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                    INSTANCE.onReceiveError(e.getMessage());
                    this.threadExit();
                }
            }
        }

        public final void threadExit() {
            this.threadExit.set(true);
        }
    }
}

