package com.transsion.iot.communication.encrypt

import android.util.Base64
import javax.crypto.Cipher
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec

/**
 * @Author fuhuang.fan
 * @Date 2022/7/28/028 11:38
 * @Description
 */
object AESUtils {

    /*
     * 加密用的Key 可以用26个字母和数字组成 使用AES-128-CBC加密模式，key需要为16位。
     */
    private const val key = "wXkSYiyvL19YBmra"
    private const val iv = "aaaaaaaaaaaaaaaa"

    /**
     * @author miracle.qu
     * @Description AES算法加密明文
     * @param data 明文
     * @param key 密钥，长度16
     * @param iv 偏移量，长度16
     * @return 密文
     */
    fun encryptAES(data: String): String? {
        return try {
            val cipher: Cipher = Cipher.getInstance("AES/CBC/PKCS5Padding")
            val blockSize: Int = cipher.blockSize
            val dataBytes = data.toByteArray()
            var plaintextLength = dataBytes.size
            if (plaintextLength % blockSize != 0) {
                plaintextLength += (blockSize - plaintextLength % blockSize)
            }
            val plaintext = ByteArray(plaintextLength)
            System.arraycopy(dataBytes, 0, plaintext, 0, dataBytes.size)
            val keySpec = SecretKeySpec(key.toByteArray(), "AES")
            val ivSpec = IvParameterSpec(iv.toByteArray()) // CBC模式，需要一个向量iv，可增加加密算法的强度
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivSpec)
            val encrypted: ByteArray = cipher.doFinal(plaintext)
            encode(encrypted).trim() // BASE64做转码。
        } catch (e: Exception) {
            e.printStackTrace()
            null
        }
    }

    /**
     * @author miracle.qu
     * @Description AES算法解密密文
     * @param data 密文
     * @return 明文
     */
    fun decryptAES(data: String?): String? {
        return try {
            val encrypted1 = decode(data) //先用base64解密
            val cipher: Cipher = Cipher.getInstance("AES/CBC/PKCS5Padding")
            val keySpec = SecretKeySpec(key.toByteArray(), "AES")
            val ivSpec = IvParameterSpec(iv.toByteArray())
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec)
            val original: ByteArray = cipher.doFinal(encrypted1)
            val originalString = String(original)
            originalString.trim { it <= ' ' }
        } catch (e: Exception) {
            e.printStackTrace()
            null
        }
    }

    /**
     * 编码
     * @param byteArray
     * @return
     */
    private fun encode(byteArray: ByteArray?): String {
        return String(Base64.encode(byteArray, Base64.DEFAULT))
    }

    /**
     * 解码
     * @param base64EncodedString
     * @return
     */
    private fun decode(base64EncodedString: String?): ByteArray {
        return Base64.decode(base64EncodedString, Base64.DEFAULT)
    }

}