/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.udp;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.transsion.iot.communication.packet.resp.BasicInfo;
import com.transsion.iot.communication.udp.IUDPMessageReceiver;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient;", "", "()V", "mMessageReceivers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/transsion/iot/communication/udp/IUDPMessageReceiver;", "mPort", "", "mReceiveThread", "Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "mSocket", "Ljava/net/DatagramSocket;", "onReceiveError", "", "errMsg", "", "onReceiveMessage", "basicInfo", "Lcom/transsion/iot/communication/packet/resp/BasicInfo;", "registerMessageReceiver", "receiver", "startReceive", "stopReceive", "unregisterMessageReceiver", "SocketReceiveThread", "communication_release"})
public final class UDPClient {
    @NotNull
    public static final UDPClient INSTANCE = new UDPClient();
    private static SocketReceiveThread mReceiveThread;
    private static int mPort;
    @Nullable
    private static DatagramSocket mSocket;
    @NotNull
    private static CopyOnWriteArrayList<IUDPMessageReceiver> mMessageReceivers;

    private UDPClient() {
    }

    public final void registerMessageReceiver(@NotNull IUDPMessageReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        mMessageReceivers.add(receiver);
    }

    public final void unregisterMessageReceiver(@NotNull IUDPMessageReceiver receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        mMessageReceivers.remove(receiver);
    }

    private final void onReceiveMessage(BasicInfo basicInfo) {
        for (IUDPMessageReceiver receiver : mMessageReceivers) {
            receiver.onMessageReceived(basicInfo);
        }
    }

    private final void onReceiveError(String errMsg) {
        for (IUDPMessageReceiver receiver : mMessageReceivers) {
            receiver.onErrorReceived(errMsg);
        }
    }

    public final void startReceive() {
        try {
            SocketReceiveThread socketReceiveThread = mReceiveThread = new SocketReceiveThread();
            if (socketReceiveThread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
                throw null;
            }
            socketReceiveThread.start();
        }
        catch (Exception e) {
            this.onReceiveError(e.getMessage());
        }
    }

    public final void stopReceive() {
        SocketReceiveThread socketReceiveThread = mReceiveThread;
        if (socketReceiveThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mReceiveThread");
            throw null;
        }
        socketReceiveThread.threadExit();
    }

    static {
        mPort = 6000;
        mMessageReceivers = new CopyOnWriteArrayList();
        try {
            mSocket = new DatagramSocket(mPort);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0003\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/transsion/iot/communication/udp/UDPClient$SocketReceiveThread;", "Ljava/lang/Thread;", "()V", "threadExit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "run", "", "communication_release"})
    public static final class SocketReceiveThread
    extends Thread {
        @NotNull
        private AtomicBoolean threadExit = new AtomicBoolean(false);

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (!this.threadExit.get()) {
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                    DatagramSocket datagramSocket = mSocket;
                    if (datagramSocket != null) {
                        datagramSocket.receive(datagramPacket);
                    }
                    int n = 0;
                    int n2 = datagramPacket.getLength();
                    boolean bl = false;
                    String receiveData = new String(buffer, n, n2, Charsets.UTF_8);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"receiveData=", (Object)receiveData));
                    BasicInfo basicInfo = (BasicInfo)new Gson().fromJson(receiveData, BasicInfo.class);
                    Log.d((String)"UDPClient", (String)Intrinsics.stringPlus((String)"basicInfo=", (Object)basicInfo));
                    INSTANCE.onReceiveMessage(basicInfo);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    INSTANCE.onReceiveError(e.getMessage());
                    this.threadExit();
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                    INSTANCE.onReceiveError(e.getMessage());
                    this.threadExit();
                }
            }
        }

        public final void threadExit() {
            this.threadExit.set(true);
        }
    }
}

