package com.transsion.iot.communication.http

import android.util.Log
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import okio.Buffer
import java.io.IOException
import java.nio.charset.Charset
import kotlin.jvm.Throws

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
class LoggingInterceptor : Interceptor {
    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val original = chain.request()
        Log.d(
            "LoggingInterceptor",
            String.format(
                "...开始请求\n请求方式:%s\n请求链接：%s\n请求头：%s\n请求参数：%s\n",
                original.method(),
                original.url(),
                getRequestHeaders(original),
                getRequestInfo(original)
            )
        )

        val response = chain.proceed(original)
        Log.i(
            "LoggingInterceptor",
            String.format(
                "...请求完成\n请求方式:%s\n请求链接：%s\n请求头：%s\n请求参数：%s\n请求响应%s",
                original.method(),
                original.url(),
                getRequestHeaders(original),
                getRequestInfo(original),
                getResponseInfo(response)
            )
        )
        return response
    }

    /**
     * 打印请求头
     *
     * @param request 请求的对象
     */
    private fun getRequestHeaders(request: Request?): String {
        val str = ""
        if (request == null) {
            return str
        }
        val headers = request.headers() ?: return str
        return headers.toString()
    }

    /**
     * 打印请求消息
     *
     * @param request 请求的对象
     */
    private fun getRequestInfo(request: Request?): String {
        var str = ""
        if (request == null) {
            return str
        }
        val requestBody = request.body() ?: return str
        try {
            val bufferedSink = Buffer()
            requestBody.writeTo(bufferedSink)
            val charset = Charset.forName("utf-8")
            str = bufferedSink.readString(charset)
        } catch (e: IOException) {
            e.printStackTrace()
        }
        return str
    }

    /**
     * 打印返回消息
     *
     * @param response 返回的对象
     */
    private fun getResponseInfo(response: Response?): String {
        var str = ""
        if (response == null || !response.isSuccessful) {
            return str
        }
        val responseBody = response.body()
        val contentLength = responseBody!!.contentLength()
        val source = responseBody.source()
        try {
            source.request(Long.MAX_VALUE) // Buffer the entire body.
        } catch (e: IOException) {
            e.printStackTrace()
        }
        val buffer = source.buffer()
        val charset = Charset.forName("utf-8")
        if (contentLength != 0L) {
            str = buffer.clone().readString(charset)
        }
        return str
    }
}