package com.transsion.iot.communication.http

import android.util.Base64
import java.io.ByteArrayOutputStream
import java.security.KeyFactory
import java.security.PublicKey
import java.security.spec.X509EncodedKeySpec
import javax.crypto.Cipher

object RSAUtils {

    /**
     * 根据公钥的 Base64 文本创建公钥对象
     */
    private fun getPublicKey(): PublicKey {
        val encPubKey = Base64.decode(AppConstance.PUCLIC_KEY, Base64.DEFAULT)
        val encPubKeySpec =
            X509EncodedKeySpec(encPubKey)
        return KeyFactory.getInstance("RSA").generatePublic(encPubKeySpec)
    }


    /**
     * 公钥加密
     * */
    fun encryptByPubKey(data: String): String? {
        return Base64.encodeToString(encryptByPubKey(getPublicKey(), data.toByteArray()),Base64.DEFAULT)
    }

    private fun encryptByPubKey(publicKey: PublicKey, data: ByteArray): ByteArray {
        val cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding")
        cipher.init(1, publicKey)
        val inputLen = data.size
        val out = ByteArrayOutputStream()
        var offSet = 0
        var i = 0
        while (inputLen - offSet > 0) {
            val cache: ByteArray = if (inputLen - offSet > 117) {
                cipher.doFinal(data, offSet, 117)
            } else {
                cipher.doFinal(data, offSet, inputLen - offSet)
            }
            out.write(cache, 0, cache.size)
            ++i
            offSet = i * 117
        }
        val encryptedData = out.toByteArray()
        out.close()
        return encryptedData
    }



    private fun decryptByPubKey(
        publicKey: PublicKey,
        encryptedData: ByteArray
    ): ByteArray {
        val cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding")
        cipher.init(2, publicKey)
        val inputLen = encryptedData.size
        val out = ByteArrayOutputStream()
        var offSet = 0
        var i = 0
        while (inputLen - offSet > 0) {
            val cache: ByteArray = if (inputLen - offSet > 128) {
                cipher.doFinal(encryptedData, offSet, 128)
            } else {
                cipher.doFinal(encryptedData, offSet, inputLen - offSet)
            }
            out.write(cache, 0, cache.size)
            ++i
            offSet = i * 128
        }
        val decryptedData = out.toByteArray()
        out.close()
        return decryptedData
    }


    /**
     * 公钥解密
     */
    fun mutiDecryptByPubKey(message: String?): String? {
        if (message.isNullOrEmpty()) {
            return null
        }
        return String(decryptByPubKey(getPublicKey(), Base64.decode(message, Base64.DEFAULT)))
    }
}