package com.transsion.iot.communication.http.repository

import android.content.Context
import android.util.Log
import com.google.gson.Gson
import com.transsion.iot.communication.http.HttpRequest
import com.transsion.iot.communication.http.IRetrofitClientSpi
import com.transsion.iot.communication.http.api.DeviceControlService
import com.transsion.iot.communication.http.bean.BaseInfo
import com.transsion.iot.communication.http.getRequestBody
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock
import java.util.*

object DeviceControlRepository {

    const val TAG = "DeviceControlRepository"
    private var mClient: DeviceControlService? = null
    private val mMutex = Mutex()
    private val mScope = GlobalScope


    private suspend fun getDeviceControlService(context: Context, token: String): DeviceControlService {
        mMutex.lock()
        if (mClient == null) {
            val retrofit = ServiceLoader.load(IRetrofitClientSpi::class.java).first().getRetrofit(context, token)
            Log.d(TAG, "getDeviceControlService retrofit=${retrofit}")
            Log.d(TAG, "getDeviceControlService baseUrl=${retrofit.baseUrl()}")
            mClient = retrofit.create(DeviceControlService::class.java)
        }
        mMutex.unlock()
        Log.d(TAG, "getDeviceControlService client=$mClient")
        return mClient!!
    }


    suspend fun getBaseInfo(context: Context, token: String,pid: String, psn: String, result:(result:BaseInfo?)->Unit) {
        Log.d(TAG, "token=$token,pid=$pid, psn=$psn")
        HttpRequest({
            val map = TreeMap<String, Any?>()
            map["id"] = System.currentTimeMillis().toString()
            map["version"] = "1.0"
            map["params"] = arrayOf("baseInf")
            map["method"] = "app.property.get"
            Log.d(TAG, "token=$token,pid=$pid, psn=$psn, body=${map.getRequestBody()}")
            val result = getDeviceControlService(context, token).getBaseInfo(pid, psn, map.getRequestBody())
            Log.d(TAG, "result:${result}")
            result
        },{
            Log.d(TAG, "baseInfo:${it?.baseInf}")
            it?.let {
                result.invoke(it.baseInf)
            }
            if (it == null) {
                result.invoke(null)
            }
        },{
            Log.e(TAG, "error:${it.errMsg}, ${it.code}")
            result.invoke(null)
        })
    }


}