/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.packet;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00028\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00028\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u001c\u0010\u0015\u001a\u00020\u00028\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0017\u001a\u00020\u00078\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u00020\u00028\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/transsion/iot/communication/packet/TCPPacket;", "", "", "num", "", "intToByteArray2", "(I)[B", "", "data", "getPacket", "(Ljava/lang/String;)[B", "byteArray", "count", "getData", "([BI)Ljava/lang/String;", "PACKET_HEADER_H", "I", "getPACKET_HEADER_H", "()I", "PACKET_HEADER_L", "getPACKET_HEADER_L", "PACKET_FOOTER_L", "getPACKET_FOOTER_L", "TAG", "Ljava/lang/String;", "getTAG", "()Ljava/lang/String;", "PACKET_FOOTER_H", "getPACKET_FOOTER_H", "<init>", "()V", "communication_release"})
public final class TCPPacket {
    @NotNull
    public static final TCPPacket INSTANCE = new TCPPacket();
    @NotNull
    private static final String TAG = "TCPPacket";
    private static final int PACKET_HEADER_H = 192;
    private static final int PACKET_HEADER_L;
    private static final int PACKET_FOOTER_H;
    private static final int PACKET_FOOTER_L;

    private TCPPacket() {
    }

    private final byte[] intToByteArray2(int n) {
        byte[] byArray = new byte[2];
        int n2 = n;
        byte by = (byte)(n2 >> 8 & 0xFF);
        n = (byte)(n2 & 0xFF);
        byArray[0] = by;
        byArray[1] = n;
        return byArray;
    }

    static {
        PACKET_FOOTER_H = 12;
    }

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    public final int getPACKET_HEADER_H() {
        return PACKET_HEADER_H;
    }

    public final int getPACKET_HEADER_L() {
        return PACKET_HEADER_L;
    }

    public final int getPACKET_FOOTER_H() {
        return PACKET_FOOTER_H;
    }

    public final int getPACKET_FOOTER_L() {
        return PACKET_FOOTER_L;
    }

    @NotNull
    public final byte[] getPacket(@NotNull String object) {
        byte[] byArray;
        String string = object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"data");
        if (string.length() == 0) {
            return new byte[0];
        }
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        object = byArray2;
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        int n = byArray2.length;
        byte[] byArray3 = new byte[n + 8];
        byte[] byArray4 = byArray = byArray3;
        byte[] byArray5 = byArray;
        byArray4[0] = (byte)PACKET_HEADER_H;
        byArray5[1] = (byte)PACKET_HEADER_L;
        byArray4[2] = 0;
        byArray5[3] = 0;
        System.arraycopy(this.intToByteArray2(n), 0, byArray, 4, 2);
        System.arraycopy(object, 0, byArray, 6, n);
        byArray[n + 6] = (byte)PACKET_FOOTER_H;
        byArray3[n + 7] = (byte)PACKET_FOOTER_L;
        return byArray3;
    }

    @NotNull
    public final String getData(@NotNull byte[] object, int n) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"byteArray");
        if (n > 8 && !(((byte[])object).length == 0) && ((byte[])object).length >= 8) {
            if (object[0] == (byte)PACKET_HEADER_H && object[1] == (byte)PACKET_HEADER_L) {
                if (object[n - 1] == (byte)PACKET_FOOTER_L && object[n - 2] == (byte)PACKET_FOOTER_H) {
                    int n2 = ByteBuffer.wrap(object, 4, 2).getInt();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("receive length=");
                    stringBuilder.append(n2);
                    Log.d((String)TAG, (String)stringBuilder.toString());
                    byte[] byArray = object;
                    object = Charsets.UTF_8;
                    return new String(byArray, 6, n2, (Charset)object);
                }
                Log.d((String)TAG, (String)"receive footer is invalid");
                return "";
            }
            Log.d((String)TAG, (String)"receive header is invalid");
            return "";
        }
        return "";
    }
}

