package com.transsion.iot.communication.http

import com.smartlife.nebula.librarybase.net.ResponseThrowable
import kotlinx.coroutines.CancellationException
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.coroutineScope

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
object ExceptionHandle {

    /**
     * 异常统一处理
     */
    suspend fun handleException(
        block: suspend CoroutineScope.() -> Unit,
        error: suspend CoroutineScope.(ResponseThrowable) -> Unit,
        complete: suspend CoroutineScope.() -> Unit
    ) {
        coroutineScope {
            try {
                block()
            } catch (eThrowable: Throwable) {
                //处理非取消异常
                if (eThrowable !is CancellationException) {
                    error(ResponseThrowable(ErrorCode.REQUEST_ERROR, eThrowable))
                }
            } finally {
                complete()
            }
        }
    }
}