package com.transsion.iot.communication.http

import android.content.Context
import android.util.Log
import okhttp3.ConnectionPool
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.Semaphore
import java.util.concurrent.TimeUnit

object RetrofitFactory {
    private val TAG = "RetrofitFactory"
    private val mRetrofitMap: HashMap<String, Retrofit> = HashMap()
    private val mSemaphore: Semaphore = Semaphore(1)
    private var mHost = "https://test-api.nebulalive.com"
    private val mPath = "/welife/appliance/"


    /**
     * @param host test-api.nebulalive.com
     * @return
     */
     suspend fun getRetrofit(context: Context, token: String, host: String?, path: String?): Retrofit {
        mSemaphore.acquire()
        val realHost = host?: mHost
        val realPath = path?: mPath
        Log.d(TAG,"getRetrofit lock")
        if (!mRetrofitMap.containsKey(realHost)) {
            val url = GSLBUtil.getUrl(context, realHost)
            val baseUrl = "${url}${realPath}"
            Log.d(TAG,"baseUrl:$baseUrl")
            val retrofit = Retrofit.Builder()
                .client(getOkHttpClient(context, token))
                .addConverterFactory(GsonConverterFactory.create())

                .baseUrl(baseUrl)
                .build()
            mRetrofitMap[realHost] = retrofit
        }
        Log.d(TAG,"getRetrofit unlock")
        mSemaphore.release()
        return mRetrofitMap[realHost]!!
    }


    private fun getOkHttpClient(context: Context, token: String): OkHttpClient {
        return OkHttpClient.Builder()
            .connectTimeout(20L, TimeUnit.SECONDS)
            .callTimeout(20L, TimeUnit.SECONDS)
            .readTimeout(20L, TimeUnit.SECONDS)
            .writeTimeout(20L, TimeUnit.SECONDS)
            .addInterceptor(HeadInterceptor(context, token))
            .addInterceptor(LoggingInterceptor())
            .connectionPool(ConnectionPool(8, 15, TimeUnit.SECONDS))
            .build()
    }


}