/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * Welife
 * @author OS : fuhuang.fan (18650792)
 * @version 1.0
 */

package com.transsion.iot.communication.http.api

import com.transsion.iot.communication.http.bean.BaseInfoData
import com.transsion.iot.communication.http.bean.BaseResult
import com.transsion.iot.communication.http.bean.WifiInfoData
import com.transsion.iot.communication.packet.req.MeshSearchState
import com.transsion.iot.communication.packet.resp.NetworkSpeedInfo
import com.transsion.iot.communication.packet.resp.OnlineDeviceCount
import com.transsion.iot.communication.packet.resp.SearchedMeshNodes
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.http.Body
import retrofit2.http.POST
import retrofit2.http.Path

/**
 * @Author fuhuang.fan
 * @Date 2022/3/30/030 19:41
 * @Description
 */
interface DeviceControlService {

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getBaseInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<BaseInfoData>

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getWifiInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<WifiInfoData>

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getMeshInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): ResponseBody?

    @POST("weLink/app/properties/{pid}/{psn}")
    suspend fun getClientInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): ResponseBody?

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun serviceSet(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody): BaseResult<Any>

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun getSearchedMeshNodes(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody) : BaseResult<SearchedMeshNodes>

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun getWifiMeshMode(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody) : BaseResult<MeshSearchState>

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun getCurDeviceNetworkSpeedInfo(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody) : BaseResult<NetworkSpeedInfo>

    @POST("weLink/app/service/{pid}/{psn}/down")
    suspend fun getOnlineDeviceCount(@Path("pid") pid: String, @Path("psn") psn: String, @Body requestBody: RequestBody) : BaseResult<OnlineDeviceCount>
}