package com.transsion.iot.communication.packet

import android.util.Log
import java.nio.ByteBuffer

/**
 * @Author fuhuang.fan
 * @Date 2022/7/21/021 16:26
 * @Description
 */
object TCPPacket {

    val TAG = "TCPPacket"
    val PACKET_HEADER_H = 0xC0
    val PACKET_HEADER_L = 0x00
    val PACKET_FOOTER_H = 0x0C
    val PACKET_FOOTER_L = 0x00

    fun getPacket(data: String): ByteArray {
        if (data.isEmpty()) {
            return ByteArray(0)
        }
        val tempArray = data.toByteArray()
        val length = tempArray.size
        val byteArray = ByteArray(length + 8)
        byteArray[0] = PACKET_HEADER_H.toByte()
        byteArray[1] = PACKET_HEADER_L.toByte()
        byteArray[2] = 0 //预留
        byteArray[3] = 0 //预留
        System.arraycopy(intToByteArray2(length), 0, byteArray, 4, 2)
        System.arraycopy(tempArray, 0, byteArray, 6, length)
        byteArray[length+6] = PACKET_FOOTER_H.toByte()
        byteArray[length+7] = PACKET_FOOTER_L.toByte()
        return byteArray
    }

    fun getData(byteArray: ByteArray, count: Int): String {
        if (count <= 8 || byteArray.isEmpty() || byteArray.size < 8) {
            return ""
        }
        if (byteArray[0] != PACKET_HEADER_H.toByte() || byteArray[1] != PACKET_HEADER_L.toByte()) {
            Log.d(TAG, "receive header is invalid")
            return ""
        }
        if (byteArray[count-1] != PACKET_FOOTER_L.toByte() || byteArray[count-2] != PACKET_FOOTER_H.toByte()) {
            Log.d(TAG, "receive footer is invalid")
            return ""
        }
        val dataLength = ByteBuffer.wrap(byteArray, 4,2).int
        Log.d(TAG, "receive length=$dataLength")
        return String(byteArray, 6, dataLength)
    }

    private fun intToByteArray2(num: Int): ByteArray{
        val byteArray = ByteArray(2)
        val lowH = ((num shr 8) and 0xff).toByte()
        val lowL = (num and 0xff).toByte()
        byteArray[0] = lowH
        byteArray[1] = lowL
        return byteArray
    }

}