/*
 * Transsion Top Secret
 * Copyright (C) 2021 Transsion Inc.
 * WeLife
 *  @author OS : naidan.xu (18646478)
 *  @version 1.0
 */

package com.transsion.iot.communication.http

import android.content.Context
import android.text.TextUtils
import android.util.Log
import com.transsion.core.deviceinfo.DeviceInfo
import com.transsion.gslb.GslbSdk
import kotlinx.coroutines.*

/**
 * Created on 2021/6/24.
 * @desc:TODO
 */
object GSLBUtil {
    const val TAG = "GSLBUtil"
    private const val OVERTIME = 5000L
    suspend fun getUrl(context: Context, defaultDomain: String): String {
        var job: Job? = null
        var domain = defaultDomain
        job = CoroutineScope(Dispatchers.IO).launch {
            GslbSdk.init(context, arrayOf(defaultDomain), object : GslbSdk.InitListener {
                override fun onInitSuccess(p0: MutableMap<String, String>?) {
                    Log.i(TAG, "onInitSuccess map:$p0")
                    domain = GslbSdk.getDomain(defaultDomain, true)
                    Log.i(TAG, "domain:$domain")
                    job?.cancel()
                }

                override fun onInitFail() {
                    Log.w(TAG, "onInitFail")
                    job?.cancel()

                }
            })
            delay(OVERTIME)
            Log.i(TAG,"getUrl time out")
        }
        job.join()
        if (TextUtils.isEmpty(domain)) {
            val gaid = DeviceInfo.getGAId()
            if (TextUtils.isEmpty(gaid)) {
                Log.i(TAG, "gaid is empty,so use default domain:$defaultDomain")
                domain = defaultDomain
            }
        }
        Log.i(TAG,"getUrl domain :$domain")
        return domain
    }


}