package com.transsion.iot.communication.http

import com.google.gson.Gson
import okhttp3.MediaType
import okhttp3.RequestBody
import java.util.*

/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
fun String.formatUrl(): String {
    return this.trim().replace("\n", "").replace("\r", "")
}

/**
 * 调用此方法将参数格式化
 * */
fun TreeMap<String, String?>.formatParams(): String? {
    this["sig"] = EncryptUtils.sign(this)
    val map2Json = Gson().toJson(this)
    val formatUrl = RSAUtils.encryptByPubKey(map2Json)?.formatUrl()
    return formatUrl
}


fun TreeMap<String, String?>.getRequestBody(encrypt:Boolean = true): RequestBody {
    var finalData = ""
    if (encrypt){
        val formatParams = this.formatParams()
        val finalMap = TreeMap<String, String?>()
        finalMap["content"] = formatParams
        finalData = Gson().toJson(finalMap)
    }else{
        finalData = Gson().toJson(this)
    }

    return RequestBody.create(MediaType.parse("application/json;charset=UTF-8"), finalData ?: "")
}

fun TreeMap<String, Any?>.getRequestBody(): RequestBody {
    val finalData = Gson().toJson(this)
    return RequestBody.create(MediaType.parse("application/json;charset=UTF-8"), finalData ?: "")
}
