/*
 * Transsion Top Secret
 * Copyright (C) 2020 Transsion Inc.
 * WeLife
 * @author OS : wenbin.zhou (18647502)
 * @version 1.0
 */
package com.transsion.iot.communication.http

import android.content.Context
import com.google.auto.service.AutoService
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch
import retrofit2.Retrofit

@AutoService(IRetrofitClientSpi::class)
class RetrofitClient : IRetrofitClientSpi{
    private val TAG = "RetrofitClient"

    override fun initRetrofit(context: Context, token: String) {
        GlobalScope.launch {
            getRetrofit(context, token)
        }
    }

    override suspend fun getRetrofit(context: Context, token: String): Retrofit {
        return getRetrofit(context, token, null, null)
    }

    override suspend fun getRetrofit(
        context: Context,
        token: String,
        host: String?,
        path: String?
    ): Retrofit {
        return RetrofitFactory.getRetrofit(context, token, host, path)
    }
}