/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iot.communication.tcp;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.transsion.iot.communication.ConnectListener;
import com.transsion.iot.communication.encrypt.AESUtils;
import com.transsion.iot.communication.packet.ResponseData;
import com.transsion.iot.communication.packet.resp.BaseResult;
import com.transsion.iot.communication.tcp.TCPClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009f\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\\\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002efB\t\b\u0002\u00a2\u0006\u0004\bd\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u000f\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000fJ\u000f\u0010\u0016\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0004J\u000f\u0010\u0017\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0004J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u000bJ\u0015\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b \u0010\u001fJ\r\u0010!\u001a\u00020\b\u00a2\u0006\u0004\b!\u0010\"J\r\u0010$\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0002\u00a2\u0006\u0004\b&\u0010\u0004J\r\u0010'\u001a\u00020\u0002\u00a2\u0006\u0004\b'\u0010\u0004J\u001f\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\f\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\u0002\u00a2\u0006\u0004\b,\u0010\u0004J\r\u0010-\u001a\u00020\u0002\u00a2\u0006\u0004\b-\u0010\u0004J\r\u0010.\u001a\u00020\u0002\u00a2\u0006\u0004\b.\u0010\u0004J\u0015\u0010/\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\f\u00a2\u0006\u0004\b/\u0010\u000fJ\u0015\u00100\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\f\u00a2\u0006\u0004\b0\u0010\u000fR\u0016\u00101\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001e\u00104\u001a\n 3*\u0004\u0018\u00010\f0\f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R2\u00109\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020706j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u000207`88\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0018\u0010<\u001a\u0004\u0018\u00010;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010?\u001a\u00020>8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0018\u0010B\u001a\u0004\u0018\u00010A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u00102R\"\u0010F\u001a\u00020E8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0018\u0010M\u001a\u0004\u0018\u00010L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001c0O8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0018\u0010S\u001a\u0004\u0018\u00010R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010U\u001a\u00020\b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bU\u00102R\u0018\u0010W\u001a\u0004\u0018\u00010V8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010XR>\u0010Z\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0Y06j\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0Y`88\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010:R\u0016\u0010\u0018\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u00105R\u0016\u0010[\u001a\u00020>8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b[\u0010@R\u0016\u0010]\u001a\u00020\\8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0016\u0010\u001a\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u00102R\u0018\u0010`\u001a\u0004\u0018\u00010_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0018\u0010b\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010c\u00a8\u0006g"}, d2={"Lcom/transsion/iot/communication/tcp/TCPClient;", "", "", "initConnectThread", "()V", "initSendThread", "initReceiveThread", "initSendHandler", "", "state", "onConnectStateChanged", "(I)V", "", "errMsg", "onError", "(Ljava/lang/String;)V", "", "data", "writeToOutputStream", "([B)V", "receiveData", "parseToRespData", "clearChannelMap", "clearJobMap", "ip", "setIP", "port", "setPort", "Lcom/transsion/iot/communication/ConnectListener;", "connectListener", "addConnectListener", "(Lcom/transsion/iot/communication/ConnectListener;)V", "removeConnectListener", "getConnectState", "()I", "", "isConnected", "()Z", "connect", "reConnect", "serviceId", "message", "send", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "sendHeartBeat", "disconnect", "onDestroy", "consumeChannel", "consumeJob", "reconnectCount", "I", "kotlin.jvm.PlatformType", "TAG", "Ljava/lang/String;", "Ljava/util/HashMap;", "Lkotlinx/coroutines/Job;", "Lkotlin/collections/HashMap;", "mJobMap", "Ljava/util/HashMap;", "Ljava/io/OutputStream;", "mOutStream", "Ljava/io/OutputStream;", "", "HEART_BEAT_INTERVAL", "J", "Lcom/transsion/iot/communication/tcp/TCPClient$SocketReceiveThread;", "mReceiveThread", "Lcom/transsion/iot/communication/tcp/TCPClient$SocketReceiveThread;", "mConnectState", "Ljava/net/Socket;", "mSocket", "Ljava/net/Socket;", "getMSocket", "()Ljava/net/Socket;", "setMSocket", "(Ljava/net/Socket;)V", "Landroid/os/Handler;", "mHeartBeatHandler", "Landroid/os/Handler;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "mConnectListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/io/InputStream;", "mInStream", "Ljava/io/InputStream;", "MAX_RECONNECT_COUNT", "Landroid/os/HandlerThread;", "mHeartBeatThread", "Landroid/os/HandlerThread;", "Lkotlinx/coroutines/channels/Channel;", "mChannelMap", "REQUEST_TIME_OUT", "com/transsion/iot/communication/tcp/TCPClient$mHeartBeatRunnable$1", "mHeartBeatRunnable", "Lcom/transsion/iot/communication/tcp/TCPClient$mHeartBeatRunnable$1;", "Lcom/transsion/iot/communication/tcp/TCPClient$SocketConnectThread;", "mConnectThread", "Lcom/transsion/iot/communication/tcp/TCPClient$SocketConnectThread;", "mHeartBeatJob", "Lkotlinx/coroutines/Job;", "<init>", "SocketConnectThread", "SocketReceiveThread", "communication_release"})
public final class TCPClient {
    @NotNull
    public static final TCPClient INSTANCE = new TCPClient();
    private static final String TAG = TCPClient.class.getSimpleName();
    @NotNull
    private static String ip = "192.168.188.1";
    private static int port = 8889;
    public static final long HEART_BEAT_INTERVAL = 30000L;
    private static final long REQUEST_TIME_OUT = 10000L;
    private static final int MAX_RECONNECT_COUNT = 3;
    private static int reconnectCount;
    public static Socket mSocket;
    @Nullable
    private static OutputStream mOutStream;
    @Nullable
    private static InputStream mInStream;
    @Nullable
    private static SocketConnectThread mConnectThread;
    @Nullable
    private static SocketReceiveThread mReceiveThread;
    @Nullable
    private static HandlerThread mHeartBeatThread;
    @Nullable
    private static Handler mHeartBeatHandler;
    @NotNull
    private static HashMap<String, Channel<String>> mChannelMap;
    @NotNull
    private static HashMap<String, Job> mJobMap;
    private static int mConnectState;
    @NotNull
    private static CopyOnWriteArrayList<ConnectListener> mConnectListeners;
    @Nullable
    private static Job mHeartBeatJob;
    @NotNull
    private static mHeartBeatRunnable.1 mHeartBeatRunnable;

    private TCPClient() {
    }

    private final void initConnectThread() {
        SocketConnectThread socketConnectThread;
        SocketConnectThread socketConnectThread2 = socketConnectThread;
        mConnectThread = new SocketConnectThread();
        if (socketConnectThread2 != null) {
            socketConnectThread2.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void initSendThread() {
        HandlerThread handlerThread;
        TCPClient tCPClient = mHeartBeatThread;
        if (tCPClient != null) {
            if (tCPClient == null) {
                return;
            }
            if (!tCPClient.isAlive()) return;
            boolean bl = true;
            if (!bl) return;
        }
        tCPClient = handlerThread;
        mHeartBeatThread = new HandlerThread("heart-beat");
        if (tCPClient == null) return;
        tCPClient.start();
    }

    private final void initReceiveThread() {
        SocketReceiveThread socketReceiveThread;
        SocketReceiveThread socketReceiveThread2 = socketReceiveThread;
        mReceiveThread = new SocketReceiveThread();
        if (socketReceiveThread2 != null) {
            socketReceiveThread2.start();
        }
    }

    private final void initSendHandler() {
        TCPClient tCPClient = mHeartBeatThread;
        if (tCPClient != null) {
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>((HandlerThread)tCPClient, null){
                public int label;
                public final /* synthetic */ HandlerThread $it;
                {
                    this.$it = handlerThread;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this_.label;
                    if (n != 0 && n != 1) {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    ResultKt.throwOnFailure((Object)object);
                    do {
                        if (this_.$it.isAlive() && this_.$it.getLooper() != null) {
                            TCPClient.access$setMHeartBeatHandler$p(new Handler(this_.$it.getLooper()));
                            initSendHandler.1.1 this_ = TCPClient.access$getMHeartBeatHandler$p();
                            if (this_ != null) {
                                Boxing.boxBoolean((boolean)this_.post(TCPClient.access$getMHeartBeatRunnable$p()));
                            }
                            return Unit.INSTANCE;
                        }
                        this_.label = 1;
                    } while (DelayKt.delay((long)100L, (Continuation)this_) != object2);
                    return object2;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                    return new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            };
            BuildersKt.launch$default((CoroutineScope)GlobalScope.INSTANCE, null, null, (Function2)function22, (int)3, null);
        }
    }

    private final void onConnectStateChanged(int n) {
        Iterator<ConnectListener> iterator = mConnectListeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectListener)iterator.next()).onConnectStateChanged(n);
        }
    }

    private final void onError(String string) {
        Iterator<ConnectListener> iterator = mConnectListeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectListener)iterator.next()).onError(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeToOutputStream(byte[] object) {
        String string;
        if (((Object)object).length == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        Object object2 = string;
        string = new String((byte[])object, Charsets.UTF_8);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("writeToOutputStream data=");
        stringBuilder.append((String)object2);
        Log.d((String)TAG, (String)stringBuilder.toString());
        try {
            object2 = mOutStream;
            if (object2 != null) {
                ((OutputStream)object2).write((byte[])object);
            }
            object = mOutStream;
            if (object == null) {
                return;
            }
            ((OutputStream)object).flush();
            return;
        }
        catch (Exception exception) {
            TCPClient tCPClient = string2;
            Exception exception2 = exception;
            exception2.printStackTrace();
            String string2 = exception2.getMessage();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("send failed:");
            stringBuilder2.append(string2);
            tCPClient.onError(stringBuilder2.toString());
        }
    }

    private final void parseToRespData(String string) {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Ref.ObjectRef objectRef;
        Object object;
        if (Intrinsics.areEqual((Object)string, (Object)"pong")) {
            object = mHeartBeatJob;
            if (object != null) {
                Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
            }
            return;
        }
        object = AESUtils.INSTANCE.decryptAES(string);
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("parseToRespData responseStr=");
        stringBuilder.append((String)object);
        Log.d((String)TAG, (String)stringBuilder.toString());
        string = objectRef;
        new Ref.ObjectRef().element = "getDeviceBasicInfo";
        try {
            String string2 = new JSONObject((String)object).optString("serviceId");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"obj.optString(\"serviceId\")");
            new Ref.ObjectRef().element = string2;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        String string3 = TAG;
        Set<String> set = ((Ref.ObjectRef)string).element;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("parseToRespData serviceId=");
        stringBuilder2.append(set);
        Log.d((String)string3, (String)stringBuilder2.toString());
        set = mChannelMap.keySet();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("parseToRespData mChannelMap=");
        stringBuilder3.append(set);
        Log.d((String)string3, (String)stringBuilder3.toString());
        set = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)string, (String)object, null){
            public int label;
            public final /* synthetic */ Ref.ObjectRef<String> $serviceId;
            public final /* synthetic */ String $responseStr;
            {
                this.$serviceId = objectRef;
                this.$responseStr = string;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this_.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    object = (Channel)TCPClient.access$getMChannelMap$p().get(this_.$serviceId.element);
                    if (object != null) {
                        Object object3 = object;
                        object = this_.$responseStr;
                        this_.label = 1;
                        if (object3.send(object, (Continuation)this_) == object2) {
                            return object2;
                        }
                    }
                }
                TCPClient tCPClient = TCPClient.INSTANCE;
                tCPClient.consumeChannel((String)this_.$serviceId.element);
                tCPClient.consumeJob((String)this_.$serviceId.element);
                parseToRespData.1 this_ = TCPClient.access$getMHeartBeatHandler$p();
                if (this_ != null) {
                    this_.removeCallbacks(TCPClient.access$getMHeartBeatRunnable$p());
                }
                this_ = TCPClient.access$getMHeartBeatJob$p();
                if (this_ != null) {
                    Job.DefaultImpls.cancel$default((Job)this_, null, (int)1, null);
                }
                this_ = TCPClient.access$getMHeartBeatHandler$p();
                if (this_ == null) return Unit.INSTANCE;
                Boxing.boxBoolean((boolean)this_.postDelayed(TCPClient.access$getMHeartBeatRunnable$p(), 30000L));
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                var objectRef = objectRef2;
                Ref.ObjectRef<String> objectRef2 = objectRef.$serviceId;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)GlobalScope.INSTANCE, null, null, set, (int)3, null);
    }

    private final void clearChannelMap() {
        if (mChannelMap.isEmpty() ^ true) {
            mChannelMap.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void clearJobMap() {
        if (mJobMap.isEmpty() ^ true) {
            for (String string : mJobMap.keySet()) {
                Job job2 = mJobMap.get(string);
                if (!(job2 != null && !job2.isCompleted()) || (string = mJobMap.get(string)) == null) continue;
                Job.DefaultImpls.cancel$default((Job)string, null, (int)1, null);
            }
            mJobMap.clear();
        }
    }

    public static final /* synthetic */ HashMap access$getMChannelMap$p() {
        return mChannelMap;
    }

    public static final /* synthetic */ HashMap access$getMJobMap$p() {
        return mJobMap;
    }

    public static final /* synthetic */ void access$writeToOutputStream(TCPClient tCPClient, byte[] byArray) {
        tCPClient.writeToOutputStream(byArray);
    }

    public static final /* synthetic */ Handler access$getMHeartBeatHandler$p() {
        return mHeartBeatHandler;
    }

    public static final /* synthetic */ mHeartBeatRunnable.1 access$getMHeartBeatRunnable$p() {
        return mHeartBeatRunnable;
    }

    public static final /* synthetic */ Job access$getMHeartBeatJob$p() {
        return mHeartBeatJob;
    }

    public static final /* synthetic */ InputStream access$getMInStream$p() {
        return mInStream;
    }

    public static final /* synthetic */ void access$parseToRespData(TCPClient tCPClient, String string) {
        tCPClient.parseToRespData(string);
    }

    public static final /* synthetic */ void access$setMHeartBeatHandler$p(Handler handler) {
        mHeartBeatHandler = handler;
    }

    static {
        mChannelMap = new HashMap();
        mJobMap = new HashMap();
        mConnectState = 3;
        mConnectListeners = new CopyOnWriteArrayList();
        mHeartBeatRunnable = new Runnable(){

            public void run() {
                TCPClient.INSTANCE.sendHeartBeat();
                Handler handler = TCPClient.access$getMHeartBeatHandler$p();
                if (handler != null) {
                    handler.postDelayed((Runnable)this, 30000L);
                }
            }
        };
    }

    @NotNull
    public final Socket getMSocket() {
        Socket socket = mSocket;
        if (socket != null) {
            return socket;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mSocket");
        throw null;
    }

    public final void setMSocket(@NotNull Socket socket) {
        Socket socket2 = socket;
        Intrinsics.checkNotNullParameter((Object)socket2, (String)"<set-?>");
        mSocket = socket2;
    }

    public final void setIP(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"ip");
        ip = string2;
    }

    public final void setPort(int n) {
        port = n;
    }

    public final void addConnectListener(@NotNull ConnectListener connectListener) {
        Intrinsics.checkNotNullParameter((Object)connectListener, (String)"connectListener");
        if (!mConnectListeners.contains(connectListener)) {
            mConnectListeners.add(connectListener);
        }
    }

    public final void removeConnectListener(@NotNull ConnectListener connectListener) {
        Intrinsics.checkNotNullParameter((Object)connectListener, (String)"connectListener");
        if (mConnectListeners.contains(connectListener)) {
            mConnectListeners.remove(connectListener);
        }
    }

    public final int getConnectState() {
        return mConnectState;
    }

    public final boolean isConnected() {
        return mConnectState == 2;
    }

    public final void connect() {
        Log.i((String)TAG, (String)"startConnect");
        if (!(ip.length() == 0) && port > 0) {
            TCPClient tCPClient = this;
            tCPClient.initConnectThread();
            tCPClient.initSendThread();
            mConnectState = 1;
            tCPClient.onConnectStateChanged(1);
            return;
        }
        this.onError("ip or port is invalid");
    }

    public final void reConnect() {
        String string = TAG;
        Log.i((String)string, (String)"start reConnect");
        int n = reconnectCount;
        if (n >= 3) {
            Log.i((String)string, (String)"reconnect  failed  3 times");
            return;
        }
        TCPClient tCPClient = this;
        reconnectCount = n + 1;
        tCPClient.disconnect();
        tCPClient.connect();
    }

    @Nullable
    public final String send(@NotNull String string, @NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"message");
        return (String)BuildersKt.runBlocking((CoroutineContext)Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(string, string2, null){
            public int label;
            public final /* synthetic */ String $serviceId;
            public final /* synthetic */ String $message;
            {
                this.$serviceId = string;
                this.$message = string2;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var1_8;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                    ResultKt.throwOnFailure((Object)object);
                    Channel channel = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
                    TCPClient.access$getMChannelMap$p().put(this.$serviceId, channel);
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                    function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$serviceId, null){
                        public int label;
                        public final /* synthetic */ String $serviceId;
                        {
                            this.$serviceId = string;
                            super(2, continuation);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            block6: {
                                Object object2;
                                block7: {
                                    block3: {
                                        block4: {
                                            block5: {
                                                object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                int n = this.label;
                                                if (n == 0) break block3;
                                                if (n == 1) break block4;
                                                if (n != 2) break block5;
                                                ResultKt.throwOnFailure((Object)object);
                                                break block6;
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        ResultKt.throwOnFailure((Object)object);
                                        break block7;
                                    }
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    if (DelayKt.delay((long)10000L, (Continuation)this) == object2) {
                                        return object2;
                                    }
                                }
                                object = (Channel)TCPClient.access$getMChannelMap$p().get(this.$serviceId);
                                if (object != null) {
                                    BaseResult baseResult;
                                    Object object3 = object;
                                    object = baseResult;
                                    baseResult = new BaseResult();
                                    String string = String.valueOf(System.currentTimeMillis());
                                    String string2 = this.$serviceId;
                                    object = new Gson().toJson(new ResponseData<Object>(504, object, string, string2, "time out"));
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().toJson(ResponseData(ResponseCode.CODE_TIME_OUT, BaseResult(), System.currentTimeMillis().toString(), serviceId, \"time out\"))");
                                    this.label = 2;
                                    if (object3.send(object, (Continuation)this) == object2) {
                                        return object2;
                                    }
                                }
                            }
                            TCPClient.INSTANCE.consumeChannel(this.$serviceId);
                            return Unit.INSTANCE;
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                            return new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                            return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                        }
                    };
                    Job job2 = BuildersKt.launch$default((CoroutineScope)GlobalScope.INSTANCE, null, null, (Function2)function22, (int)3, null);
                    TCPClient.access$getMJobMap$p().put(this.$serviceId, job2);
                    TCPClient tCPClient = TCPClient.INSTANCE;
                    String string = this.$message;
                    Charset charset = Charsets.UTF_8;
                    if (string == null) throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    TCPClient.access$writeToOutputStream(tCPClient, byArray);
                    Channel channel2 = (Channel)TCPClient.access$getMChannelMap$p().get(this.$serviceId);
                    if (channel2 == null) {
                        return null;
                    }
                    this.label = 1;
                    Object object3 = channel2.receive((Continuation)this);
                    if (object3 == object2) {
                        return object2;
                    }
                }
                String string = (String)var1_8;
                return string;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                var v0 = object2;
                Object object2 = v0.$serviceId;
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super String> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void sendHeartBeat() {
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        TCPClient tCPClient = tCPClient2;
        TCPClient tCPClient2 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            public int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                int n = this.label;
                if (n != 0) {
                    if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    ResultKt.throwOnFailure((Object)object);
                } else {
                    ResultKt.throwOnFailure((Object)object);
                    this.label = 1;
                    if (DelayKt.delay((long)60000L, (Continuation)this) == object2) {
                        return object2;
                    }
                }
                TCPClient.INSTANCE.disconnect();
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                return new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope coroutineScope, @Nullable Continuation<? super Unit> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        };
        mHeartBeatJob = BuildersKt.launch$default((CoroutineScope)GlobalScope.INSTANCE, null, null, (Function2)tCPClient2, (int)3, null);
        byte[] byArray = "ping".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        tCPClient.writeToOutputStream(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        Object object = mConnectThread;
        if (object != null) {
            ((Thread)object).isInterrupted();
        }
        object = mReceiveThread;
        if (object != null) {
            ((SocketReceiveThread)object).threadExit();
        }
        mConnectState = 3;
        this.onConnectStateChanged(3);
        object = mHeartBeatHandler;
        if (object != null) {
            object.removeCallbacks((Runnable)mHeartBeatRunnable);
        }
        TCPClient tCPClient = this;
        tCPClient.clearChannelMap();
        tCPClient.clearJobMap();
        try {
            object = mOutStream;
            if (object != null) {
                ((OutputStream)object).close();
            }
            object = mInStream;
            if (object != null) {
                ((InputStream)object).close();
            }
            this.getMSocket().close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void onDestroy() {
        this.disconnect();
        mConnectListeners.clear();
    }

    public final void consumeChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"serviceId");
        mChannelMap.remove(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void consumeJob(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"serviceId");
        TCPClient tCPClient = mJobMap.get(string);
        if (tCPClient != null && !tCPClient.isCompleted() && (tCPClient = mJobMap.get(string)) != null) {
            Job.DefaultImpls.cancel$default((Job)tCPClient, null, (int)1, null);
        }
        mJobMap.remove(string);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/transsion/iot/communication/tcp/TCPClient$SocketConnectThread;", "Ljava/lang/Thread;", "", "run", "()V", "<init>", "communication_release"})
    public static final class SocketConnectThread
    extends Thread {
        @Override
        public void run() {
            TCPClient tCPClient;
            TCPClient tCPClient2;
            TCPClient tCPClient3;
            try {
                TCPClient tCPClient4 = INSTANCE;
                tCPClient3 = tCPClient4;
                tCPClient2 = tCPClient4;
                tCPClient = tCPClient4;
                tCPClient4.setMSocket(new Socket(ip, port));
                mOutStream = tCPClient4.getMSocket().getOutputStream();
                mInStream = tCPClient4.getMSocket().getInputStream();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                TCPClient tCPClient5 = INSTANCE;
                String string = exception.getMessage();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("connect failed:");
                stringBuilder.append(string);
                tCPClient5.onError(stringBuilder.toString());
                mConnectState = 3;
                tCPClient5.onConnectStateChanged(3);
                return;
            }
            Log.i((String)TAG, (String)"connect success");
            mConnectState = 2;
            tCPClient.onConnectStateChanged(2);
            reconnectCount = 0;
            tCPClient3.initReceiveThread();
            tCPClient2.initSendHandler();
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\b\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/transsion/iot/communication/tcp/TCPClient$SocketReceiveThread;", "Ljava/lang/Thread;", "", "run", "()V", "threadExit", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "<init>", "communication_release"})
    public static final class SocketReceiveThread
    extends Thread {
        @NotNull
        private AtomicBoolean threadExit;

        public SocketReceiveThread() {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean(false);
            v1.threadExit = atomicBoolean2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = new byte[40960];
            while (!this.threadExit.get()) {
                block19: {
                    block18: {
                        try {
                            var2_2 = TCPClient.access$getMInStream$p();
                            if (var2_2 != null) break block18;
                            var2_2 = null;
                            break block19;
                        }
                        catch (IOException var2_3) {
                            var2_3.printStackTrace();
                            var2_2 = var2_3.getMessage();
                            v0 = new StringBuilder();
                            v0.append("receive failed: ");
                            v0.append((String)var2_2);
                            TCPClient.access$onError(TCPClient.INSTANCE, v0.toString());
                            this.threadExit();
                            continue;
                        }
                    }
                    var2_2 = var2_2.read(var1_1);
                }
                if (var2_2 == null) ** GOTO lbl60
                var3_4 = -1;
                if (var2_2.intValue() == var3_4) ** GOTO lbl60
                var3_4 = 0;
                var4_6 = var2_2.intValue();
                var5_7 = v1;
                v1 = new String(var1_1, var3_4, var4_6, Charsets.UTF_8);
                v2 = TCPClient.access$getTAG$p();
                var3_5 = v3;
                v4 = var2_2;
                v5 = var3_5;
                v6 = v5;
                v7 = v5;
                v8 = var5_7;
                v9 = var3_5;
                v9();
                v9.append("read buffer:");
                v6.append(v8);
                v7.append(",count=");
                v3.append(v4);
                Log.i((String)v2, (String)v3.toString());
                TCPClient.access$parseToRespData(TCPClient.INSTANCE, var5_7);
                continue;
lbl60:
                // 2 sources

                v10 = TCPClient.access$getTAG$p();
                v11 = var2_2;
                v12 = new StringBuilder();
                v12.append("read count ");
                v12.append(v11);
                Log.i((String)v10, (String)v12.toString());
                TCPClient.access$onError(TCPClient.INSTANCE, "receive failed: -1");
                break;
            }
        }

        public final void threadExit() {
            this.threadExit.set(true);
        }
    }
}

