/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iotcardsdk;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import com.eightbitlab.rxbus.Bus;
import com.eightbitlab.rxbus.BusKt;
import com.transsion.iotcardsdk.IControlsActionCallback;
import com.transsion.iotcardsdk.IControlsProvider;
import com.transsion.iotcardsdk.IControlsSubscriber;
import com.transsion.iotcardsdk.IControlsSubscription;
import com.transsion.iotcardsdk.bean.ControlAction;
import com.transsion.iotcardsdk.bean.ControlActionWrapper;
import com.transsion.iotcardsdk.bean.IotCardTemplateActionWrapper;
import com.transsion.iotcardsdk.bean.IotCardTemplateBean;
import com.transsion.iotcardsdk.bean.IotCardTemplatePublisherWrapper;
import com.transsion.iotcardsdk.bean.UnregisterAction;
import com.transsion.iotcardsdk.event.EventBean;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import rx.Observable;
import rx.functions.Action1;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 42\u00020\u0001:\u000534567B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH&J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0017J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0002J&\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H&J\u000e\u0010,\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0014\u0010/\u001a\u00020\"2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService;", "Landroid/app/Service;", "()V", "mHandler", "Lcom/transsion/iotcardsdk/DeviceProviderService$RequestHandler;", "mToken", "Landroid/os/IBinder;", "getMToken", "()Landroid/os/IBinder;", "setMToken", "(Landroid/os/IBinder;)V", "registerDeviceList", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/transsion/iotcardsdk/bean/IotCardTemplateBean;", "getRegisterDeviceList", "()Ljava/util/concurrent/ConcurrentHashMap;", "setRegisterDeviceList", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "subscriber", "Lcom/transsion/iotcardsdk/IControlsSubscriber;", "getSubscriber", "()Lcom/transsion/iotcardsdk/IControlsSubscriber;", "setSubscriber", "(Lcom/transsion/iotcardsdk/IControlsSubscriber;)V", "getRegisterDevices", "", "isRegister", "", "iotCardTemplateBean", "onBind", "intent", "Landroid/content/Intent;", "onCreate", "", "onDestroy", "onMessageEvent", "performControlAction", "controlId", "action", "Lcom/transsion/iotcardsdk/bean/ControlAction;", "consumer", "Lio/reactivex/functions/Consumer;", "", "registerDevice", "unregisterDevice", "updateDevice", "wrapDeviceCardInfoBean", "iotCardTemplatePublisherWrapper", "Lio/reactivex/Flowable;", "Lcom/transsion/iotcardsdk/bean/IotCardTemplatePublisherWrapper;", "ActionMessage", "Companion", "RequestHandler", "SubscriberProxy", "SubscriptionAdapter", "iotcardsdk_release"})
public abstract class DeviceProviderService
extends Service {
    private RequestHandler mHandler;
    @Nullable
    private IBinder mToken;
    @Nullable
    private IControlsSubscriber subscriber;
    @NotNull
    private ConcurrentHashMap<String, IotCardTemplateBean> registerDeviceList = new ConcurrentHashMap();
    @NotNull
    public static final String TAG = "DeviceProviderService";
    public static final int MSG_LOAD = 1;
    public static final int MSG_ACTION = 3;
    @NotNull
    public static final String CALLBACK_BUNDLE = "CALLBACK_BUNDLE";
    @NotNull
    public static final String CALLBACK_TOKEN = "CALLBACK_TOKEN";
    @NotNull
    public static final String KEY_BUNDLE_IOT = "iot_bundle";
    @NotNull
    public static final String ACTION = "com.transsion.iotservice.iotcard.ControlsProviderService";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void onCreate() {
        this.onMessageEvent();
        super.onCreate();
    }

    public void onDestroy() {
        Bus.INSTANCE.unregister((Object)this);
        super.onDestroy();
    }

    @Nullable
    public final IBinder getMToken() {
        return this.mToken;
    }

    public final void setMToken(@Nullable IBinder iBinder) {
        this.mToken = iBinder;
    }

    @Nullable
    public final IControlsSubscriber getSubscriber() {
        return this.subscriber;
    }

    public final void setSubscriber(@Nullable IControlsSubscriber iControlsSubscriber) {
        this.subscriber = iControlsSubscriber;
    }

    @NotNull
    public final ConcurrentHashMap<String, IotCardTemplateBean> getRegisterDeviceList() {
        return this.registerDeviceList;
    }

    public final void setRegisterDeviceList(@NotNull ConcurrentHashMap<String, IotCardTemplateBean> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, (String)"<set-?>");
        this.registerDeviceList = concurrentHashMap;
    }

    @NotNull
    public abstract List<IotCardTemplateBean> getRegisterDevices();

    public abstract void performControlAction(@NotNull String var1, @NotNull ControlAction var2, @NotNull Consumer<Integer> var3);

    @RequiresApi(value=30)
    @NotNull
    public IBinder onBind(@NotNull Intent intent) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.mHandler = new RequestHandler(Looper.getMainLooper());
        Bundle bundle2 = bundle = intent.getBundleExtra(CALLBACK_BUNDLE);
        Intrinsics.checkNotNull((Object)bundle2);
        this.mToken = bundle2.getBinder(CALLBACK_TOKEN);
        return (IBinder)new IControlsProvider.Stub(this){
            final /* synthetic */ DeviceProviderService this$0;

            public void load(@Nullable IControlsSubscriber subscriber) {
                this.this$0.getRegisterDeviceList().clear();
                this.this$0.setSubscriber(subscriber);
                RequestHandler requestHandler = DeviceProviderService.access$getMHandler$p(this.this$0);
                Intrinsics.checkNotNull((Object)((Object)requestHandler));
                requestHandler.obtainMessage(1, subscriber).sendToTarget();
            }

            public void action(@NotNull String controlId, @NotNull ControlActionWrapper action, @NotNull IControlsActionCallback cb) {
                Intrinsics.checkNotNullParameter((Object)controlId, (String)"controlId");
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
                ActionMessage msg = new ActionMessage(controlId, action.getWrappedAction(), cb);
                RequestHandler requestHandler = DeviceProviderService.access$getMHandler$p(this.this$0);
                Intrinsics.checkNotNull((Object)((Object)requestHandler));
                requestHandler.obtainMessage(3, msg).sendToTarget();
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public final synchronized void registerDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.e((String)TAG, (String)("registerDevice:iotCardTemplateBean :" + iotCardTemplateBean.getDataBundle()));
        if (!this.registerDeviceList.containsKey(iotCardTemplateBean.getControlId())) {
            ((Map)this.registerDeviceList).put(iotCardTemplateBean.getControlId(), iotCardTemplateBean);
            IotCardTemplatePublisherWrapper iotCardTemplatePublisherWrapper = new IotCardTemplatePublisherWrapper(new IotCardTemplateActionWrapper("register", iotCardTemplateBean));
            Flowable flowable = Flowable.just((Object)iotCardTemplatePublisherWrapper);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"Flowable.just(iotCardTemplatePublisherWrapper)");
            this.wrapDeviceCardInfoBean((Flowable<IotCardTemplatePublisherWrapper>)flowable);
        } else {
            Log.e((String)TAG, (String)"registerDevice: iotCardTemplateBean have  registered  ");
        }
    }

    public final synchronized void unregisterDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.e((String)TAG, (String)("unregisterDevice:iotCardTemplateBean :" + iotCardTemplateBean.getDataBundle()));
        if (this.registerDeviceList.containsKey(iotCardTemplateBean.getControlId())) {
            this.registerDeviceList.remove(iotCardTemplateBean.getControlId());
            IotCardTemplatePublisherWrapper iotCardTemplatePublisherWrapper = new IotCardTemplatePublisherWrapper(new IotCardTemplateActionWrapper("unRegister", iotCardTemplateBean));
            Flowable flowable = Flowable.just((Object)iotCardTemplatePublisherWrapper);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"Flowable.just(iotCardTemplatePublisherWrapper)");
            this.wrapDeviceCardInfoBean((Flowable<IotCardTemplatePublisherWrapper>)flowable);
        } else {
            Log.e((String)TAG, (String)"unRegisterDevice:  iotCardTemplateBean haven`t  registered  ");
        }
    }

    public final synchronized void updateDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.e((String)TAG, (String)("updateDevice:iotCardTemplateBean :" + iotCardTemplateBean.getDataBundle()));
        if (this.registerDeviceList.containsKey(iotCardTemplateBean.getControlId())) {
            IotCardTemplatePublisherWrapper iotCardTemplatePublisherWrapper = new IotCardTemplatePublisherWrapper(new IotCardTemplateActionWrapper("update", iotCardTemplateBean));
            Flowable flowable = Flowable.just((Object)iotCardTemplatePublisherWrapper);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"Flowable.just(iotCardTemplatePublisherWrapper)");
            this.wrapDeviceCardInfoBean((Flowable<IotCardTemplatePublisherWrapper>)flowable);
        } else {
            Log.e((String)TAG, (String)"updateDevice isn`t allowed to execute because iotCardTemplateBean haven`t registered  ");
        }
    }

    public final synchronized boolean isRegister(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        return this.registerDeviceList.containsKey(iotCardTemplateBean.getControlId());
    }

    public final synchronized void wrapDeviceCardInfoBean(@NotNull Flowable<IotCardTemplatePublisherWrapper> iotCardTemplatePublisherWrapper) {
        block0: {
            Intrinsics.checkNotNullParameter(iotCardTemplatePublisherWrapper, (String)"iotCardTemplatePublisherWrapper");
            IControlsSubscriber iControlsSubscriber = this.subscriber;
            if (iControlsSubscriber == null) break block0;
            IControlsSubscriber iControlsSubscriber2 = iControlsSubscriber;
            boolean bl = false;
            boolean bl2 = false;
            IControlsSubscriber it = iControlsSubscriber2;
            boolean bl3 = false;
            SubscriberProxy proxy = new SubscriberProxy((Context)this, this.mToken, it);
            iotCardTemplatePublisherWrapper.subscribe((Subscriber)proxy);
        }
    }

    private final void onMessageEvent() {
        Bus this_$iv = Bus.INSTANCE;
        Observable observable = this_$iv.getBus().ofType(EventBean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"bus.ofType(T::class.java)");
        rx.Subscription subscription = observable.subscribe((Action1)new Action1<EventBean>(this){
            final /* synthetic */ DeviceProviderService this$0;

            public final void call(EventBean it) {
                switch (it.getEventTypeId()) {
                    case 0: {
                        Log.d((String)"DeviceProviderService", (String)"registerDevice");
                        this.this$0.registerDevice(it.getDeviceBean());
                        break;
                    }
                    case 1: {
                        Log.d((String)"DeviceProviderService", (String)"unregisterDevice");
                        this.this$0.unregisterDevice(it.getDeviceBean());
                        break;
                    }
                    case 2: {
                        Log.d((String)"DeviceProviderService", (String)"updateDevice");
                        this.this$0.updateDevice(it.getDeviceBean());
                        break;
                    }
                }
            }
            {
                this.this$0 = deviceProviderService;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)subscription, (String)"Bus.observe<EventBean>()\u2026}\n            }\n        }");
        BusKt.registerInBus((rx.Subscription)subscription, (Object)((Object)this));
    }

    public static final /* synthetic */ RequestHandler access$getMHandler$p(DeviceProviderService $this) {
        return $this.mHandler;
    }

    public static final /* synthetic */ void access$setMHandler$p(DeviceProviderService $this, RequestHandler requestHandler) {
        $this.mHandler = requestHandler;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService$RequestHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "(Lcom/transsion/iotcardsdk/DeviceProviderService;Landroid/os/Looper;)V", "consumerFor", "Lio/reactivex/functions/Consumer;", "", "controlId", "", "cb", "Lcom/transsion/iotcardsdk/IControlsActionCallback;", "handleMessage", "", "msg", "Landroid/os/Message;", "iotcardsdk_release"})
    @RequiresApi(value=30)
    private final class RequestHandler
    extends Handler {
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            switch (msg.what) {
                case 1: {
                    List<IotCardTemplateBean> deviceList = DeviceProviderService.this.getRegisterDevices();
                    Iterable $this$forEach$iv = deviceList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IotCardTemplateBean it = (IotCardTemplateBean)element$iv;
                        boolean bl = false;
                        DeviceProviderService.this.registerDevice(it);
                    }
                    break;
                }
                case 3: {
                    Object object = msg.obj;
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.transsion.iotcardsdk.DeviceProviderService.ActionMessage");
                    }
                    ActionMessage aMsg = (ActionMessage)object;
                    if (aMsg.getMAction() instanceof UnregisterAction) {
                        DeviceProviderService.this.setSubscriber(null);
                        break;
                    }
                    DeviceProviderService.this.performControlAction(aMsg.getMControlId(), aMsg.getMAction(), this.consumerFor(aMsg.getMControlId(), aMsg.getMCb()));
                    break;
                }
            }
        }

        @SuppressLint(value={"RestrictedApi"})
        private final Consumer<Integer> consumerFor(String controlId, IControlsActionCallback cb) {
            return (Consumer)new Consumer<Integer>(this, cb, controlId){
                final /* synthetic */ RequestHandler this$0;
                final /* synthetic */ IControlsActionCallback $cb;
                final /* synthetic */ String $controlId;

                public final void accept(int response) {
                    Preconditions.checkNotNull((Object)response);
                    try {
                        this.$cb.accept(this.this$0.DeviceProviderService.this.getMToken(), this.$controlId, response);
                    }
                    catch (RemoteException ex) {
                        Intrinsics.checkNotNullExpressionValue((Object)ex.rethrowAsRuntimeException(), (String)"ex.rethrowAsRuntimeException()");
                    }
                }
                {
                    this.this$0 = requestHandler;
                    this.$cb = iControlsActionCallback;
                    this.$controlId = string;
                }
            };
        }

        public RequestHandler(Looper looper) {
            Looper looper2 = looper;
            Intrinsics.checkNotNull((Object)looper2);
            super(looper2);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B#\b\u0010\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0000\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService$SubscriberProxy;", "Lorg/reactivestreams/Subscriber;", "Lcom/transsion/iotcardsdk/bean/IotCardTemplatePublisherWrapper;", "context", "Landroid/content/Context;", "token", "Landroid/os/IBinder;", "cs", "Lcom/transsion/iotcardsdk/IControlsSubscriber;", "(Landroid/content/Context;Landroid/os/IBinder;Lcom/transsion/iotcardsdk/IControlsSubscriber;)V", "mToken", "mCs", "(Landroid/os/IBinder;Lcom/transsion/iotcardsdk/IControlsSubscriber;)V", "mContext", "onComplete", "", "onError", "t", "", "onNext", "p0", "onSubscribe", "s", "Lorg/reactivestreams/Subscription;", "iotcardsdk_release"})
    private static final class SubscriberProxy
    implements Subscriber<IotCardTemplatePublisherWrapper> {
        private Context mContext;
        private final IBinder mToken;
        private final IControlsSubscriber mCs;

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            try {
                this.mCs.onError(this.mToken, t.toString());
            }
            catch (RemoteException ex) {
                if (Build.VERSION.SDK_INT >= 30) {
                    Intrinsics.checkNotNullExpressionValue((Object)ex.rethrowAsRuntimeException(), (String)"ex.rethrowAsRuntimeException()");
                }
                ex.printStackTrace();
            }
        }

        public void onComplete() {
            try {
                this.mCs.onComplete(this.mToken);
            }
            catch (RemoteException ex) {
                if (Build.VERSION.SDK_INT >= 30) {
                    Intrinsics.checkNotNullExpressionValue((Object)ex.rethrowAsRuntimeException(), (String)"ex.rethrowAsRuntimeException()");
                }
                ex.printStackTrace();
            }
        }

        public void onNext(@Nullable IotCardTemplatePublisherWrapper p0) {
            this.mCs.onNext(this.mToken, p0);
        }

        public void onSubscribe(@Nullable Subscription s) {
            block4: {
                Subscription subscription = s;
                if (subscription == null) break block4;
                Subscription subscription2 = subscription;
                boolean bl = false;
                boolean bl2 = false;
                Subscription it = subscription2;
                boolean bl3 = false;
                try {
                    this.mCs.onSubscribe(this.mToken, new SubscriptionAdapter(it));
                    Unit unit = Unit.INSTANCE;
                }
                catch (RemoteException ex) {
                    RuntimeException runtimeException;
                    if (Build.VERSION.SDK_INT >= 30) {
                        RuntimeException runtimeException2 = ex.rethrowAsRuntimeException();
                        runtimeException = runtimeException2;
                        Intrinsics.checkNotNullExpressionValue((Object)runtimeException2, (String)"ex.rethrowAsRuntimeException()");
                    } else {
                        ex.printStackTrace();
                        runtimeException = Unit.INSTANCE;
                    }
                    RuntimeException runtimeException3 = runtimeException;
                }
            }
        }

        public SubscriberProxy(@Nullable IBinder mToken, @NotNull IControlsSubscriber mCs) {
            Intrinsics.checkNotNullParameter((Object)mCs, (String)"mCs");
            this.mToken = mToken;
            this.mCs = mCs;
        }

        public SubscriberProxy(@Nullable Context context, @Nullable IBinder token, @NotNull IControlsSubscriber cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this(token, cs);
            this.mContext = context;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService$SubscriptionAdapter;", "Lcom/transsion/iotcardsdk/IControlsSubscription$Stub;", "mSubscription", "Lorg/reactivestreams/Subscription;", "(Lorg/reactivestreams/Subscription;)V", "getMSubscription", "()Lorg/reactivestreams/Subscription;", "cancel", "", "request", "n", "", "iotcardsdk_release"})
    private static final class SubscriptionAdapter
    extends IControlsSubscription.Stub {
        @NotNull
        private final Subscription mSubscription;

        @Override
        public void request(long n) {
            this.mSubscription.request(n);
        }

        @Override
        public void cancel() {
            this.mSubscription.cancel();
        }

        @NotNull
        public final Subscription getMSubscription() {
            return this.mSubscription;
        }

        public SubscriptionAdapter(@NotNull Subscription mSubscription) {
            Intrinsics.checkNotNullParameter((Object)mSubscription, (String)"mSubscription");
            this.mSubscription = mSubscription;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService$ActionMessage;", "", "mControlId", "", "mAction", "Lcom/transsion/iotcardsdk/bean/ControlAction;", "mCb", "Lcom/transsion/iotcardsdk/IControlsActionCallback;", "(Ljava/lang/String;Lcom/transsion/iotcardsdk/bean/ControlAction;Lcom/transsion/iotcardsdk/IControlsActionCallback;)V", "getMAction", "()Lcom/transsion/iotcardsdk/bean/ControlAction;", "getMCb", "()Lcom/transsion/iotcardsdk/IControlsActionCallback;", "getMControlId", "()Ljava/lang/String;", "iotcardsdk_release"})
    private static final class ActionMessage {
        @NotNull
        private final String mControlId;
        @NotNull
        private final ControlAction mAction;
        @NotNull
        private final IControlsActionCallback mCb;

        @NotNull
        public final String getMControlId() {
            return this.mControlId;
        }

        @NotNull
        public final ControlAction getMAction() {
            return this.mAction;
        }

        @NotNull
        public final IControlsActionCallback getMCb() {
            return this.mCb;
        }

        public ActionMessage(@NotNull String mControlId, @NotNull ControlAction mAction, @NotNull IControlsActionCallback mCb) {
            Intrinsics.checkNotNullParameter((Object)mControlId, (String)"mControlId");
            Intrinsics.checkNotNullParameter((Object)mAction, (String)"mAction");
            Intrinsics.checkNotNullParameter((Object)mCb, (String)"mCb");
            this.mControlId = mControlId;
            this.mAction = mAction;
            this.mCb = mCb;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/transsion/iotcardsdk/DeviceProviderService$Companion;", "", "()V", "ACTION", "", "CALLBACK_BUNDLE", "CALLBACK_TOKEN", "KEY_BUNDLE_IOT", "MSG_ACTION", "", "MSG_LOAD", "TAG", "iotcardsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

