/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iotcardsdk;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.iotcardsdk.IControlsActionCallback;
import com.transsion.iotcardsdk.IControlsSubscriber;
import com.transsion.iotcardsdk.bean.ControlActionWrapper;

public interface IControlsProvider
extends IInterface {
    public void load(IControlsSubscriber var1) throws RemoteException;

    public void action(String var1, ControlActionWrapper var2, IControlsActionCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IControlsProvider {
        private static final String DESCRIPTOR = "com.transsion.iotcardsdk.IControlsProvider";
        static final int TRANSACTION_load = 1;
        static final int TRANSACTION_action = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IControlsProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IControlsProvider) {
                return (IControlsProvider)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IControlsSubscriber _arg0 = IControlsSubscriber.Stub.asInterface(data.readStrongBinder());
                    this.load(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ControlActionWrapper _arg1 = 0 != data.readInt() ? ControlActionWrapper.CREATOR.createFromParcel(data) : null;
                    IControlsActionCallback _arg2 = IControlsActionCallback.Stub.asInterface(data.readStrongBinder());
                    this.action(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IControlsProvider impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IControlsProvider getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IControlsProvider {
            private IBinder mRemote;
            public static IControlsProvider sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void load(IControlsSubscriber subscriber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(subscriber != null ? subscriber.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().load(subscriber);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void action(String controlId, ControlActionWrapper action, IControlsActionCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(controlId);
                    if (action != null) {
                        _data.writeInt(1);
                        action.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(cb != null ? cb.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().action(controlId, action, cb);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IControlsProvider {
        @Override
        public void load(IControlsSubscriber subscriber) throws RemoteException {
        }

        @Override
        public void action(String controlId, ControlActionWrapper action, IControlsActionCallback cb) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

