/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.iotcardsdk;

import android.util.Log;
import com.eightbitlab.rxbus.Bus;
import com.transsion.iotcardsdk.bean.EmptyTemplateBean;
import com.transsion.iotcardsdk.bean.IotCardTemplateBean;
import com.transsion.iotcardsdk.event.EventBean;
import com.transsion.iotcardsdk.exception.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/transsion/iotcardsdk/SdkInit;", "", "()V", "REGISTER", "", "TAG", "", "UNREGISTER", "UPDATE", "className", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "packageName", "getPackageName", "setPackageName", "checkParametersLegal", "", "controlId", "getVersion", "registerDevice", "iotCardTemplateBean", "Lcom/transsion/iotcardsdk/bean/IotCardTemplateBean;", "unregisterDevice", "updateDevice", "iotcardsdk_release"})
public final class SdkInit {
    @NotNull
    public static final String TAG = "SdkInit";
    public static final int REGISTER = 0;
    public static final int UNREGISTER = 1;
    public static final int UPDATE = 2;
    @Nullable
    private static String packageName;
    @Nullable
    private static String className;
    @NotNull
    public static final SdkInit INSTANCE;

    @Nullable
    public final String getPackageName() {
        return packageName;
    }

    public final void setPackageName(@Nullable String string) {
        packageName = string;
    }

    @Nullable
    public final String getClassName() {
        return className;
    }

    public final void setClassName(@Nullable String string) {
        className = string;
    }

    @NotNull
    public final String getVersion() {
        return "1.0.25";
    }

    public final synchronized void registerDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.d((String)"DeviceProviderService", (String)("registerDevice " + iotCardTemplateBean + ' '));
        this.checkParametersLegal(iotCardTemplateBean.getControlId(), iotCardTemplateBean.getPackageName());
        Bus.INSTANCE.send((Object)new EventBean(0, iotCardTemplateBean));
    }

    public final synchronized void unregisterDevice(@NotNull String controlId, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)controlId, (String)"controlId");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"DeviceProviderService", (String)("unregisterDevice " + controlId + ' '));
        this.checkParametersLegal(controlId, packageName);
        Bus.INSTANCE.send((Object)new EventBean(1, new EmptyTemplateBean(controlId, packageName)));
    }

    public final synchronized void unregisterDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.d((String)"DeviceProviderService", (String)("unregisterDevice " + iotCardTemplateBean + ' '));
        this.checkParametersLegal(iotCardTemplateBean.getControlId(), iotCardTemplateBean.getPackageName());
        Bus.INSTANCE.send((Object)new EventBean(1, iotCardTemplateBean));
    }

    public final synchronized void updateDevice(@NotNull IotCardTemplateBean iotCardTemplateBean) {
        Intrinsics.checkNotNullParameter((Object)iotCardTemplateBean, (String)"iotCardTemplateBean");
        Log.d((String)"DeviceProviderService", (String)("updateDevice " + iotCardTemplateBean + ' '));
        this.checkParametersLegal(iotCardTemplateBean.getControlId(), iotCardTemplateBean.getPackageName());
        Bus.INSTANCE.send((Object)new EventBean(2, iotCardTemplateBean));
    }

    private final void checkParametersLegal(String controlId, String packageName) {
        CharSequence charSequence = packageName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new InvalidParameterException("packageName cannot be empty ");
        }
        charSequence = controlId;
        bl = false;
        bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new InvalidParameterException("controlId cannot be empty ");
        }
    }

    private SdkInit() {
    }

    static {
        SdkInit sdkInit;
        INSTANCE = sdkInit = new SdkInit();
    }
}

