/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.aidatacenter.exported.data;

import android.os.SystemClock;
import android.text.TextUtils;
import com.transsion.kolun.aidatacenter.exported.data.CommonData;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixSensorData
extends CommonData {
    protected static final Map<String, Integer> sSensorSizeMap = new HashMap<String, Integer>();
    private static final Map<String, SensorData> sSensorLastValue = new HashMap<String, SensorData>();
    public static final String SENSOR_TYPES = "sensor_types";
    public static final String SENSOR_DATA = "sensor_data";
    public static final String TIMESTAMP = "timestamp";
    public static final String VALUES = "values";
    public static final String ACCURACY = "accuracy";
    public static final String TYPE = "type";
    protected List<String> listenSensorTypeList = new ArrayList<String>();
    protected final Map<String, SensorData> dataMap = new HashMap<String, SensorData>();
    private long sensorTime = 0L;
    private long sensorFirstTime = 0L;
    private long bootTime = 0L;

    @Override
    protected void onDataUpdate() {
        try {
            JSONObject data = new JSONObject(this.getData());
            String types = data.optString(SENSOR_TYPES);
            if (!TextUtils.isEmpty((CharSequence)types)) {
                types = types.trim().replace("[", "").replace("]", "").replace(" ", "");
            }
            this.listenSensorTypeList = Arrays.asList(types.split(","));
            JSONArray sensorDataList = new JSONArray(data.optString(SENSOR_DATA));
            for (int i = 0; i < sensorDataList.length(); ++i) {
                JSONObject jb = new JSONObject(sensorDataList.optString(i));
                SensorData sd = new SensorData();
                sd.sensorType = jb.optInt(TYPE);
                sd.accuracy = jb.optInt(ACCURACY);
                SensorData.access$202(sd, MixSensorData.toIntFloat(jb.optString(VALUES)));
                sd.timestamp = jb.optLong(TIMESTAMP);
                if (this.sensorFirstTime == 0L || sd.timestamp < this.sensorFirstTime) {
                    this.sensorFirstTime = sd.timestamp;
                }
                if (sd.timestamp > this.sensorTime) {
                    this.sensorTime = sd.timestamp;
                }
                this.dataMap.put(String.valueOf(sd.sensorType), sd);
                sSensorLastValue.put(String.valueOf(sd.sensorType), sd);
            }
            this.bootTime = System.currentTimeMillis() - SystemClock.elapsedRealtime();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static float[] toIntFloat(String dataStr) {
        String[] strArr = dataStr.replace("[", "").replace("]", "").split(",");
        float[] result = new float[strArr.length];
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        for (int i = 0; i < strArr.length; ++i) {
            result[i] = Float.parseFloat(decimalFormat.format(Float.parseFloat(strArr[i])));
        }
        return result;
    }

    public String toMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sensorTime);
        this.listenSensorTypeList.forEach(type -> {
            SensorData sd;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((sd = this.dataMap.get(type)) == null) {
                sb.append(this.buildNull((String)type));
            } else {
                sb.append(sd.values());
            }
        });
        return sb.toString();
    }

    public float[] getSensorValue(int sensorType) {
        SensorData data = this.dataMap.get(String.valueOf(sensorType));
        if (data == null) {
            return null;
        }
        return data.values;
    }

    private String buildNull(String type) {
        Integer count = sSensorSizeMap.get(type);
        if (count == null) {
            return "null,null,null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("null");
        }
        return sb.toString();
    }

    protected int getSensorValueSize(String type) {
        Integer sensorValueSize = sSensorSizeMap.get(type);
        if (sensorValueSize == null) {
            return 3;
        }
        return sensorValueSize;
    }

    public long getSensorTime() {
        return this.bootTime + this.sensorTime;
    }

    public String toMessageV2() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sensorFirstTime);
        this.listenSensorTypeList.forEach(type -> {
            SensorData sd;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((sd = this.dataMap.get(type)) == null) {
                sb.append(this.getLast((String)type).values());
            } else {
                sb.append(sd.values());
            }
        });
        return sb.toString();
    }

    private SensorData getLast(String type) {
        SensorData sd = sSensorLastValue.get(type);
        if (sd == null) {
            Integer count = sSensorSizeMap.get(type);
            if (count == null) {
                count = 3;
            }
            sd = new SensorData();
            SensorData.access$202(sd, new float[count.intValue()]);
            for (int i = 0; i < count; ++i) {
                ((SensorData)sd).values[i] = 0.0f;
            }
            sd.timestamp = SystemClock.elapsedRealtime();
        }
        sSensorLastValue.put(type, sd);
        return sd;
    }

    static {
        sSensorSizeMap.put(String.valueOf(1), 3);
        sSensorSizeMap.put(String.valueOf(2), 3);
        sSensorSizeMap.put(String.valueOf(4), 3);
        sSensorSizeMap.put(String.valueOf(5), 1);
        sSensorSizeMap.put(String.valueOf(8), 1);
        sSensorSizeMap.put(String.valueOf(9), 3);
        sSensorSizeMap.put(String.valueOf(10), 3);
        sSensorSizeMap.put(String.valueOf(3), 3);
        sSensorSizeMap.put(String.valueOf(18), 1);
    }

    protected static class SensorData {
        private float[] values;
        private int sensorType;
        private int accuracy;
        private long timestamp;
        List<Float> valueList;

        protected SensorData() {
        }

        public String values() {
            StringBuilder sb = new StringBuilder();
            for (float value : this.values) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(value);
            }
            return sb.toString();
        }

        public List<Float> getValueList() {
            if (this.valueList == null) {
                this.valueList = new ArrayList<Float>();
                for (float value : this.values) {
                    this.valueList.add(Float.valueOf(value));
                }
            }
            return this.valueList;
        }

        static /* synthetic */ float[] access$202(SensorData x0, float[] x1) {
            x0.values = x1;
            return x1;
        }
    }
}

