/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import com.transsion.kolun.place.ImportPlaceManager;
import com.transsion.kolun.place.Location;
import com.transsion.kolun.place.Stay;
import com.transsion.kolun.place.Travel;
import com.transsion.kolun.place.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Experience
implements Iterable<Location> {
    public static final String TAG = "Experience-place";
    public static final String CLASS_TYPE = "CLASS_TYPE";
    public static final String START_TIME = "START_TIME";
    public static final String END_TIME = "END_TIME";
    public final long mStartTime;
    public final long mEndTime;
    protected ImportPlaceManager.ImportPlaceProxy mProxy;

    public Experience(long start, long end) {
        this.mStartTime = start;
        this.mEndTime = end;
    }

    public Experience(JSONObject jsonObject) throws JSONException {
        this.mStartTime = jsonObject.getLong(START_TIME);
        this.mEndTime = jsonObject.getLong(END_TIME);
    }

    @Override
    public Iterator<Location> iterator() {
        if (this.mProxy == null) {
            return new ArrayList().iterator();
        }
        return this.mProxy.getLocationList(this.mStartTime, this.mEndTime).iterator();
    }

    public List<Location> getLocations() {
        if (this.mProxy == null) {
            return new ArrayList<Location>();
        }
        return this.mProxy.getLocationList(this.mStartTime, this.mEndTime);
    }

    public int size() {
        if (this.mProxy != null) {
            return this.mProxy.getLocationList(this.mStartTime, this.mEndTime).size();
        }
        return 0;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public void setProxy(ImportPlaceManager.ImportPlaceProxy proxy) {
        this.mProxy = proxy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("size: ").append(this.size());
        sb.append(" start_time ").append(Utils.long2Str(this.getStartTime()));
        sb.append(" end_time ").append(Utils.long2Str(this.getEndTime()));
        return sb.toString();
    }

    public static Experience of(String experienceInfo) throws JSONException {
        String classType;
        JSONObject jsonObject = new JSONObject(experienceInfo);
        if (!jsonObject.has(CLASS_TYPE)) {
            return null;
        }
        switch (classType = jsonObject.getString(CLASS_TYPE)) {
            case "STAY": {
                return new Stay(jsonObject);
            }
            case "TRAVEL": {
                return new Travel(jsonObject);
            }
        }
        return null;
    }

    public long getId() {
        return -1L;
    }
}

