/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.place;

import android.os.RemoteException;

public class GeoFenceClient {
    private double mLon;
    private double mLat;
    private OnArrival mOnArrival;
    private OnDeparture mOnDeparture;

    public void onArrivalDetected(long from, double lat, double lon) throws RemoteException {
        if (this.mOnArrival != null) {
            this.mOnArrival.onArrival(from, lat, lon);
        }
    }

    public void onDepartureDetected(long at, double lat, double lon) throws RemoteException {
        if (this.mOnDeparture != null) {
            this.mOnDeparture.onDeparture(at, lat, lon);
        }
    }

    public double getLat() {
        return this.mLat;
    }

    public double getLon() {
        return this.mLon;
    }

    public static Builder build(double lat, double lon) {
        return new Builder(lat, lon);
    }

    public static class Builder {
        double lat;
        double lon;
        OnArrival onArrival;
        OnDeparture onDeparture;

        Builder(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public Builder setOnArrival(OnArrival onArrival) {
            this.onArrival = onArrival;
            return this;
        }

        public Builder setOnDeparture(OnDeparture onDeparture) {
            this.onDeparture = onDeparture;
            return this;
        }

        public GeoFenceClient build() {
            GeoFenceClient client = new GeoFenceClient();
            client.mLat = this.lat;
            client.mLon = this.lon;
            client.mOnArrival = this.onArrival;
            client.mOnDeparture = this.onDeparture;
            return client;
        }
    }

    public static interface OnDeparture {
        public void onDeparture(long var1, double var3, double var5);
    }

    public static interface OnArrival {
        public void onArrival(long var1, double var3, double var5);
    }
}

